/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.Icon;

public class OverflowIcon
implements Icon {
    private BasicStroke myStroke = new BasicStroke(2.0f);
    private Color myColor;

    public void setColor(Color color) {
        this.myColor = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Object oldAa = NetUtils.antiAliasingOn(g);
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (c.isEnabled()) {
            this.doPaintIcon(g, NetLookAndFeel.getWhite(), x, y + 1, width, height);
        }
        this.doPaintIcon(g, this.myColor, x, y, width, height);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void doPaintIcon(Graphics g, Color color, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        Graphics2D graphics2d = (Graphics2D)g;
        Stroke oldStroke = graphics2d.getStroke();
        Shape oldClip = g.getClip();
        if (color != null) {
            g.setColor(color);
        }
        g.drawLine(x, y + 1, x + width - 2, y + 1);
        g.drawLine(x, y, x + width - 2, y);
        g.drawLine(x, y + height - 3, x + 6, y + height - 3);
        g.drawLine(x, y + height - 2, x + 6, y + height - 2);
        g.drawLine(x, y, x + width - 2, y);
        g.drawLine(x, y + height - 2, x + 6, y + height - 2);
        g.drawLine(x + width - 3, y, x + width - 3, y + 6);
        g.drawLine(x + width - 2, y, x + width - 2, y + 6);
        g.drawLine(x + 1, y, x + 1, y + height - 3);
        g.drawLine(x, y, x, y + height - 3);
        graphics2d.setStroke(this.myStroke);
        g.translate(1, 1);
        g.clipRect(x, y + this.getIconHeight() - 5, x + this.getIconWidth(), 8);
        g.drawLine(x + this.getIconWidth() - 8, y + this.getIconHeight() - 5, x + this.getIconWidth() - 5, y + this.getIconHeight() - 2);
        g.drawLine(x + this.getIconWidth() - 5, y + this.getIconHeight() - 2, x + this.getIconWidth() - 2, y + this.getIconHeight() - 5);
        g.translate(-1, -1);
        graphics2d.setStroke(oldStroke);
        g.setClip(oldClip);
        g.setColor(oldColor);
    }

    @Override
    public int getIconWidth() {
        return 15;
    }

    @Override
    public int getIconHeight() {
        return 12;
    }
}

