/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import com.nokia.laf.NetLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class PArrowIcon
implements SwingConstants,
Icon {
    private static final int INCREMENT = 14;
    private Dimension myIconSize;
    private int myArrowSize;
    private int myOrientation;
    private Color myArrowColor;
    private boolean myUseGradientColor = true;

    public PArrowIcon() {
        this(13, 13, 7, NetLookAndFeel.getControlInfo(), 5);
    }

    public PArrowIcon(int iconSize, int arrowSize) {
        this(iconSize, arrowSize, (Color)NetLookAndFeel.getControlInfo(), 5);
    }

    public PArrowIcon(int iconwidth, int iconHeight, int arrowSize) {
        this(iconwidth, iconHeight, arrowSize, NetLookAndFeel.getControlInfo(), 5);
    }

    public PArrowIcon(int iconSize, int arrowSize, Color color) {
        this(iconSize, iconSize, arrowSize, color == null ? NetLookAndFeel.getControlInfo() : color, 5);
    }

    public PArrowIcon(int iconSize, int arrowSize, Color color, int orientation) {
        this(iconSize, iconSize, arrowSize, color, orientation);
    }

    public PArrowIcon(int iconwidth, int iconHeight, int arrowSize, Color color, int orientation) {
        this(new Dimension(iconwidth, iconHeight), arrowSize, color, orientation);
    }

    public PArrowIcon(Dimension iconSize, int arrowSize, Color color, int orientation) {
        if (arrowSize < 0 || iconSize.height < 0 || iconSize.width < 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        if (orientation != 1 && orientation != 5 && orientation != 3 && orientation != 7) {
            throw new IllegalArgumentException("Orientation must be one of SwingConstants definitions NORTH, SOUTH, EAST or WEST.");
        }
        this.myIconSize = iconSize;
        this.myArrowSize = arrowSize;
        this.myArrowColor = color;
        this.myOrientation = orientation;
    }

    public void setArrowSize(int arrowSize) {
        this.myArrowSize = arrowSize;
    }

    public void setUseGradientColor(boolean useGradientColor) {
        this.myUseGradientColor = useGradientColor;
    }

    @Override
    public int getIconHeight() {
        return this.myIconSize.height;
    }

    @Override
    public int getIconWidth() {
        return this.myIconSize.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color origColor = g.getColor();
        g.setColor(this.myArrowColor);
        int midpoint = this.getIconWidth() / 2;
        int halfArrowHeight = this.myArrowSize / 2;
        boolean isWhite = NetLookAndFeel.getWhite().equals(this.myArrowColor);
        switch (this.myOrientation) {
            case 1: {
                int top = this.getIconHeight() / 2 - halfArrowHeight;
                int i = 0;
                while (i < this.myArrowSize) {
                    g.drawLine(x + midpoint - i, y + top, x + midpoint + i, y + top);
                    if (!isWhite && this.myUseGradientColor) {
                        g.setColor(this.incrementColor(g.getColor(), -1));
                    }
                    ++top;
                    ++i;
                }
                break;
            }
            case 5: {
                int top = this.getIconHeight() / 2 + halfArrowHeight;
                int i = 0;
                while (i < this.myArrowSize) {
                    g.drawLine(x + midpoint - i, y + top, x + midpoint + i, y + top);
                    if (!isWhite && this.myUseGradientColor) {
                        g.setColor(this.incrementColor(g.getColor(), -1));
                    }
                    --top;
                    ++i;
                }
                break;
            }
            case 3: {
                int top = this.getIconWidth() / 2 + halfArrowHeight;
                int i = 0;
                while (i < this.myArrowSize) {
                    g.drawLine(x + top, y + midpoint - i, x + top, y + midpoint + i);
                    if (!isWhite && this.myUseGradientColor) {
                        g.setColor(this.incrementColor(g.getColor(), -1));
                    }
                    --top;
                    ++i;
                }
                break;
            }
            case 7: {
                int top = this.getIconWidth() / 2 - halfArrowHeight;
                int i = 0;
                while (i < this.myArrowSize) {
                    g.drawLine(x + top, y + midpoint - i, x + top, y + midpoint + i);
                    if (!isWhite && this.myUseGradientColor) {
                        g.setColor(this.incrementColor(g.getColor(), -1));
                    }
                    ++top;
                    ++i;
                }
                break;
            }
            default: {
                g.setColor(origColor);
                throw new IllegalArgumentException("Orientation must be one of SwingConstants definitions NORTH, SOUTH, EAST or WEST.");
            }
        }
        g.setColor(origColor);
    }

    private Color incrementColor(Color color, int direction) {
        return new Color(this.incrementColorValue(color.getRed(), direction), this.incrementColorValue(color.getGreen(), direction), this.incrementColorValue(color.getBlue(), direction), color.getAlpha());
    }

    private int incrementColorValue(int colorValue, int direction) {
        return Math.min(255, Math.max(colorValue + direction * 14, 0));
    }

    public void setArrowColor(Color arrowColor) {
        this.myArrowColor = arrowColor;
    }
}

