/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import com.nokia.widgets.util.SystemUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ReflectionIcon
extends ImageIcon {
    public static final int TRANSPARENCY_TOP = 70;
    public static final int TRANSPARENCY_BOTTOM = 0;

    public static Icon create(URL location) {
        ImageIcon original = new ImageIcon(location);
        return ReflectionIcon.create(original.getImage(), 1.0, 0, 1, null);
    }

    public static Icon create(Image image) {
        return ReflectionIcon.create(image, 1.0, 0, 1, null);
    }

    public static Icon create(URL location, double scale, int shadowOffsetX, int shadowOffsetY, GradientPaint gp) {
        ImageIcon original = new ImageIcon(location);
        return ReflectionIcon.create(original.getImage(), scale, shadowOffsetX, shadowOffsetY, gp);
    }

    public static Icon create(Image image, double scale, int shadowOffsetX, int shadowOffsetY, GradientPaint gp) {
        Image scaledReflection;
        GradientPaint tempGP = gp;
        int orgWidth = image.getWidth(null);
        int orgHeight = image.getHeight(null);
        int scaledHeight = (int)((double)orgHeight * scale);
        if (scale < 1.0 && scale > 0.0) {
            scaledReflection = image.getScaledInstance(orgWidth, scaledHeight, 4);
        } else if (SystemUtils.isEqual(scale, 1.0)) {
            scaledReflection = image;
        } else {
            throw new IllegalArgumentException("Scale out of range. Should be >0 and <= 1");
        }
        ImageIcon scaled = new ImageIcon(scaledReflection);
        BufferedImage reflection = new BufferedImage(orgWidth, scaledHeight, 2);
        Graphics2D reflG2D = reflection.createGraphics();
        int w = reflection.getWidth(null);
        int h = reflection.getHeight(null);
        reflG2D.drawImage(scaled.getImage(), 0, 0, w, h, 0, h, w, 0, null);
        if (tempGP == null) {
            tempGP = ReflectionIcon.getDefaultGradient(h);
        }
        reflG2D.setPaint(tempGP);
        reflG2D.setComposite(AlphaComposite.DstIn);
        reflG2D.fillRect(0, 0, w, h);
        reflG2D.dispose();
        BufferedImage finalImage = new BufferedImage(image.getWidth(null) + shadowOffsetX, image.getHeight(null) + reflection.getHeight() + shadowOffsetY, 2);
        Graphics2D finalImageG2D = finalImage.createGraphics();
        finalImageG2D.drawImage(image, 0, 0, null);
        finalImageG2D.drawImage((Image)reflection, shadowOffsetX, orgHeight + shadowOffsetY, null);
        finalImageG2D.dispose();
        return new ReflectionIcon(finalImage);
    }

    private ReflectionIcon(Image image) {
        super(image);
    }

    private static GradientPaint getDefaultGradient(int height) {
        return new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0, 70), 0.0f, height, new Color(0, 0, 0, 0));
    }
}

