/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScaledIcon
extends ImageIcon {
    public static final int DEFAULT_SIZE = 16;

    public static Icon create(Icon icon) {
        return ScaledIcon.create(icon, 16, true);
    }

    public static Icon create(Icon icon, int width) {
        return ScaledIcon.create(icon, width, true);
    }

    public static Icon create(Icon icon, int size, boolean keepWidth) {
        Icon scaled = icon;
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            int height = -1;
            int width = -1;
            if (keepWidth) {
                width = size;
                if (icon.getIconHeight() > icon.getIconWidth()) {
                    height = width;
                }
            } else {
                height = size;
                if (icon.getIconWidth() > icon.getIconHeight()) {
                    width = height;
                }
            }
            image = image.getScaledInstance(width, height, 4);
            scaled = new ScaledIcon(image);
        }
        return scaled;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Image image = super.getImage();
        MediaTracker mediaTracker = new MediaTracker(c);
        mediaTracker.addImage(image, 0);
        boolean ready = mediaTracker.checkID(0);
        mediaTracker.removeImage(image, 0);
        if (ready) {
            super.paintIcon(c, g, x, y);
        }
    }

    private ScaledIcon(Image image) {
        super(image);
    }
}

