/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class VTextIcon
implements Icon,
PropertyChangeListener {
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int myKeyBufferSpace = 5;
    private String myLabel;
    private String[] myCharStrings;
    private int[] myCharWidths;
    private int[] myPosition;
    private int myWidth;
    private int myHeight;
    private int myCharHeight;
    private int myDescent;
    private int myRotation;
    private Component myComponent;

    public VTextIcon(Component component, String label) {
        this(component, label, 0);
    }

    public VTextIcon(Component component, String label, int rotateHint) {
        this.myComponent = component;
        this.myLabel = label;
        this.myRotation = VTextIcon.verifyRotation(label, rotateHint);
        this.calcDimensions();
        this.myComponent.addPropertyChangeListener(this);
    }

    public void setLabel(String label) {
        this.myLabel = label;
        this.myRotation = VTextIcon.verifyRotation(label, this.myRotation);
        this.recalcDimensions();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    private void recalcDimensions() {
        int wOld = this.getIconWidth();
        int hOld = this.getIconHeight();
        this.calcDimensions();
        if (wOld != this.getIconWidth() || hOld != this.getIconHeight()) {
            this.myComponent.invalidate();
        }
    }

    private void calcDimensions() {
        FontMetrics fm = this.myComponent.getFontMetrics(this.myComponent.getFont());
        this.myCharHeight = fm.getAscent() + fm.getDescent();
        this.myDescent = fm.getDescent();
        if (this.myRotation == 1) {
            int len = this.myLabel.length();
            char[] data = new char[len];
            this.myLabel.getChars(0, len, data, 0);
            this.myWidth = 0;
            this.myCharStrings = new String[len];
            this.myCharWidths = new int[len];
            this.myPosition = new int[len];
            int i = 0;
            while (i < len) {
                char ch = data[i];
                this.myCharWidths[i] = fm.charWidth(ch);
                if (this.myCharWidths[i] > this.myWidth) {
                    this.myWidth = this.myCharWidths[i];
                }
                this.myCharStrings[i] = new String(data, i, 1);
                this.myPosition[i] = 0;
                ++i;
            }
            this.myHeight = this.myCharHeight * len + this.myDescent;
        } else {
            this.myWidth = this.myCharHeight;
            this.myHeight = fm.stringWidth(this.myLabel) + 10;
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(c.getForeground());
        g.setFont(c.getFont());
        if (this.myRotation == 1) {
            int yPos = y + this.myCharHeight;
            int i = 0;
            while (i < this.myCharStrings.length) {
                switch (this.myPosition[i]) {
                    case 0: {
                        g.drawString(this.myCharStrings[i], x + (this.myWidth - this.myCharWidths[i]) / 2, yPos);
                        break;
                    }
                    case 1: {
                        int tweak = this.myCharHeight / 3;
                        g.drawString(this.myCharStrings[i], x + tweak / 2, yPos - tweak);
                        break;
                    }
                    case 2: {
                        int tweak = this.myCharHeight - this.myCharHeight / 3;
                        g.drawString(this.myCharStrings[i], x + tweak / 2, yPos - tweak);
                        break;
                    }
                }
                yPos += this.myCharHeight;
                ++i;
            }
        } else if (this.myRotation == 2) {
            g.translate(x + this.myWidth, y + this.myHeight);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.drawString(this.myLabel, 5, -this.myDescent);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.translate(-(x + this.myWidth), -(y + this.myHeight));
        } else if (this.myRotation == 4) {
            g.translate(x, y);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.drawString(this.myLabel, 5, -this.myDescent);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }

    public static int verifyRotation(String label, int rotateHint) {
        int legal;
        boolean hasCJK = false;
        boolean hasMustRotate = false;
        int len = label.length();
        char[] data = new char[len];
        label.getChars(0, len, data, 0);
        int i = 0;
        while (i < len) {
            char ch = data[i];
            if (ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\u3400' && ch <= '\u4dff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff') {
                hasCJK = true;
            }
            if (ch >= '\u0590' && ch <= '\u05ff' || ch >= '\u0600' && ch <= '\u06ff' || ch >= '\u0700' && ch <= '\u074f') {
                hasMustRotate = true;
            }
            ++i;
        }
        if (hasCJK) {
            return 1;
        }
        int n = legal = hasMustRotate ? 6 : 7;
        if ((rotateHint & legal) > 0) {
            return rotateHint;
        }
        return hasMustRotate ? 2 : 4;
    }
}

