/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.infotip;

import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.infotip.InfoTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class InfoButton
extends PToolButton {
    private InfoTip myInfoTip = null;
    private JScrollPane myScrollP = null;

    public InfoButton(JComponent tipContent) {
        this.initInfoButton(tipContent);
    }

    public InfoButton(String tipText) {
        JComponent label = this.createInfoTipComponent(tipText);
        this.initInfoButton(label);
    }

    public InfoButton() {
        this("");
    }

    private JComponent createInfoTipComponent(String tipText) {
        JLabel label = new JLabel(tipText);
        label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        return label;
    }

    public InfoTip getInfoTip() {
        return this.myInfoTip;
    }

    public void setTipLocation(Point point) {
        this.myInfoTip.setPreferredLocation(point);
    }

    public void setDismissDelay(int delay) {
        this.myInfoTip.setDismissDelay(delay);
    }

    public int getDismissDelay() {
        return this.myInfoTip.getDismissDelay();
    }

    protected void initInfoButton(JComponent tipContent) {
        if (tipContent instanceof JScrollPane) {
            this.myScrollP = (JScrollPane)tipContent;
            this.myScrollP.setViewportBorder(BorderFactory.createEmptyBorder());
        }
        this.setIcon(CommonIcons.getInfoIcon());
        this.setMargin(new Insets(2, 2, 2, 2));
        JComboBox comboBox = new JComboBox();
        this.putClientProperty("doNotCancelPopup", comboBox.getClientProperty("doNotCancelPopup"));
        InfoTip tip = new InfoTip((Component)this, tipContent);
        tip.setDisplayStrategy(3);
        this.myInfoTip = tip;
        this.myInfoTip.setFocusable(false);
        this.setFocusable(true);
        this.initListener();
    }

    private void initListener() {
        this.addActionListener(new ToggleTipAction());
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && keyEvent.getID() == 401 && InfoButton.this.myInfoTip.isVisible()) {
                    InfoButton.this.myInfoTip.setVisible(false);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (InfoButton.this.myInfoTip.isVisible()) {
                    Component newFocusOwner = e.getOppositeComponent();
                    if (newFocusOwner != null && SwingUtilities.getAncestorOfClass(InfoTip.class, newFocusOwner) != null) {
                        return;
                    }
                    InfoButton.this.myInfoTip.setVisible(false);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setTipText(String text) {
        this.myInfoTip.setTipContent(this.createInfoTipComponent(text));
    }

    protected class ToggleTipAction
    extends AbstractAction {
        protected ToggleTipAction() {
        }

        private Rectangle getBoundsForPoint(Point point) {
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = graphicsDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice device = graphicsDeviceArray[n2];
                GraphicsConfiguration[] graphicsConfigurationArray = device.getConfigurations();
                int n3 = graphicsConfigurationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    GraphicsConfiguration config = graphicsConfigurationArray[n4];
                    Rectangle gcBounds = config.getBounds();
                    if (gcBounds.contains(point)) {
                        return gcBounds;
                    }
                    ++n4;
                }
                ++n2;
            }
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InfoButton.this.myInfoTip.isVisible()) {
                InfoButton.this.myInfoTip.setVisible(false);
            } else if (InfoButton.this.myInfoTip.getTipContent() != null) {
                if (InfoButton.this.myInfoTip.getPreferredLocation() == null) {
                    Point p = new Point(-14, InfoButton.this.getPreferredSize().height + 3);
                    InfoButton.this.setTipLocation(p);
                }
                if (InfoButton.this.myScrollP != null) {
                    Dimension di = InfoButton.this.myScrollP.getPreferredSize();
                    Point p1 = InfoButton.this.getLocationOnScreen();
                    SwingUtilities.convertPointToScreen(p1, InfoButton.this.myInfoTip);
                    Rectangle bounds = this.getBoundsForPoint(p1);
                    double screenHeight = bounds.getHeight();
                    if (screenHeight * 43.0 / 59.0 < di.getHeight()) {
                        InfoButton.this.myInfoTip.setPreferredSize(new Dimension((int)di.getWidth() + 12, (int)screenHeight * 43 / 59));
                    } else {
                        InfoButton.this.myInfoTip.setPreferredSize(new Dimension((int)di.getWidth() + 12, (int)di.getHeight() + 5));
                    }
                }
                InfoButton.this.myInfoTip.show();
            }
        }
    }
}

