/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.infotip;

import com.nokia.laf.borders.NetTooltipBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.infotip.InfoTipEvent;
import com.nokia.widgets.infotip.TipShadowBorder;
import com.nokia.widgets.infotip.VetoableInfoTipListener;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.UIResource;

public class InfoTip
extends JPopupMenu
implements ActionListener {
    public static final int DISPLAY_ON_MOUSE_ENTER = 0;
    public static final int DISPLAY_ON_MOUSE_ENTER_FOLLOW_MOUSE = 2;
    public static final int DISPLAY_ON_NONE = 3;
    private Timer myAutoShowTimer;
    private Timer myDismissTimer;
    private int myDisplayStrategy = 0;
    private MouseEvent myLastMouseEvent;
    private boolean isMouseMovingTowardsTip;
    private Point myLastTipPosition = new Point(-1, -1);
    private Point myPreferredLocation = null;
    private boolean myTipContentActive = false;
    protected MouseHandler myHandler;
    private boolean myDismissOnTooltipPress;
    private boolean myTooltipStyle = false;
    private Integer myArrowXLocation = null;

    public InfoTip(Component invoker, JComponent tipContent) {
        this.initInfoTip(invoker, tipContent);
    }

    public InfoTip(Component invoker, String tipText) {
        this.initInfoTip(invoker, this.createTipLabel(tipText));
    }

    public InfoTip(Component invoker) {
        this(invoker, "");
    }

    public InfoTip(Component invoker, boolean tooltipStyle) {
        this.myTooltipStyle = tooltipStyle;
        this.initInfoTip(invoker, this.createTipLabel(""));
    }

    public void addInfoTipListener(VetoableInfoTipListener listener) {
        this.listenerList.add(VetoableInfoTipListener.class, listener);
    }

    public void removeInfoTipListener(VetoableInfoTipListener listener) {
        this.listenerList.remove(VetoableInfoTipListener.class, listener);
    }

    public VetoableInfoTipListener[] getInfoTipListeners() {
        return (VetoableInfoTipListener[])this.listenerList.getListeners(VetoableInfoTipListener.class);
    }

    public void setPreferredLocation(Point preferredLocation) {
        Point oldValue = this.myPreferredLocation;
        this.myPreferredLocation = preferredLocation != null ? new Point(preferredLocation) : null;
        this.firePropertyChange("preferredLocation", oldValue, this.myPreferredLocation);
    }

    public Point getPreferredLocation() {
        return this.myPreferredLocation;
    }

    public JComponent getTipContent() {
        return (JComponent)(this.getComponentCount() > 0 ? this.getComponent(0) : null);
    }

    public void setTipContent(String tipText) {
        this.setTipContent(this.createTipLabel(tipText));
    }

    public void setTipContent(JComponent component) {
        if (component == null) {
            this.removeAll();
        } else if (this.getComponentCount() > 0 && this.getComponent(0) != component) {
            this.removeAll();
            this.add(component);
            this.configureTipContent(component);
        }
        this.pack();
        this.revalidate();
        this.repaint();
    }

    public void setTipContentActive(boolean active) {
        this.myTipContentActive = active;
    }

    public void setDisplayStrategy(int strategy) {
        int oldValue = this.myDisplayStrategy;
        if (strategy != 2 && strategy != 0 && strategy != 3) {
            throw new IllegalArgumentException("Invalid info tip display strategy: " + strategy);
        }
        this.myDisplayStrategy = strategy;
        this.firePropertyChange("displayStrategy", oldValue, this.myDisplayStrategy);
    }

    @Override
    public void show() {
        this.myAutoShowTimer.start();
    }

    public void setShowDelay(int showDelay) {
        int oldValue = this.myAutoShowTimer.getInitialDelay();
        this.myAutoShowTimer.setInitialDelay(showDelay);
        this.firePropertyChange("showDelay", oldValue, showDelay);
    }

    public int getShowDelay() {
        return this.myAutoShowTimer.getInitialDelay();
    }

    public void setDismissDelay(int dismissDelay) {
        int oldValue = -1;
        if (this.myDismissTimer == null) {
            this.myDismissTimer = new Timer(dismissDelay, this);
            this.myDismissTimer.setRepeats(false);
        } else {
            oldValue = this.myDismissTimer.getInitialDelay();
            this.myDismissTimer.setInitialDelay(dismissDelay);
        }
        this.firePropertyChange("dismissDelay", oldValue, dismissDelay);
    }

    public void disposeTip() {
        Component invoker = this.getInvoker();
        invoker.removeMouseListener(this.myHandler);
        invoker.removeMouseMotionListener(this.myHandler);
        this.setInvoker(null);
    }

    public int getDismissDelay() {
        return this.myDismissTimer != null ? this.myDismissTimer.getInitialDelay() : -1;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.fireInfoTipWillBecomeInvisible();
            this.myAutoShowTimer.stop();
            if (this.myDismissTimer != null) {
                this.myDismissTimer.stop();
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myAutoShowTimer) {
            if (!this.getInvoker().isShowing() || !this.fireInfoTipWillBecomeVisible()) {
                return;
            }
            this.replaceTipContent();
            Component invoker = this.getInvoker();
            Point point = this.getTipLocation(this.myLastMouseEvent);
            this.myLastTipPosition.setLocation(point);
            this.show(invoker, point.x, point.y);
            this.setOpaque(false);
            if (this.myDismissTimer != null) {
                this.myDismissTimer.start();
            }
        } else if (e.getSource() == this.myDismissTimer) {
            this.setVisible(false);
        }
    }

    protected void replaceTipContent() {
    }

    public Point getLastTipLocation() {
        return this.myLastTipPosition;
    }

    public Point getTipLocation(MouseEvent event) {
        Point location = this.getPreferredLocation();
        if (location == null) {
            if (event != null && this.myDisplayStrategy == 2) {
                Point point = event.getPoint();
                location = new Point(point.x - 28 - this.getInvoker().getPreferredSize().width / 2, point.y + 20);
            } else {
                location = new Point(-18, this.getInvoker().getPreferredSize().height + 5);
            }
        }
        this.adjustTipLocation(location);
        return location;
    }

    protected boolean fireInfoTipWillBecomeVisible() {
        InfoTipEvent event = this.myLastMouseEvent != null ? new InfoTipEvent(this, this.myLastMouseEvent.getPoint()) : new InfoTipEvent(this, null);
        boolean showingVetoed = false;
        VetoableInfoTipListener[] listeners = this.getInfoTipListeners();
        int idx = listeners.length - 1;
        while (idx >= 0) {
            boolean shouldBeShown = listeners[idx].infoTipWillBecomeVisible(event);
            if (!shouldBeShown) {
                showingVetoed = true;
            }
            --idx;
        }
        return !showingVetoed;
    }

    protected void fireInfoTipWillBecomeInvisible() {
        InfoTipEvent event = null;
        event = this.myLastMouseEvent != null ? new InfoTipEvent(this, this.myLastMouseEvent.getPoint()) : new InfoTipEvent(this, null);
        VetoableInfoTipListener[] listeners = this.getInfoTipListeners();
        int idx = listeners.length - 1;
        while (idx >= 0) {
            listeners[idx].infoTipWillBecomeInvisible(event);
            --idx;
        }
    }

    protected void initInfoTip(Component invoker, JComponent tipContent) {
        this.setLayout(new BorderLayout());
        this.setBorder(new TipShadowBorder());
        this.add(tipContent);
        this.setOpaque(false);
        this.setFocusable(false);
        this.myAutoShowTimer = new Timer(0, this);
        this.myAutoShowTimer.setRepeats(false);
        this.configureTipContent(tipContent);
        this.myHandler = new MouseHandler();
        invoker.addMouseListener(this.myHandler);
        invoker.addMouseMotionListener(this.myHandler);
        tipContent.addMouseListener(this.myHandler);
        this.setInvoker(invoker);
        if (this.myTooltipStyle) {
            this.setBorder(new NetTooltipBorder());
            this.setBackground(new Color(UIManager.getColor("ToolTip.background").getRGB()));
        }
    }

    public Point getLasMouseLocation() {
        return this.myLastMouseEvent == null ? new Point(0, 0) : this.myLastMouseEvent.getPoint();
    }

    private void configureTipContent(JComponent tipContent) {
        tipContent.setOpaque(false);
        if (!this.myTooltipStyle) {
            tipContent.setForeground(UIManager.getColor("Label.tipLabelForeground"));
            if (NetUtils.lookAndFeelCanReplace(tipContent.getFont())) {
                tipContent.setFont(UIManager.getFont("BalloonInternalFrame.font"));
            }
        }
    }

    protected JComponent createTipLabel(String tipText) {
        PLabel label = this.myTooltipStyle ? PLabel.createValueText(tipText) : PLabel.createTipLabel(tipText);
        label.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        return label;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (ClientPropertyUtil.booleanValue(this, "OrangeTouch.isHeavyweight")) {
            NetUtils.paintScreenCapture(g, SwingUtilities.getWindowAncestor(this).getBounds());
        }
        Insets insets = this.getInsets();
        RectangularShape internals = null;
        if (this.myTooltipStyle) {
            internals = new RoundRectangle2D.Double(insets.left, insets.top, this.getWidth() - (insets.left + insets.right) + 1, this.getHeight() - (insets.top + insets.bottom) + 1, 5.0, 5.0);
        } else {
            internals = NetUtils.getOutline(this);
            internals.setFrame(insets.left, insets.top, internals.getWidth() - (double)(insets.left + insets.right) + 1.0, internals.getHeight() - (double)(insets.top + insets.bottom) + 1.0);
        }
        if (this.getBackground() instanceof UIResource) {
            GradientUtils.drawVerticalGradient((JComponent)this, g, "Balloon.backgroundGradient", (Shape)internals);
        } else {
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            g.setColor(this.getBackground());
            ((Graphics2D)g).fill(internals);
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        }
    }

    private boolean isMouseApproachingTip(MouseEvent oldEvent, MouseEvent newEvent) {
        Rectangle tipRect;
        if (!this.myTipContentActive) {
            return false;
        }
        Point oldPoint = oldEvent.getPoint();
        Point newPoint = newEvent.getPoint();
        return InfoTip.getDistance(newPoint, tipRect = new Rectangle((int)this.myLastTipPosition.getX(), (int)this.myLastTipPosition.getY(), this.getWidth(), this.getHeight())) <= InfoTip.getDistance(oldPoint, tipRect);
    }

    private static double getDistance(Point2D point, Rectangle2D rect) {
        Line2D.Double rectSegment = new Line2D.Double(rect.getMinX(), rect.getMinY(), rect.getMinX(), rect.getMaxY());
        double d1 = rectSegment.ptSegDist(point);
        ((Line2D)rectSegment).setLine(rect.getMaxX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
        double d2 = rectSegment.ptSegDist(point);
        ((Line2D)rectSegment).setLine(rect.getMinX(), rect.getMaxY(), rect.getMaxX(), rect.getMaxY());
        double d3 = rectSegment.ptSegDist(point);
        ((Line2D)rectSegment).setLine(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMinY());
        double d4 = rectSegment.ptSegDist(point);
        double result = Math.min(d1, d2);
        result = Math.min(result, d3);
        return Math.min(result, d4);
    }

    protected void adjustTipLocation(Point locationToAdjust) {
        if (!this.getInvoker().isShowing()) {
            return;
        }
        Point invokerScreenLocation = this.getInvoker().getLocationOnScreen();
        Point tipScreenLocation = new Point(invokerScreenLocation.x + locationToAdjust.x, invokerScreenLocation.y + locationToAdjust.y);
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        GraphicsConfiguration graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        if (tipScreenLocation.x < screenBounds.x) {
            tipScreenLocation.x = screenBounds.x;
        } else if (tipScreenLocation.x - screenBounds.x + width > screenBounds.width) {
            tipScreenLocation.x = screenBounds.x + Math.max(0, screenBounds.width - width);
        }
        if (tipScreenLocation.y < screenBounds.y) {
            tipScreenLocation.y = screenBounds.y;
        } else if (tipScreenLocation.y + height > screenBounds.y + screenBounds.height) {
            tipScreenLocation.y = screenBounds.y + Math.max(0, screenBounds.height - height);
        }
        if (this.myDisplayStrategy != 2) {
            if (tipScreenLocation.y == screenBounds.y) {
                tipScreenLocation.y = invokerScreenLocation.y + this.getInvoker().getHeight() + 6;
            } else if (tipScreenLocation.y < invokerScreenLocation.y + this.getInvoker().getHeight()) {
                tipScreenLocation.y = screenBounds.y + Math.max(0, invokerScreenLocation.y - height - 6);
            }
        }
        Rectangle tipBounds = new Rectangle(tipScreenLocation.x, tipScreenLocation.y, width, height);
        Rectangle invokerBounds = new Rectangle(invokerScreenLocation.x, invokerScreenLocation.y, this.getInvoker().getWidth(), this.getInvoker().getHeight());
        if (this.myDisplayStrategy == 0 && tipBounds.intersects(invokerBounds)) {
            if (invokerBounds.y - tipBounds.height > screenBounds.y) {
                tipScreenLocation.y = invokerBounds.y - tipBounds.height;
            } else if (invokerBounds.y + invokerBounds.height + tipBounds.y < screenBounds.y + screenBounds.height) {
                tipScreenLocation.y = invokerBounds.y + invokerBounds.height;
            }
        }
        locationToAdjust.x = tipScreenLocation.x - invokerScreenLocation.x;
        locationToAdjust.y = tipScreenLocation.y - invokerScreenLocation.y;
        if (height > screenBounds.height && this.myDisplayStrategy == 2) {
            locationToAdjust.y = 0;
            locationToAdjust.x = this.getLasMouseLocation().x;
        }
    }

    public void setDismissOnTooltipPress(boolean b) {
        this.myDismissOnTooltipPress = b;
    }

    public Integer getArrowXLocation() {
        return this.myArrowXLocation;
    }

    public void setArrowXLocation(Integer location) {
        this.myArrowXLocation = location;
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!InfoTip.this.getInvoker().isEnabled()) {
                return;
            }
            InfoTip.this.myLastMouseEvent = e;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            InfoTip.this.myLastMouseEvent = e;
            InfoTip.this.isMouseMovingTowardsTip = false;
            if (InfoTip.this.myTipContentActive && !e.getSource().equals(InfoTip.this.getInvoker())) {
                InfoTip.this.isMouseMovingTowardsTip = true;
                if (InfoTip.this.myDismissTimer != null) {
                    InfoTip.this.myDismissTimer.stop();
                }
            }
            if (InfoTip.this.myDisplayStrategy == 2) {
                InfoTip.this.setVisible(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (InfoTip.this.getInvoker().contains(e.getX(), e.getY())) {
                return;
            }
            InfoTip.this.myLastMouseEvent = e;
            if (InfoTip.this.myTipContentActive && e.getSource().equals(InfoTip.this.getInvoker()) && InfoTip.this.isMouseMovingTowardsTip) {
                return;
            }
            if (InfoTip.this.myDisplayStrategy == 2 || InfoTip.this.myDisplayStrategy == 0) {
                if (InfoTip.this.myDisplayStrategy == 0 || !InfoTip.this.isMouseMovingTowardsTip) {
                    InfoTip.this.setVisible(false);
                }
                InfoTip.this.isMouseMovingTowardsTip = false;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (InfoTip.this.isVisible() && InfoTip.this.myDisplayStrategy != 3 && InfoTip.this.isMouseApproachingTip(InfoTip.this.myLastMouseEvent, e)) {
                InfoTip.this.myLastMouseEvent = e;
                InfoTip.this.isMouseMovingTowardsTip = true;
                return;
            }
            InfoTip.this.isMouseMovingTowardsTip = false;
            if (InfoTip.this.myDisplayStrategy == 2 || InfoTip.this.myDisplayStrategy == 0) {
                InfoTip.this.myLastMouseEvent = e;
                if (!InfoTip.this.myAutoShowTimer.isRunning() && InfoTip.this.myDisplayStrategy == 2) {
                    InfoTip.this.setVisible(false);
                    InfoTip.this.show();
                } else {
                    InfoTip.this.myAutoShowTimer.restart();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (InfoTip.this.myDismissOnTooltipPress && e.getSource().equals(InfoTip.this.getInvoker())) {
                InfoTip.this.setVisible(false);
            }
        }
    }
}

