/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.infotip;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.infotip.InfoTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class TipShadowBorder
extends AbstractBorder {
    public static final int DEFAULT_ARROW = 0;
    public static final int LEFT_DOWN_ARROW = 1;
    private Insets myShadowSize = new Insets(4, 7, 7, 7);

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 4;
        insets.left = 7;
        insets.bottom = 7;
        insets.right = 7;
        if (c instanceof InfoTip) {
            insets.top = this.isInvokerAboveTip((InfoTip)c) ? 8 : 4;
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int tempY = y;
        int tempHeight = height;
        Graphics2D g2d = (Graphics2D)g;
        if (!(c instanceof InfoTip)) {
            NetUtils.drawDropShadow(g2d, "Balloon.dropShadow", this.myShadowSize, x, tempY, width, tempHeight, 14);
            return;
        }
        InfoTip tip = (InfoTip)c;
        boolean isInvokerAboveTip = this.isInvokerAboveTip(tip);
        boolean isInvokerBelowTip = this.isInvokerBelowTip(tip);
        if (isInvokerBelowTip) {
            tempHeight -= this.myShadowSize.bottom;
        } else if (isInvokerAboveTip) {
            tempY += this.myShadowSize.top;
            tempHeight -= this.myShadowSize.top;
        }
        NetUtils.drawDropShadow(g2d, "Balloon.dropShadow", this.myShadowSize, x, tempY, width, tempHeight, 14);
        this.paintCalloutArrow(g2d, tip, isInvokerAboveTip, isInvokerBelowTip);
    }

    private boolean isInvokerBelowTip(InfoTip tip) {
        Point lastMousePoint = tip.getLasMouseLocation();
        Point tipLocation = tip.getLastTipLocation();
        return lastMousePoint.y > tipLocation.y + tip.getHeight() && lastMousePoint.x > tipLocation.x && lastMousePoint.x < tipLocation.x + tip.getWidth();
    }

    private boolean isInvokerAboveTip(InfoTip tip) {
        Point lastMousePoint = tip.getLasMouseLocation();
        Point tipLocation = tip.getLastTipLocation();
        return lastMousePoint.y < tipLocation.y && lastMousePoint.x > tipLocation.x && lastMousePoint.x < tipLocation.x + tip.getWidth();
    }

    protected void paintCalloutArrow(Graphics2D g2d, InfoTip tip, boolean isInvokerAboveTip, boolean isInvokerBelowTip) {
        int arrowLocation = this.getArrowXLocation(tip);
        if (isInvokerAboveTip) {
            this.paintArrow(g2d, tip, tip.getInsets(), arrowLocation, 0);
        } else if (isInvokerBelowTip && tip.getInvoker().getWidth() < tip.getWidth() && tip.getInvoker().getLocationOnScreen().getY() > tip.getLocationOnScreen().getY() + (double)tip.getHeight()) {
            this.paintArrow(g2d, tip, tip.getInsets(), arrowLocation, 1);
        }
    }

    private int getArrowXLocation(InfoTip tip) {
        Integer customArrowLocation = tip.getArrowXLocation();
        Component invoker = tip.getInvoker();
        if (customArrowLocation != null) {
            return SwingUtilities.convertPoint((Component)invoker, (Point)new Point((int)customArrowLocation.intValue(), (int)0), (Component)tip).x;
        }
        if (invoker.getWidth() > tip.getWidth()) {
            int mouseXLocation = (int)tip.getLasMouseLocation().getX();
            return SwingUtilities.convertPoint((Component)invoker, (Point)new Point((int)mouseXLocation, (int)0), (Component)tip).x;
        }
        return -tip.getLastTipLocation().x + invoker.getWidth() / 2;
    }

    private void paintArrow(Graphics2D g2d, InfoTip infoTip, Insets insets, int xLocation, int arrowDirection) {
        Object oldAa = NetUtils.antiAliasingOn(g2d);
        GeneralPath path = new GeneralPath();
        int arrowWidth = 18;
        if (arrowDirection == 0) {
            path.moveTo(xLocation, -1.0f);
            path.lineTo(xLocation - 9, insets.top + 1);
            path.lineTo(xLocation + 9, insets.top + 1);
        } else {
            int tipHeight = infoTip.getHeight();
            path.moveTo(xLocation, tipHeight - insets.bottom + 7);
            path.lineTo(xLocation - 9, tipHeight - insets.bottom);
            path.lineTo(xLocation + 9, tipHeight - insets.bottom);
        }
        Color oldColor = g2d.getColor();
        if (NetUtils.lookAndFeelCanReplace(infoTip.getBackground())) {
            Color[] color = (Color[])UIManager.get("Balloon.backgroundGradient");
            g2d.setColor(color[arrowDirection == 0 ? 0 : 1]);
        } else {
            g2d.setColor(infoTip.getBackground());
        }
        g2d.fill(path);
        g2d.setColor(oldColor);
        NetUtils.setAntialiasing(g2d, oldAa);
    }
}

