/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.ipfield.PIpAddressDocumentFilter;
import com.nokia.widgets.text.PTextComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class Ipv4AddressDocumentFilter
extends PIpAddressDocumentFilter {
    private static final int IPV4_MAX_SEGMENT_LENGTH = 3;
    private int[] mySegmentMaxValues = new int[]{255, 255, 255, 255};
    private int[] mySegmentMinValues = new int[4];

    public Ipv4AddressDocumentFilter(PTextComponent textComponent) {
        super(textComponent);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet attrs) throws BadLocationException {
        if (str == null) {
            this.flashIfRequired();
            return;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i)) && str.charAt(i) != '.') {
                this.flashIfRequired();
                return;
            }
            ++i;
        }
        String currentText = fb.getDocument().getText(0, fb.getDocument().getLength());
        StringBuffer builder = new StringBuffer(currentText);
        builder.replace(offset, offset + length, str);
        String newText = builder.toString();
        String[] segments = newText.split("\\.", 4);
        if (segments[segments.length - 1].indexOf(46) > 0) {
            this.flashIfRequired();
            return;
        }
        int segmentIdx = 0;
        while (segmentIdx < segments.length) {
            if (segments[segmentIdx].length() != 0) {
                if (segments[segmentIdx].length() > 3) {
                    this.flashIfRequired();
                    return;
                }
                int intValue = -1;
                try {
                    intValue = Integer.parseInt(segments[segmentIdx]);
                }
                catch (NumberFormatException e) {
                    this.flashIfRequired();
                    return;
                }
                if (intValue > this.mySegmentMaxValues[segmentIdx] || intValue < this.mySegmentMinValues[segmentIdx]) {
                    this.flashIfRequired();
                    return;
                }
            }
            ++segmentIdx;
        }
        super.replace(fb, offset, length, str, attrs);
    }
}

