/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.ipfield.PIpAddressDocumentFilter;
import com.nokia.widgets.text.PTextComponent;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class Ipv6AddressDocumentFilter
extends PIpAddressDocumentFilter {
    private static final int IPV6_MAX_SEGMENT_LENGTH = 4;
    private static final int MAX_COLONS = 7;
    private static final int MAX_COLONS_HYBRID = 6;
    private static final int MAX_LEGTH = 45;
    private static final int IPV4_MAX_SEGMENT_VALUE = 255;
    private static final int MAX_DOTS = 3;
    private static final int IPV4_MAX_SEGMENT_LENGTH = 3;
    private int mySupportedVersions = 2;

    public Ipv6AddressDocumentFilter(PTextComponent textComponent) {
        super(textComponent);
    }

    public Ipv6AddressDocumentFilter(PTextComponent textComponent, int supportedVersion) {
        super(textComponent);
        this.mySupportedVersions = supportedVersion;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
        int maxColons;
        if (text == null) {
            this.flashIfRequired();
            return;
        }
        String currentText = fb.getDocument().getText(0, fb.getDocument().getLength());
        StringBuffer b = new StringBuffer(currentText);
        b.replace(offset, offset + length, text);
        if (b.length() > 45) {
            this.flashIfRequired();
            return;
        }
        int dots = 0;
        int colons = 0;
        char prev = '\u0000';
        boolean wildcardStart = false;
        boolean wildcardEnd = false;
        boolean wildcard = false;
        int i = 0;
        while (i < b.length()) {
            char c = b.charAt(i);
            if (c == ':') {
                if (dots != 0) {
                    this.flashIfRequired();
                    return;
                }
                ++colons;
                if (wildcard) {
                    wildcardEnd = false;
                }
                if (prev == c) {
                    if (wildcard) {
                        this.flashIfRequired();
                        return;
                    }
                    wildcard = true;
                    wildcardStart = i == 1;
                    wildcardEnd = !wildcardStart;
                }
            } else if (c == '.') {
                if (colons != 0 && this.mySupportedVersions == 3) {
                    this.flashIfRequired();
                    return;
                }
                if (i == 0 || prev == '.' || prev == ':' || ++dots > 3 || this.mySupportedVersions == 1) {
                    this.flashIfRequired();
                    return;
                }
            } else if (this.isHex(c)) {
                if (dots != 0) {
                    this.flashIfRequired();
                    return;
                }
            } else if (!this.isDigit(c)) {
                this.flashIfRequired();
                return;
            }
            prev = c;
            ++i;
        }
        if (dots == 0) {
            maxColons = 7;
            if (wildcardStart || wildcardEnd) {
                ++maxColons;
            }
        } else {
            maxColons = 6;
            if (wildcardStart) {
                ++maxColons;
            }
        }
        if (colons > maxColons) {
            this.flashIfRequired();
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(b.toString(), ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (dots != 0 && !tokenizer.hasMoreTokens()) {
                tokenizer = new StringTokenizer(token, ".");
                while (tokenizer.hasMoreTokens()) {
                    int segmentValue;
                    token = tokenizer.nextToken();
                    if (token.length() > 3) {
                        this.flashIfRequired();
                        return;
                    }
                    try {
                        segmentValue = Integer.parseInt(token, 10);
                    }
                    catch (NumberFormatException ex) {
                        this.flashIfRequired();
                        return;
                    }
                    if (segmentValue <= 255) continue;
                    this.flashIfRequired();
                    return;
                }
                break;
            }
            if (token.length() <= 4) continue;
            this.flashIfRequired();
            return;
        }
        super.replace(fb, offset, length, text, attributes);
    }
}

