/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.ipfield.rules.IpRule;
import com.nokia.widgets.ipfield.rules.IpRuleFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class PIpAddressComparator
implements Comparator<Object> {
    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        String trimmedAddress1 = PIpAddressComparator.trimAddress(o1.toString());
        String trimmedAddress2 = PIpAddressComparator.trimAddress(o2.toString());
        return trimmedAddress1.compareTo(trimmedAddress2);
    }

    public static String trimAddress(String address) {
        if (address == null || address.isEmpty()) {
            return "";
        }
        if (PIpAddressComparator.isIpv6Address(address)) {
            return PIpAddressComparator.trimAndExpandIpv6Address(address);
        }
        StringBuilder b = new StringBuilder(15);
        StringTokenizer tokenizer = new StringTokenizer(address, ".", true);
        while (tokenizer.hasMoreTokens()) {
            boolean added = false;
            String token = tokenizer.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (token.charAt(i) != '0') {
                    added = true;
                    b.append(token.substring(i));
                    break;
                }
                ++i;
            }
            if (added) continue;
            b.append(token.length() > 0 ? token.charAt(0) : (char)'0');
        }
        return b.toString();
    }

    private static String trimAndExpandIpv6Address(String address) {
        StringBuilder b = new StringBuilder(address);
        while (b.length() > 2 && b.charAt(0) == '0' && b.charAt(1) != ':') {
            b.deleteCharAt(0);
        }
        int index = b.indexOf(":0");
        while (index != -1) {
            if (b.length() > index + 2 && b.charAt(index + 2) != ':') {
                b = b.deleteCharAt(index + 1);
                index = b.indexOf(":0", index);
                continue;
            }
            index = b.indexOf(":0", index + 1);
        }
        index = b.indexOf("::");
        if (index != -1) {
            b.insert(index + 1, '-');
        }
        boolean hybrid = b.indexOf(".") != -1;
        StringTokenizer tokenizer = new StringTokenizer(b.toString(), ":");
        int tokens = tokenizer.countTokens();
        if (hybrid) {
            ++tokens;
        }
        b.setLength(0);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("-".equals(token)) {
                int i = tokens - 1;
                while (i < 8) {
                    b.append("0:");
                    ++i;
                }
                continue;
            }
            if (token.indexOf(46) == -1) {
                b.append(token).append(':');
                continue;
            }
            byte[] bytes = PIpAddressComparator.getBytesOfToken(token);
            int i = 0;
            while (i < 4) {
                b.append(Integer.toString((0xFF & bytes[i]) << 8 | 0xFF & bytes[i + 1], 16));
                b.append(':');
                i += 2;
            }
        }
        return b.substring(0, b.length() - 1).toLowerCase();
    }

    private static byte[] getBytesOfToken(String token) {
        String myAddress = PIpAddressComparator.isValidIpAddress(token) ? PIpAddressComparator.trimAddress(token) : null;
        byte[] result = PIpAddressComparator.getBytes(myAddress);
        return Arrays.copyOf(result, result.length);
    }

    public static boolean isValidIpAddress(String address) {
        return PIpAddressComparator.isIpv4Address(address) || PIpAddressComparator.isIpv6Address(address);
    }

    public static boolean isIpv6Address(String address) {
        return PIpAddressComparator.testAgainstIpRules(address, IpRuleFactory.getIpv6Rules());
    }

    private static boolean isIpv4Address(String address) {
        return PIpAddressComparator.testAgainstIpRules(address, IpRuleFactory.getIpv4Rules());
    }

    private static boolean testAgainstIpRules(String address, List<? extends IpRule> rules) {
        if (address != null && !address.isEmpty()) {
            for (IpRule ipRule : rules) {
                if (!ipRule.matches(address)) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] getBytes(String address) {
        if (PIpAddressComparator.isIpv6Address(address)) {
            return PIpAddressComparator.getIpV6Bytes(address);
        }
        if (PIpAddressComparator.isIpv4Address(address)) {
            return PIpAddressComparator.getIpV4Bytes(address);
        }
        return new byte[0];
    }

    private static byte[] getIpV6Bytes(String address) {
        StringTokenizer token = new StringTokenizer(address, ":");
        byte[] bytes = new byte[16];
        int i = 0;
        while (token.hasMoreTokens()) {
            int intAdd = Integer.parseInt(token.nextToken(), 16);
            bytes[i++] = (byte)(0xFF & intAdd >> 8);
            bytes[i++] = (byte)(0xFF & intAdd);
        }
        return bytes;
    }

    private static byte[] getIpV4Bytes(String address) {
        StringTokenizer token = new StringTokenizer(address, ".");
        byte[] bytes = new byte[4];
        int i = 0;
        while (token.hasMoreTokens()) {
            bytes[i++] = (byte)Integer.parseInt(token.nextToken());
        }
        return bytes;
    }
}

