/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.text.PTextComponent;
import java.util.regex.Pattern;
import javax.swing.text.DocumentFilter;

public abstract class PIpAddressDocumentFilter
extends DocumentFilter {
    private static final String digitCheckingRegex = "[0-9]";
    private static final String hexCheckingRegex = "[a-fA-F]";
    private Pattern myDigitPattern;
    private Pattern myHexPattern;
    private PTextComponent myTextComponent;
    private boolean myUseRedFlash = true;

    public PIpAddressDocumentFilter(PTextComponent textComponent) {
        this.myTextComponent = textComponent;
        this.myHexPattern = Pattern.compile(hexCheckingRegex);
        this.myDigitPattern = Pattern.compile(digitCheckingRegex);
    }

    public void setUseRedFlash(boolean useRedFlash) {
        this.myUseRedFlash = useRedFlash;
    }

    protected void flashIfRequired() {
        if (this.myUseRedFlash) {
            this.myTextComponent.flashField();
        }
    }

    protected boolean isDigit(char c) {
        return this.myDigitPattern.matcher(new String(new char[]{c})).matches();
    }

    protected boolean isHex(char c) {
        return this.myHexPattern.matcher(new String(new char[]{c})).matches();
    }
}

