/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.ipfield.PIpAddressComparator;
import com.nokia.widgets.ipfield.PIpAddressDocument;
import com.nokia.widgets.ipfield.PIpAddressValidationListener;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.PValidationListener;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.text.Document;

public class PIpAddressField
extends PTextField {
    public static final int SUPPORT_IPV4 = 0;
    public static final int SUPPORT_IPV6 = 1;
    public static final int SUPPORT_HYBRID = 2;
    public static final int SUPPORT_IPV4_AND_IPV6 = 3;
    private static final String PROTOTYPE_V4_VALUE = "255.255.255.255";
    private static final String PROTOTYPE_HYBRID_VALUE = "DDDD:DDDD:DDDD:DDDD:DDDD:DDDD:255.255.255.255";
    private static final String PROTOTYPE_V6_VALUE = "DDDD:DDDD:DDDD:DDDD:DDDD:DDDD:DDDD:DDDD";
    private int mySupportedVersions = 0;
    private PValidationListener myValidationListener;
    private static Comparator<Object> IP_ADDRESS_COMPARATOR = new PIpAddressComparator();

    public PIpAddressField() {
        this(0);
    }

    public PIpAddressField(int supportedIPVersions) {
        this.mySupportedVersions = supportedIPVersions;
        this.setDocument(this.createDefaultModel());
        this.myValidationListener = this.createDefaultValidationListener();
        this.addValidationListener(this.myValidationListener);
    }

    public PIpAddressField(String address, int supportedIPVersions) {
        super(address);
        this.mySupportedVersions = supportedIPVersions;
        this.setDocument(this.createDefaultModel());
        this.setText(address);
        this.myValidationListener = this.createDefaultValidationListener();
        this.addValidationListener(this.myValidationListener);
    }

    public PIpAddressField(String address) {
        this(address, 0);
    }

    public String getAddress() {
        return this.getText();
    }

    public int getSupportedIpVersions() {
        return this.mySupportedVersions;
    }

    public void setAddress(String address) {
        this.setText(address);
    }

    public void setSupportedVersion(int version) {
        this.mySupportedVersions = version;
        this.removeValidationListener(this.myValidationListener);
        this.myValidationListener = this.createDefaultValidationListener();
        this.addValidationListener(this.myValidationListener);
        this.setDocument(this.createDefaultModel());
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        switch (this.mySupportedVersions) {
            case 0: {
                dim.width = this.getFontMetrics(this.getFont()).stringWidth(PROTOTYPE_V4_VALUE);
                break;
            }
            case 1: {
                dim.width = this.getFontMetrics(this.getFont()).stringWidth(PROTOTYPE_V6_VALUE);
                break;
            }
            case 3: {
                dim.width = this.getFontMetrics(this.getFont()).stringWidth(PROTOTYPE_V6_VALUE);
                break;
            }
            case 2: {
                dim.width = this.getFontMetrics(this.getFont()).stringWidth(PROTOTYPE_HYBRID_VALUE);
                break;
            }
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            dim.width += insets.left + insets.right + 5;
        }
        return dim;
    }

    protected PValidationListener createDefaultValidationListener() {
        return new PIpAddressValidationListener(this.mySupportedVersions);
    }

    @Override
    protected Document createDefaultModel() {
        return new PIpAddressDocument(this, this.mySupportedVersions);
    }

    @Override
    protected void init() {
        super.init();
        this.setValidateOnFocusLost(true);
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, IP_ADDRESS_COMPARATOR);
    }
}

