/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield;

import com.nokia.widgets.ipfield.rules.IpRule;
import com.nokia.widgets.ipfield.rules.IpRuleFactory;
import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.util.WidgetResources;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PIpAddressValidationListener
implements PValidationListener {
    private int mySupportedVersions;
    private List theHybridRules;
    private List theIpv4Rules;
    private List theIpv6Rules;
    private List theIpv4v6Rules;

    public PIpAddressValidationListener(int supportedVersion) {
        this.mySupportedVersions = supportedVersion;
        this.theHybridRules = IpRuleFactory.getHybridRules();
        this.theIpv4Rules = IpRuleFactory.getIpv4Rules();
        this.theIpv6Rules = IpRuleFactory.getIpv6Rules();
        this.theIpv4v6Rules = IpRuleFactory.getIpv4Rules();
        this.theIpv4v6Rules.addAll(IpRuleFactory.getIpv6Rules());
    }

    @Override
    public void validate(PValidationEvent event) throws PValidationException {
        Document doc = event.getDocument();
        try {
            String text = doc.getText(0, doc.getLength());
            if (text != null && text.length() != 0) {
                boolean valid = false;
                List rules = this.mySupportedVersions == 2 ? this.theHybridRules : (this.mySupportedVersions == 1 ? this.theIpv6Rules : (this.mySupportedVersions == 3 ? this.theIpv4v6Rules : this.theIpv4Rules));
                int i = 0;
                while (i < rules.size()) {
                    if (((IpRule)rules.get(i)).matches(text)) {
                        valid = true;
                        break;
                    }
                    ++i;
                }
                if (!valid) {
                    String message = WidgetResources.getString("OutOfIPRange_Text");
                    throw new PValidationException(MessageFormat.format(message, text));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

