/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.ipfield.rules;

import com.nokia.widgets.ipfield.rules.IpRule;
import com.nokia.widgets.ipfield.rules.Ipv6GapRule;
import java.util.ArrayList;
import java.util.List;

public final class IpRuleFactory {
    private static final List<IpRule> theHybridRules;
    private static final List<IpRule> theIpv4Rules;
    private static final List<IpRule> theIpv6Rules;

    static {
        theIpv6Rules = new ArrayList<IpRule>();
        theIpv6Rules.add(IpRuleFactory.createIpv6UnspecifiedAddress());
        theIpv6Rules.add(IpRuleFactory.createIpv6FullAddress());
        theIpv6Rules.add(IpRuleFactory.createIpv6PostfixAddress());
        theIpv6Rules.add(IpRuleFactory.createIpv6PrefixAddress());
        theIpv6Rules.add(IpRuleFactory.createIpv6GapAddress());
        theHybridRules = new ArrayList<IpRule>();
        theHybridRules.addAll(theIpv6Rules);
        theHybridRules.add(IpRuleFactory.createIpv6GapHybridAddress());
        theHybridRules.add(IpRuleFactory.createIpv6FullHybridAddress());
        theHybridRules.add(IpRuleFactory.createIpv6PostfixHybridAddress());
        theHybridRules.add(IpRuleFactory.createIpv6PrefixHybridAddress());
        theHybridRules.add(IpRuleFactory.createIpv4Address());
        theIpv4Rules = new ArrayList<IpRule>();
        theIpv4Rules.add(IpRuleFactory.createIpv4Address());
    }

    public static List<IpRule> getHybridRules() {
        return new ArrayList<IpRule>(theHybridRules);
    }

    public static List<IpRule> getIpv4Rules() {
        return new ArrayList<IpRule>(theIpv4Rules);
    }

    public static List<IpRule> getIpv6Rules() {
        return new ArrayList<IpRule>(theIpv6Rules);
    }

    public static IpRule createIpv6GapAddress() {
        return new Ipv6GapRule("^([0-9a-fA-F]{1,4}:){1,6}(:[0-9a-fA-F]{1,4}){1,6}$", 8);
    }

    public static IpRule createIpv6GapHybridAddress() {
        return new Ipv6GapRule("^([0-9a-fA-F]{1,4}:){1,4}:([0-9a-fA-F]{1,4}:){1,4}((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", 7);
    }

    public static IpRule createIpv4Address() {
        return new IpRule("^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$");
    }

    public static IpRule createIpv6FullAddress() {
        return new IpRule("^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    }

    public static IpRule createIpv6FullHybridAddress() {
        return new IpRule("^([0-9a-fA-F]{1,4}:){6}((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    }

    public static IpRule createIpv6PostfixAddress() {
        return new IpRule("^::([0-9a-fA-F]{1,4}:){0,6}[0-9a-fA-F]{1,4}$");
    }

    public static IpRule createIpv6PostfixHybridAddress() {
        return new IpRule("^::([0-9a-fA-F]{1,4}:){0,5}((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    }

    public static IpRule createIpv6PrefixAddress() {
        return new IpRule("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){0,6}::$");
    }

    public static IpRule createIpv6PrefixHybridAddress() {
        return new IpRule("^([0-9a-fA-F]{1,4}:){1,5}:((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    }

    public static IpRule createIpv6UnspecifiedAddress() {
        return new IpRule("^::$");
    }

    private IpRuleFactory() {
    }
}

