/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels;

import com.nokia.laf.NetStaticLabelUIHelper;
import com.nokia.laf.NetTextFieldUI;
import com.nokia.laf.text.NetStaticLabelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public abstract class AbstractStaticLabel
extends JComponent
implements Accessible {
    private static final String TEXT_FIELD_NAME = ".textField";
    private int myIconTextGap = 4;
    protected JTextComponent myTextComponent;
    protected JLabel myIconLabel;
    private int myIconAlignment = 2;
    private boolean myEnableAutoTooltip = true;
    protected int myTextRows;
    protected int myTextColumns;

    protected abstract JTextComponent createTextComponent(String var1);

    @Override
    public void setName(String name) {
        this.myTextComponent.setName(String.valueOf(name) + TEXT_FIELD_NAME);
        super.setName(name);
    }

    public void setText(String text) {
        this.myTextComponent.setText(text);
        this.myTextComponent.setCaretPosition(0);
        this.revalidate();
    }

    public String getText() {
        return this.myTextComponent.getText();
    }

    public void setIcon(Icon icon) {
        this.myIconLabel.setIcon(icon);
        this.myIconLabel.setVisible(icon != null);
    }

    public Icon getIcon() {
        return this.myIconLabel.getIcon();
    }

    public void setIconHorizontalAlignment(int alignment) {
        if (this.myIconAlignment != alignment) {
            this.myIconAlignment = alignment;
            this.layoutComponents();
        }
    }

    public int getIconHorizontalAlignment() {
        return this.myIconAlignment;
    }

    public JTextComponent getTextComponent() {
        return this.myTextComponent;
    }

    public void setTextName(String name) {
        if (this.myTextComponent != null) {
            this.myTextComponent.setName(name);
        }
    }

    public void setAutoTooltipEnabled(boolean enabled) {
        if (this.myEnableAutoTooltip != enabled) {
            this.myEnableAutoTooltip = enabled;
            this.repaint();
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.myEnableAutoTooltip = false;
        this.myTextComponent.setToolTipText(text);
        this.repaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (this.myIconTextGap != iconTextGap) {
            this.myIconTextGap = iconTextGap;
            this.layoutComponents();
        }
    }

    @Override
    public void paintComponent(Graphics gfx) {
        super.paintComponent(gfx);
        this.updateAutomaticTooltipVisibility(gfx);
    }

    public void setCompomentName(String name) {
        this.myTextComponent.setName(name);
    }

    protected void initialise(String text, Icon icon) {
        this.putClientProperty("OrangeTouch.isKeyboardFocusTraversable", Boolean.FALSE);
        this.myTextComponent = this.createTextComponent(text);
        this.myTextComponent.setUI(new StaticFieldUI());
        this.myTextComponent.putClientProperty("OrangeTouch.isKeyboardFocusTraversable", Boolean.FALSE);
        this.myTextComponent.setEditable(false);
        this.myTextComponent.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.myTextComponent.setOpaque(false);
        this.myTextComponent.setCaretPosition(0);
        this.myIconLabel = new JLabel(icon);
        this.myIconLabel.setVisible(icon != null);
        this.myIconLabel.setHorizontalAlignment(2);
        this.layoutComponents();
        this.myTextComponent.setCursor(Cursor.getPredefinedCursor(2));
    }

    private void layoutComponents() {
        this.remove(this.myTextComponent);
        this.remove(this.myIconLabel);
        this.setLayout(new BorderLayout(this.myIconTextGap, 0));
        if (this.myIconAlignment == 2) {
            this.add((Component)this.myIconLabel, "West");
            this.add((Component)this.myTextComponent, "Center");
        } else {
            this.add((Component)this.myTextComponent, "West");
            this.add((Component)this.myIconLabel, "Center");
        }
        this.validate();
    }

    private void updateAutomaticTooltipVisibility(Graphics graphics) {
        if (!this.myEnableAutoTooltip || !(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D gr2d = (Graphics2D)graphics;
        String tooltipText = null;
        String text = this.myTextComponent.getText();
        if (text != null && text.length() > 0) {
            Font font = this.myTextComponent.getFont();
            TextLayout tl = new TextLayout(text, font, gr2d.getFontRenderContext());
            Rectangle textBounds = tl.getBounds().getBounds();
            Rectangle visibleFieldBounds = this.myTextComponent.getVisibleRect();
            int textBorderGap = this.myTextComponent.getHeight() - font.getSize();
            if (textBounds.width > visibleFieldBounds.width || textBounds.height > visibleFieldBounds.height - textBorderGap) {
                tooltipText = text;
            }
        }
        this.myTextComponent.setToolTipText(tooltipText);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAbstractStaticLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAbstractStaticLabel
    extends JComponent.AccessibleJComponent {
        protected AccessibleAbstractStaticLabel() {
            super(AbstractStaticLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null) {
                name = AbstractStaticLabel.this.getText();
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext ac;
            Icon icon = AbstractStaticLabel.this.getIcon();
            if (icon instanceof Accessible && (ac = ((Accessible)((Object)icon)).getAccessibleContext()) != null && ac instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)ac)};
            }
            return null;
        }
    }

    static class StaticFieldUI
    extends NetTextFieldUI {
        private NetStaticLabelUIHelper myHelper;

        StaticFieldUI() {
        }

        @Override
        public View create(Element elem) {
            Document doc = elem.getDocument();
            Object i18nFlag = doc.getProperty("i18n");
            if (Boolean.TRUE.equals(i18nFlag)) {
                return super.create(elem);
            }
            return new NetStaticLabelView(elem, 0);
        }

        @Override
        public void installDefaults() {
            super.installDefaults();
            if (this.myHelper == null) {
                this.myHelper = new NetStaticLabelUIHelper();
            }
        }

        @Override
        public void installUI(JComponent component) {
            super.installUI(component);
            if (this.myHelper != null) {
                this.myHelper.propertyChanged(component);
            }
        }

        @Override
        public void uninstallDefaults() {
            super.uninstallDefaults();
            if (this.myHelper != null) {
                this.myHelper.uninstallDefaults();
            }
            this.myHelper = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            super.propertyChange(event);
            if (event.getPropertyName().equals("labelType") && this.myHelper != null) {
                this.myHelper.propertyChanged((JComponent)event.getSource());
            }
        }
    }
}

