/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class ItemCountLabel
extends PLabel {
    private int myItemCount;
    private Color myIconBackground;
    private Color myIconForeground;

    public ItemCountLabel() {
        this.setIcon(new CountIcon());
        this.init();
    }

    protected void init() {
        this.setHorizontalTextPosition(2);
        this.myIconBackground = UIManager.getColor("TextField.ItemCountBackground");
        this.myIconForeground = UIManager.getColor("TextField.ItemCountForeground");
    }

    public int getItemCount() {
        return this.myItemCount;
    }

    public void setItemCount(int itemCount) {
        this.myItemCount = itemCount;
    }

    public void setIconBackground(Color iconBackground) {
        this.myIconBackground = iconBackground;
    }

    public void setIconForeground(Color iconForeground) {
        this.myIconForeground = iconForeground;
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    private class CountIcon
    implements Icon,
    UIResource {
        private CountIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (ItemCountLabel.this.myItemCount >= 0) {
                this.paintItemCount(c, g, x, y);
            }
        }

        private void paintItemCount(Component c, Graphics g, int x, int y) {
            if (ItemCountLabel.this.myItemCount == 0) {
                return;
            }
            Object oldAa = NetUtils.antiAliasingOn(g);
            int symbolWidth = this.getCountSymbolWidth();
            float fontSize = ScaleUtils.scale(12);
            RectangularShape roundRect = NetUtils.getRoundedRect((JComponent)c, x, y - 1, symbolWidth, (int)(fontSize + 6.0f), 14);
            g.setColor(ItemCountLabel.this.myIconBackground);
            ((Graphics2D)g).fill(roundRect);
            GradientUtils.drawVerticalGradientOutline((JComponent)c, g, new Color[]{NetLookAndFeel.getFocusColor(), NetLookAndFeel.getWhite()}, (Shape)roundRect);
            g.setColor(ItemCountLabel.this.myIconForeground);
            Font oldFont = g.getFont();
            g.setFont(g.getFont().deriveFont(fontSize).deriveFont(1));
            FontMetrics fm = g.getFontMetrics();
            String countString = String.valueOf(ItemCountLabel.this.myItemCount);
            int stringWidth = fm.stringWidth(countString);
            g.drawString(String.valueOf(ItemCountLabel.this.myItemCount), this.getStringXCoordinate(x, symbolWidth, stringWidth), y - 1 + fm.getAscent());
            g.setFont(oldFont);
            NetUtils.setAntialiasing(g, oldAa);
        }

        private int getCountSymbolWidth() {
            String items = String.valueOf(ItemCountLabel.this.myItemCount);
            return ScaleUtils.scale(18 + (items.length() - 1) * 7);
        }

        private int getStringXCoordinate(int x, int symbolWidth, int stringWidth) {
            return x + (symbolWidth - stringWidth) / 2;
        }

        @Override
        public int getIconWidth() {
            int result = 0;
            if (ItemCountLabel.this.myItemCount >= 0) {
                result += this.getCountSymbolWidth();
            }
            return result;
        }

        @Override
        public int getIconHeight() {
            return ScaleUtils.scale(15);
        }
    }
}

