/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.highlight.LabelHighlighter;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.NSNColors;
import java.awt.Color;
import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;

public class PLabel
extends JLabel {
    private Color myHighlightColor;

    public static PLabel createTipText(String text) {
        PLabel label = new PLabel(text);
        label.putClientProperty("labelType", ClientProperties.LABEL_TIP_TEXT);
        return label;
    }

    public static PLabel createTipLabel(String text) {
        PLabel label = new PLabel(text);
        label.putClientProperty("labelType", ClientProperties.LABEL_TIP_LABEL);
        return label;
    }

    public static PLabel createSystemText(String text) {
        PLabel label = new PLabel(text);
        label.putClientProperty("labelType", ClientProperties.LABEL_SYSTEM_TEXT);
        return label;
    }

    public static PLabel createTitle(String text) {
        PLabel label = new PLabel(text);
        label.putClientProperty("labelType", ClientProperties.LABEL_TITLE);
        return label;
    }

    public static PLabel createRangeLabel(String text) {
        PLabel label = new PLabel(text);
        label.putClientProperty("labelType", ClientProperties.LABEL_RANGE);
        return label;
    }

    public static PLabel createTitle() {
        return PLabel.createTitle("");
    }

    public static PLabel createSystemText() {
        return PLabel.createSystemText("");
    }

    public static PLabel createRangeLabel() {
        return PLabel.createRangeLabel("");
    }

    public static PLabel createLabel() {
        return PLabel.createLabel("");
    }

    public static PLabel createLabel(String text) {
        return new PLabel(text);
    }

    public static PLabel createValueText() {
        return PLabel.createValueText("");
    }

    public static PLabel createValueText(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_VALUE_TEXT);
        return label;
    }

    public static PLabel createVisualizationHeader() {
        return PLabel.createVisualizationHeader("");
    }

    public static PLabel createVisualizationHeader(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_VISUALIZATION_HEADER);
        return label;
    }

    public static PLabel createProductName() {
        return PLabel.createProductName("");
    }

    public static PLabel createProductName(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_PRODUCT_NAME);
        return label;
    }

    public static PLabel createHeader() {
        return PLabel.createHeader("");
    }

    public static PLabel createHeader(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_HEADER);
        return label;
    }

    public static PLabel createSubHeader() {
        return PLabel.createSubHeader("");
    }

    public static PLabel createSubHeader(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_SUB_HEADER);
        return label;
    }

    public static PLabel createText() {
        return PLabel.createText("");
    }

    public static PLabel createText(String text) {
        PLabel label = new PLabel(text);
        label.setLabelType(ClientProperties.LABEL_TEXT);
        return label;
    }

    public static PLabel createCalendarDay() {
        return PLabel.createCalendarDay("");
    }

    public static PLabel createCalendarDay(String text) {
        PLabel label = new PLabel(text.toUpperCase());
        label.setLabelType(ClientProperties.LABEL_CALENDAR_DAYS);
        return label;
    }

    public PLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.putClientProperty("OrangeTouch.automaticTooltipEnabled", Boolean.TRUE);
    }

    public PLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public void setOffsetForeground(Color color) {
        this.putClientProperty("OrangeTouch.labelOffsetColor", color);
    }

    public Color getOffsetForeground() {
        return (Color)this.getClientProperty("OrangeTouch.labelOffsetColor");
    }

    public boolean highlight(String text) {
        String escapedText = null;
        if (text != null && text.length() > 0) {
            escapedText = text.replaceAll("(\\p{Punct})", "\\\\$1");
        }
        if (escapedText == null) {
            this.clearSelection();
            this.repaint();
            return false;
        }
        escapedText = escapedText.toLowerCase();
        Pattern p = Pattern.compile(escapedText);
        String lowerCaseText = this.getText().toLowerCase();
        Matcher m = p.matcher(lowerCaseText);
        boolean found = false;
        while (m.find()) {
            this.addSelection(m.start(), m.end());
            found = true;
        }
        this.repaint();
        return found;
    }

    public void setHighlightColor(Color highlightColor) {
        this.myHighlightColor = highlightColor;
        this.repaint();
    }

    public void addSelection(int start, int end, Color color) {
        NetUtils.addHighlight(this, start, end, color);
        this.repaint();
    }

    public void addSelection(int start, int end) {
        Color color = this.myHighlightColor != null ? this.myHighlightColor : NSNColors.getGreen();
        this.addSelection(start, end, color);
    }

    public void clearSelection() {
        LabelHighlighter highlighter = (LabelHighlighter)this.getClientProperty("OrangeTouch.highlighter");
        if (highlighter != null) {
            highlighter.removeAllHighlights();
            this.repaint();
        }
    }

    public LabelHighlighter getHighLighter() {
        return (LabelHighlighter)this.getClientProperty("OrangeTouch.highlighter");
    }

    public void setHighlighter(LabelHighlighter highligher) {
        this.putClientProperty("OrangeTouch.highlighter", highligher);
    }

    public PLabel(String text) {
        this(text, null, 10);
    }

    public PLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public PLabel(Icon image) {
        this(null, image, 0);
    }

    public PLabel() {
        this("", null, 10);
    }

    public void setLabelType(Integer type) {
        ComponentUtils.setLabelType(type, this);
    }

    public void setLabelTextSize(float fontSize) {
        Font font = this.getFont();
        this.setFont(font.deriveFont(fontSize));
    }

    public void setLabelTextBold() {
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getStyle() | 1));
    }

    public Integer getLabelType() {
        return ComponentUtils.getLabelType(this);
    }

    public void setAutoTooltipEnabled(boolean enabled) {
        this.putClientProperty("OrangeTouch.automaticTooltipEnabled", enabled);
    }

    public void setTextClipOrientation(int orientation) {
        this.putClientProperty("OrangeTouch.textClipOrientation", orientation);
    }

    public void setRangeTextIndex(int[] indices) {
        this.putClientProperty("labelType", ClientProperties.LABEL_RANGE);
        this.putClientProperty("Label.rangeTextIndex", indices);
    }

    public void setRangeTextIndex(int indices) {
        this.setRangeTextIndex(new int[]{indices});
    }
}

