/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.AbstractStaticLabel;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class PMultiLineStaticLabel
extends AbstractStaticLabel {
    public PMultiLineStaticLabel() {
        this(null);
    }

    public PMultiLineStaticLabel(String text) {
        this(text, 0, 0);
    }

    public PMultiLineStaticLabel(int rows, int columns) {
        this(null, rows, columns);
    }

    public PMultiLineStaticLabel(String text, int rows, int columns) {
        this(text, rows, columns, null);
    }

    public PMultiLineStaticLabel(String text, Icon icon) {
        this(text, 0, 0, icon);
    }

    public PMultiLineStaticLabel(String text, int rows, int columns, Icon icon) {
        this.myTextRows = rows;
        this.myTextColumns = columns;
        this.initialise(text, icon);
        this.myIconLabel.setVerticalAlignment(1);
    }

    public JTextArea getTextArea() {
        return (JTextArea)this.getTextComponent();
    }

    public static PMultiLineStaticLabel createSystemText(String text) {
        PMultiLineStaticLabel label = new PMultiLineStaticLabel(text);
        label.getTextArea().putClientProperty("labelType", ClientProperties.LABEL_SYSTEM_TEXT);
        return label;
    }

    public static PMultiLineStaticLabel createTitle(String text) {
        PMultiLineStaticLabel label = new PMultiLineStaticLabel(text);
        label.getTextArea().putClientProperty("labelType", ClientProperties.LABEL_TITLE);
        return label;
    }

    @Override
    protected JTextComponent createTextComponent(String text) {
        return new JTextArea(text, this.myTextRows, this.myTextColumns){

            @Override
            public void updateUI() {
                this.setUI(new AbstractStaticLabel.StaticFieldUI());
                this.invalidate();
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myTextComponent != null) {
            this.setPreferredSizeForTextArea();
        }
        return super.getPreferredSize();
    }

    private void setPreferredSizeForTextArea() {
        String[] lines = NetUtils.breakupLines(this.myTextComponent.getText());
        int maxTextAreaWidth = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int stringWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.myTextComponent.getFont()), line);
            int borderWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.myTextComponent.getFont()), "##");
            if ((stringWidth += borderWidth) > maxTextAreaWidth) {
                maxTextAreaWidth = stringWidth;
            }
            ++n2;
        }
        this.getTextArea().setPreferredSize(new Dimension(maxTextAreaWidth, new Double(this.getTextArea().getPreferredSize().getHeight()).intValue()));
    }
}

