/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.PLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;

public class PTimerLabel
extends PLabel
implements ActionListener {
    protected static final int TIMER_UPDATE_INTERVAL = 1000;
    protected Timer myTimer;
    protected long myCounter;

    public PTimerLabel() {
        this.setLabelType(ClientProperties.LABEL_VALUE_TEXT);
        this.myTimer = new Timer(1000, this);
        this.updateTime();
    }

    public void setTimeInSeconds(long seconds) {
        this.myCounter = seconds;
        this.updateTime();
    }

    public void start() {
        this.reset();
        this.resume();
    }

    public void resume() {
        this.myTimer.restart();
    }

    public void stop() {
        this.myTimer.stop();
    }

    public void reset() {
        this.myCounter = 0L;
        this.updateTime();
    }

    protected void updateTime() {
        long milliseconds = this.myCounter * 1000L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds) - TimeUnit.MINUTES.toSeconds(minutes);
        String time = String.format("%02d:%02d", minutes, seconds);
        this.setText(time);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ++this.myCounter;
        this.updateTime();
    }
}

