/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels.highlight;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.labels.highlight.LabelHighlightPainter;
import com.nokia.widgets.util.NSNColors;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.swing.JLabel;

public class DefaultLabelHighlightPainter
implements LabelHighlightPainter {
    private Color myHighlightColor;
    private Color myForegroundColor = null;

    public DefaultLabelHighlightPainter() {
        this(NSNColors.getGreen());
    }

    public DefaultLabelHighlightPainter(Color highlightColor) {
        this.myHighlightColor = highlightColor;
    }

    public void setForegroundColor(Color foreground) {
        this.myForegroundColor = foreground;
    }

    @Override
    public void paint(Graphics g, JLabel label, Point2D start, Point2D end, Shape bounds) {
        Color oldColor = g.getColor();
        Rectangle textRect = bounds.getBounds();
        g.setColor(this.myHighlightColor);
        g.fillRect(textRect.x + (int)start.getX(), textRect.y, (int)(end.getX() - start.getX()), textRect.height);
        g.setColor(oldColor);
    }

    @Override
    public void paintForeground(Graphics g, JLabel label, Point2D start, Point2D end, Shape bounds) {
        Color oldColor = g.getColor();
        Color foregroundColor = this.myForegroundColor;
        if (this.myForegroundColor == null) {
            foregroundColor = NSNColors.getPurple().equals(this.myHighlightColor) ? NetLookAndFeel.getWhite() : NetLookAndFeel.getBlack();
        }
        Rectangle textRect = bounds.getBounds();
        Shape oldClip = g.getClip();
        g.clipRect(textRect.x + (int)start.getX(), textRect.y, (int)(end.getX() - start.getX()), textRect.height);
        g.setColor(foregroundColor);
        String text = label.getText();
        if ((text.contains(NetUtils.LINE_SEPARATOR) || text.contains("\n")) && label.getVerticalTextPosition() == 1 && label.getVerticalAlignment() == 1) {
            String[] lines = NetUtils.breakupLines(text);
            int line = textRect.y / textRect.height;
            text = lines[line];
        }
        g.drawString(text, textRect.x, textRect.y + label.getFontMetrics(label.getFont()).getAscent());
        g.setClip(oldClip);
        g.setColor(oldColor);
    }
}

