/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.labels.highlight;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.labels.highlight.LabelHighlightInfo;
import com.nokia.widgets.labels.highlight.LabelHighlightPainter;
import com.nokia.widgets.labels.highlight.LabelHighlighter;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DefaultLabelHighlighter
implements LabelHighlighter {
    private List<LabelHighlightInfo> myHighlighPainters = new ArrayList<LabelHighlightInfo>();
    private static PaintCommand HIGHLIGHT_PAINT = new PaintCommand(){

        @Override
        public void doPaint(Graphics g, JLabel label, LabelHighlightPainter painter, Point2D start, Point2D end, Rectangle textRect) {
            painter.paint(g, label, start, end, textRect);
        }
    };
    private static PaintCommand FOREGROUND_PAINT = new PaintCommand(){

        @Override
        public void doPaint(Graphics g, JLabel label, LabelHighlightPainter painter, Point2D start, Point2D end, Rectangle textRect) {
            painter.paintForeground(g, label, start, end, textRect);
        }
    };

    @Override
    public void addHighlight(int start, int end, LabelHighlightPainter painter) {
        LabelHighlightInfo info = new LabelHighlightInfo(start, end, painter);
        this.myHighlighPainters.add(info);
    }

    @Override
    public List<LabelHighlightInfo> getHighlights() {
        return new ArrayList<LabelHighlightInfo>(this.myHighlighPainters);
    }

    @Override
    public void paint(Graphics g, JLabel label, Rectangle textRect) {
        this.doPaint(g, label, textRect, HIGHLIGHT_PAINT);
    }

    @Override
    public void paintForeground(Graphics g, JLabel label, Rectangle textRect) {
        this.doPaint(g, label, textRect, FOREGROUND_PAINT);
    }

    protected void doPaint(Graphics g, JLabel label, Rectangle textRect, PaintCommand paintCommand) {
        String text = label.getText();
        if (text != null && (text.contains(NetUtils.LINE_SEPARATOR) || text.contains("\n"))) {
            this.doPaintForMultiLines(g, label, textRect, paintCommand, text);
        } else if (text != null) {
            this.doPaintForSingleLine(g, label, textRect, paintCommand, text);
        }
    }

    protected void doPaintForSingleLine(Graphics g, JLabel label, Rectangle textRect, PaintCommand paintCommand, String text) {
        GlyphVector glyphs = label.getFont().createGlyphVector(((Graphics2D)g).getFontRenderContext(), text);
        for (LabelHighlightInfo highlightInfo : this.myHighlighPainters) {
            LabelHighlightPainter painter = highlightInfo.getPainter();
            int start = highlightInfo.getStart();
            int end = highlightInfo.getEnd();
            int glyphCount = glyphs.getNumGlyphs();
            if (start < 0 || end < 0 || start > end || glyphCount <= start || end > glyphCount) continue;
            Point2D startPoint = glyphs.getGlyphPosition(start);
            Point2D endPoint = glyphs.getGlyphPosition(end);
            paintCommand.doPaint(g, label, painter, startPoint, endPoint, textRect);
        }
    }

    protected void doPaintForMultiLines(Graphics g, JLabel label, Rectangle textRect, PaintCommand paintCommand, String text) {
        String[] lines = NetUtils.breakupLines(text);
        FontMetrics fm = g.getFontMetrics();
        int numLines = lines.length;
        Rectangle textR = new Rectangle(textRect.x, textRect.y, textRect.width, textRect.height);
        int yPonintFortextR = textR.y;
        block0: for (LabelHighlightInfo highlightInfo : this.myHighlighPainters) {
            LabelHighlightPainter painter = highlightInfo.getPainter();
            int start = highlightInfo.getStart();
            int end = highlightInfo.getEnd();
            int line = 0;
            while (line < numLines) {
                int lineLength = lines[line].length();
                if (start >= lineLength) {
                    start -= lineLength;
                    end -= lineLength;
                } else {
                    Point endPoint;
                    Point startPoint;
                    if (end < lineLength) {
                        startPoint = new Point(SwingUtilities.computeStringWidth(fm, lines[line].substring(0, start)), line * textR.height);
                        endPoint = new Point(SwingUtilities.computeStringWidth(fm, lines[line].substring(0, end)), line * textR.height);
                        textR.y = line * textR.height + yPonintFortextR;
                        paintCommand.doPaint(g, label, painter, startPoint, endPoint, textR);
                        continue block0;
                    }
                    startPoint = new Point(SwingUtilities.computeStringWidth(fm, lines[line].substring(0, start)), line * textR.height);
                    endPoint = new Point(SwingUtilities.computeStringWidth(fm, lines[line].substring(0, lineLength)), line * textR.height);
                    textR.y = line * textR.height + yPonintFortextR;
                    paintCommand.doPaint(g, label, painter, startPoint, endPoint, textR);
                    start = 0;
                    end -= lineLength;
                }
                ++line;
            }
        }
    }

    @Override
    public void removeAllHighlights() {
        this.myHighlighPainters.clear();
    }

    private static interface PaintCommand {
        public void doPaint(Graphics var1, JLabel var2, LabelHighlightPainter var3, Point2D var4, Point2D var5, Rectangle var6);
    }
}

