/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class ExtendedGridBagConstraints
extends GridBagConstraints {
    public static final int EMPTY_SPACING = 0;
    public static final int SMALL_SPACING = 3;
    public static final int GROUPED_SPACING = 6;
    public static final int MEDIUM_SPACING = 6;
    public static final int NORMAL_SPACING = 12;
    private static final Insets theNormalInsets = new Insets(3, 12, 3, 0);
    private static final Insets theGroupedInsets = new Insets(6, 6, 0, 0);
    private static final Insets theHeaderInsets = new Insets(6, 0, 6, 0);

    public ExtendedGridBagConstraints() {
        this.insets = (Insets)theNormalInsets.clone();
        this.anchor = 17;
        this.gridx = 0;
        this.gridy = 0;
    }

    public void nextRow() {
        ++this.gridy;
        this.gridx = 0;
    }

    public void nextRowSameColumn() {
        ++this.gridy;
    }

    public void nextColumn() {
        ++this.gridx;
    }

    public void skipRows(int rowCount) throws IllegalArgumentException {
        if (this.gridy + rowCount < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal row skip count " + rowCount);
        }
        this.gridy += rowCount;
        this.gridx = 0;
    }

    public void skipColumns(int columnCount) throws IllegalArgumentException {
        if (this.gridx + columnCount < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal column skip count " + columnCount);
        }
        this.gridx += columnCount;
    }

    public void jumpToRow(int row) throws IllegalArgumentException {
        if (row < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal row " + row);
        }
        this.gridy = row;
        this.gridx = 0;
    }

    public void jumpToColumn(int column) throws IllegalArgumentException {
        if (column < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal column " + column);
        }
        this.gridx = column;
    }

    public void jumpTo(int row, int column) throws IllegalArgumentException {
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal row " + row + " or column " + column);
        }
        this.gridy = row;
        this.gridx = column;
    }

    public void useHeaderInsets() {
        this.insets = (Insets)theHeaderInsets.clone();
    }

    public void useGroupedInsets() {
        this.insets = (Insets)theGroupedInsets.clone();
    }

    public void useNormalInsets() {
        this.insets = (Insets)theNormalInsets.clone();
    }

    public void useSpecificInsets(Insets newInsets) {
        this.insets = newInsets;
    }

    public void setBottomInset(int bottom) {
        this.insets.bottom = bottom;
    }

    public void setTopInset(int top) {
        this.insets.top = top;
    }

    public void setLeftInset(int left) {
        this.insets.left = left;
    }

    public void setRightInset(int right) {
        this.insets.right = right;
    }

    public void fillNone() {
        this.fill = 0;
    }

    public void fillBoth() {
        this.fill = 1;
    }

    public void fillHorizontal() {
        this.fill = 2;
    }

    public void fillVertical() {
        this.fill = 3;
    }

    public void setAnchor(int componentPlace) {
        if (componentPlace < 10 || componentPlace > 2304) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal anchor value " + componentPlace);
        }
        this.anchor = componentPlace;
    }

    public void setColumnWidth(int columns) {
        this.gridwidth = columns;
    }

    public void setColumnHeight(int rows) {
        this.gridheight = rows;
    }

    public void setColumnHorizontalWeigth(double weight) throws IllegalArgumentException {
        if (weight < 0.0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal horizontal weight " + weight);
        }
        this.weightx = weight;
    }

    public void setColumnVerticalWeigth(double weight) throws IllegalArgumentException {
        if (weight < 0.0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Illegal vertical weight " + weight);
        }
        this.weighty = weight;
    }
}

