/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class LayoutUtils {
    public static Dimension getMaximumPreferredSize(Component[] comps) {
        int maxWidth = 0;
        int maxHeight = 0;
        int idx = 0;
        while (idx < comps.length) {
            Component comp = comps[idx];
            Dimension prefSize = comp.getPreferredSize();
            maxWidth = Math.max(prefSize.width, maxWidth);
            maxHeight = Math.max(prefSize.height, maxHeight);
            ++idx;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    public static int getPreferredWidth(Container parent) {
        Insets insets = parent.getInsets();
        int result = insets.left + insets.right;
        Component[] children = parent.getComponents();
        int idx = 0;
        while (idx < children.length) {
            Component comp = children[idx];
            if (comp.isVisible()) {
                result += comp.getPreferredSize().width;
            }
            ++idx;
        }
        return result;
    }
}

