/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;

public class PButtonRowLayout
implements LayoutManager {
    private JButton myHelpButton;
    protected static final int HGAP = 5;
    protected static final int HMARGIN = 17;
    protected static final int VMARGIN = SystemUtils.isCondensedTheme() ? 12 : 18;
    private int myHgap = 5;
    private int myHmargin = 17;
    private int myVmargin = VMARGIN;

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public void setVMargin(int vmargin) {
        this.myVmargin = vmargin;
    }

    public void setHMargin(int hmargin) {
        this.myHmargin = hmargin;
    }

    public void setHGap(int hgap) {
        this.myHgap = hgap;
    }

    public int getVMargin() {
        return this.myVmargin;
    }

    public int getHMargin() {
        return this.myHmargin;
    }

    public int getHGap() {
        return this.myHgap;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension max = new Dimension();
        int buttonsAndGaps = this.findMaxDimension(max, target);
        Insets insets = target.getInsets();
        int totalWidth = insets.left + insets.right + this.myHmargin * 2 + buttonsAndGaps;
        int totalHeight = insets.top + insets.bottom + this.myVmargin * 2 + max.height;
        if (this.myHelpButton != null) {
            totalWidth += 2 * (this.myHelpButton.getPreferredSize().width + this.myHgap);
        }
        return new Dimension(totalWidth, totalHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    private int getMaxHeight(Container target) {
        Component[] comps = target.getComponents();
        int result = 0;
        int idx = 0;
        while (idx < comps.length) {
            result = Math.max(result, comps[idx].getPreferredSize().height);
            ++idx;
        }
        return result;
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension max = new Dimension();
        this.findMaxDimension(max, target);
        Insets insets = target.getInsets();
        int maxHeight = this.getMaxHeight(target);
        int componentTop = insets.top + this.myVmargin;
        int numComponents = target.getComponentCount();
        int leading = target.getWidth() - insets.right - this.myHmargin;
        int i = numComponents - 1;
        while (i >= 0) {
            Component comp = target.getComponent(i);
            if (comp.isVisible() && !comp.equals(this.myHelpButton)) {
                int y = componentTop + (maxHeight - comp.getPreferredSize().height) / 2;
                comp.setLocation(leading -= max.width, y);
                comp.setSize(max);
                leading -= this.myHgap;
            }
            --i;
        }
        if (this.myHelpButton != null) {
            Dimension helpBtnSize = this.myHelpButton.getPreferredSize();
            int y = componentTop + (maxHeight - helpBtnSize.height) / 2;
            this.myHelpButton.setLocation(insets.left + this.myHmargin + 2, y);
            this.myHelpButton.setSize(helpBtnSize);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected int getLeading(Container target, int buttonsAndGaps, Dimension max) {
        double width = target.getSize().getWidth();
        return target.getComponentOrientation().isLeftToRight() ? (int)(width - (double)buttonsAndGaps) / 2 : (int)(width + (double)buttonsAndGaps) / 2 - max.width;
    }

    protected int findMaxDimension(Dimension max, Container target) {
        int numComponents = target.getComponentCount();
        int maxWidth = 0;
        int maxHeight = 0;
        int numVisibleComponents = 0;
        int i = 0;
        while (i < numComponents) {
            Component comp = target.getComponent(i);
            if (comp.isVisible()) {
                Dimension compPrefSize = comp.getPreferredSize();
                if (!(comp instanceof PHelpButton)) {
                    ++numVisibleComponents;
                    maxWidth = Math.max(maxWidth, compPrefSize.width);
                } else {
                    this.myHelpButton = (JButton)comp;
                }
                maxHeight = Math.max(maxHeight, compPrefSize.height);
            }
            ++i;
        }
        max.setSize(maxWidth, maxHeight);
        return numVisibleComponents * maxWidth + (numVisibleComponents - 1) * this.myHgap;
    }
}

