/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PHorizontalLayout
implements LayoutManager {
    public static final int NO_SPACING = 0;
    public static final int SMALL_SPACING = 6;
    public static final int NORMAL_SPACING = 12;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int CENTER = 2;
    public static final int STRETCH = 3;
    private static final int DEFAULT_HGAP = 12;
    private static final int DEFAULT_HMARGIN = 12;
    private static final int DEFAULT_VMARGIN = 12;
    private int myVerticalAlignment;
    private int myHgap;
    private int myHMargin;
    private int myVMargin;

    public PHorizontalLayout() {
        this(2, 12, 12, 12);
    }

    public PHorizontalLayout(int verticalAlignment) {
        this(verticalAlignment, 12, 12, 12);
    }

    public PHorizontalLayout(int verticalAlignment, int hGap, int hMargin, int vMargin) {
        if (verticalAlignment != 0 && verticalAlignment != 1 && verticalAlignment != 2 && verticalAlignment != 3) {
            throw new IllegalArgumentException("Illegal vertical alignment value: " + verticalAlignment);
        }
        this.myVerticalAlignment = verticalAlignment;
        this.myHgap = hGap;
        this.myHMargin = hMargin;
        this.myVMargin = vMargin;
    }

    public int getVerticalAlignment() {
        return this.myVerticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        if (verticalAlignment != 0 && verticalAlignment != 1 && verticalAlignment != 2 && verticalAlignment != 3) {
            throw new IllegalArgumentException("Illegal vertical alignment value: " + verticalAlignment);
        }
        this.myVerticalAlignment = verticalAlignment;
    }

    public int getHGap() {
        return this.myHgap;
    }

    public void setHGap(int hGap) {
        this.myHgap = hGap;
    }

    public int getHMargin() {
        return this.myHMargin;
    }

    public void setHMargin(int hMargin) {
        this.myHMargin = hMargin;
    }

    public int getVMargin() {
        return this.myVMargin;
    }

    public void setVMargin(int vMargin) {
        this.myVMargin = vMargin;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension prefSize = new Dimension(0, 0);
        int numComponents = target.getComponentCount();
        boolean firstVisible = true;
        int i = 0;
        while (i < numComponents) {
            Component comp = target.getComponent(i);
            if (comp.isVisible()) {
                Dimension compPrefSize = comp.getPreferredSize();
                prefSize.height = Math.max(prefSize.height, compPrefSize.height);
                if (firstVisible) {
                    firstVisible = false;
                } else {
                    prefSize.width += this.myHgap;
                }
                prefSize.width += compPrefSize.width;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        prefSize.width += insets.left + insets.right + this.myHMargin * 2;
        prefSize.height += insets.top + insets.bottom + this.myVMargin * 2;
        return prefSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        int numComponents = target.getComponentCount();
        Insets insets = target.getInsets();
        Dimension size = target.getSize();
        int totalHeight = size.height - (insets.top + insets.bottom + 2 * this.myVMargin);
        boolean layoutFromLeft = target.getComponentOrientation().isLeftToRight();
        int x = insets.left + this.myHMargin;
        if (!layoutFromLeft) {
            x = size.width - insets.right - this.myHMargin;
        }
        int i = 0;
        while (i < numComponents) {
            Component comp = target.getComponent(i);
            if (comp.isVisible()) {
                Dimension compPrefSize = comp.getPreferredSize();
                int newHeight = compPrefSize.height;
                int y = insets.top + this.myVMargin;
                switch (this.myVerticalAlignment) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        y += totalHeight - compPrefSize.height;
                        break;
                    }
                    case 2: {
                        y += (totalHeight - compPrefSize.height) / 2;
                        break;
                    }
                    case 3: {
                        newHeight = totalHeight;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid myVerticalAlignment value");
                    }
                }
                if (!layoutFromLeft) {
                    x -= compPrefSize.width;
                }
                comp.setLocation(x, y);
                comp.setSize(new Dimension(compPrefSize.width, newHeight));
                x = layoutFromLeft ? (x += compPrefSize.width + this.myHgap) : (x -= this.myHgap);
            }
            ++i;
        }
    }

    public String toString() {
        String str = "";
        switch (this.myVerticalAlignment) {
            case 0: {
                str = ", align=top";
                break;
            }
            case 1: {
                str = ", align=bottom";
                break;
            }
            case 2: {
                str = ", align=center";
                break;
            }
            case 3: {
                str = ", align=stretch";
                break;
            }
            default: {
                str = String.valueOf(str) + ", align=INVALID(" + this.myVerticalAlignment + ")";
            }
        }
        str = String.valueOf(this.getClass().getName()) + " [ hgap=" + this.myHgap + ", hMargin=" + this.myHMargin + ", vMargin=" + this.myVMargin + str + " ]";
        return str;
    }
}

