/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PMatrixLayout
implements LayoutManager {
    public static final int NO_SPACING = 0;
    public static final int SMALL_SPACING = 6;
    public static final int NORMAL_SPACING = 12;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int CENTER = 2;
    public static final int STRETCH = 3;
    private static final int DEFAULT_HGAP = 12;
    private static final int DEFAULT_VGAP = 12;
    private static final int DEFAULT_HMARGIN = 12;
    private static final int DEFAULT_VMARGIN = 12;
    private int myHgap;
    private int myVgap;
    private int myHMargin;
    private int myVMargin;
    private int myNumColumns;
    private int myComponentHorizontalAlignment = 0;
    private int myComponentVerticalAlignment = 0;
    private int myMatrixHorizontalAlignment = 0;
    private int myMatrixVerticalAlignment = 0;

    public PMatrixLayout(int numColumns) {
        this(numColumns, 12, 12, 12, 12);
    }

    public PMatrixLayout(int numColumns, int hGap, int vGap, int hMargin, int vMargin) {
        this.myNumColumns = numColumns;
        this.myHgap = hGap;
        this.myVgap = vGap;
        this.myHMargin = hMargin;
        this.myVMargin = vMargin;
    }

    public int getNumColumns() {
        return this.myNumColumns;
    }

    public void setNumColumns(int numColumns) {
        this.myNumColumns = numColumns;
    }

    public int getHgap() {
        return this.myHgap;
    }

    public void setHgap(int hGap) {
        this.myHgap = hGap;
    }

    public int getVgap() {
        return this.myVgap;
    }

    public void setVgap(int vGap) {
        this.myVgap = vGap;
    }

    public int getHMargin() {
        return this.myHMargin;
    }

    public void setHMargin(int hMargin) {
        this.myHMargin = hMargin;
    }

    public int getVMargin() {
        return this.myVMargin;
    }

    public void setVMargin(int vMargin) {
        this.myVMargin = vMargin;
    }

    public int getComponentHorizontalAlignment() {
        return this.myComponentHorizontalAlignment;
    }

    public void setComponentHorizontalAlignment(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3 && align != 4 && align != 5) {
            throw new IllegalArgumentException("Illegal horizontal alignment value: " + align);
        }
        this.myComponentHorizontalAlignment = align;
    }

    public int getComponentVerticalAlignment() {
        return this.myComponentVerticalAlignment;
    }

    public void setComponentVerticalAlignment(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3) {
            throw new IllegalArgumentException("Illegal vertical alignment value: " + align);
        }
        this.myComponentVerticalAlignment = align;
    }

    public int getMatrixHorizontalAlignment() {
        return this.myMatrixHorizontalAlignment;
    }

    public void setMatrixHorizontalAlignment(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3 && align != 4 && align != 5) {
            throw new IllegalArgumentException("Illegal horizontal alignment value: " + align);
        }
        this.myMatrixHorizontalAlignment = align;
    }

    public int getMatrixVerticalAlignment() {
        return this.myMatrixVerticalAlignment;
    }

    public void setMatrixVerticalAlignment(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3) {
            throw new IllegalArgumentException("Illegal vertical alignment value: " + align);
        }
        this.myMatrixVerticalAlignment = align;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        int numComponents = target.getComponentCount();
        int numRows = (numComponents + this.myNumColumns - 1) / this.myNumColumns;
        int[] columnWidths = new int[this.myNumColumns];
        int i = 0;
        while (i < this.myNumColumns) {
            columnWidths[i] = 0;
            ++i;
        }
        int[] rowHeights = new int[numRows];
        int i2 = 0;
        while (i2 < numRows) {
            rowHeights[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < numComponents) {
            Component comp = target.getComponent(i2);
            if (comp.isVisible()) {
                int column = i2 % this.myNumColumns;
                int row = i2 / this.myNumColumns;
                Dimension compPrefSize = this.getComponentPrefSize(comp);
                columnWidths[column] = Math.max(columnWidths[column], compPrefSize.width);
                rowHeights[row] = Math.max(rowHeights[row], compPrefSize.height);
            }
            ++i2;
        }
        Dimension prefSize = new Dimension(0, 0);
        int i3 = 0;
        while (i3 < this.myNumColumns) {
            if (i3 > 0) {
                prefSize.width += this.myHgap;
            }
            prefSize.width += columnWidths[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < numRows) {
            if (i3 > 0) {
                prefSize.height += this.myVgap;
            }
            prefSize.height += rowHeights[i3];
            ++i3;
        }
        Insets insets = target.getInsets();
        prefSize.width += insets.left + insets.right + this.myHMargin * 2;
        prefSize.height += insets.top + insets.bottom + this.myVMargin * 2;
        return prefSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        int i;
        int i2;
        Insets insets = target.getInsets();
        Dimension size = target.getSize();
        int numComponents = target.getComponentCount();
        int numRows = (numComponents + this.myNumColumns - 1) / this.myNumColumns;
        int[] columnWidths = new int[this.myNumColumns];
        int i3 = 0;
        while (i3 < this.myNumColumns) {
            columnWidths[i3] = 0;
            ++i3;
        }
        int[] rowHeights = new int[numRows];
        int i4 = 0;
        while (i4 < numRows) {
            rowHeights[i4] = 0;
            ++i4;
        }
        i4 = 0;
        while (i4 < numComponents) {
            Component comp = target.getComponent(i4);
            if (comp.isVisible()) {
                int column = i4 % this.myNumColumns;
                int row = i4 / this.myNumColumns;
                Dimension compPrefSize = this.getComponentPrefSize(comp);
                columnWidths[column] = Math.max(columnWidths[column], compPrefSize.width);
                rowHeights[row] = Math.max(rowHeights[row], compPrefSize.height);
            }
            ++i4;
        }
        int totalWidth = insets.left + insets.right + 2 * this.myHMargin + this.total(columnWidths) + (this.myNumColumns - 1) * this.myHgap;
        int totalHeight = insets.top + insets.bottom + 2 * this.myVMargin + this.total(rowHeights) + (numRows - 1) * this.myVgap;
        if (this.myMatrixHorizontalAlignment == 3 && totalWidth < size.width) {
            int extraWidth = size.width - totalWidth;
            i2 = 0;
            while (i2 < this.myNumColumns) {
                int extra = (i2 + 1) * extraWidth / this.myNumColumns - i2 * extraWidth / this.myNumColumns;
                int n = i2++;
                columnWidths[n] = columnWidths[n] + extra;
            }
            totalWidth = size.width;
        }
        if (this.myMatrixVerticalAlignment == 3 && totalHeight < size.height) {
            int extraHeight = size.height - totalHeight;
            i2 = 0;
            while (i2 < numRows) {
                int extra = (i2 + 1) * extraHeight / numRows - i2 * extraHeight / numRows;
                int n = i2++;
                rowHeights[n] = rowHeights[n] + extra;
            }
            totalHeight = size.height;
        }
        boolean layoutFromLeft = target.getComponentOrientation().isLeftToRight();
        int[] columnStarts = new int[this.myNumColumns];
        int columnX = 0;
        if (layoutFromLeft) {
            columnX = insets.left + this.myHMargin;
            switch (this.myMatrixHorizontalAlignment) {
                case 0: 
                case 3: 
                case 4: {
                    break;
                }
                case 1: 
                case 5: {
                    if (totalWidth >= size.width) break;
                    columnX += size.width - totalWidth;
                    break;
                }
                case 2: {
                    if (totalWidth >= size.width) break;
                    columnX += (size.width - totalWidth) / 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid myMatrixHorizontalAlignment value");
                }
            }
            i = 0;
            while (i < this.myNumColumns) {
                columnStarts[i] = columnX;
                columnX += columnWidths[i] + this.myHgap;
                ++i;
            }
        } else {
            columnX = size.width - insets.right - this.myHMargin;
            switch (this.myMatrixHorizontalAlignment) {
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 0: 
                case 5: {
                    if (totalWidth >= size.width) break;
                    columnX -= size.width - totalWidth;
                    break;
                }
                case 2: {
                    if (totalWidth >= size.width) break;
                    columnX -= (size.width - totalWidth) / 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid myMatrixHorizontalAlignment value");
                }
            }
            i = 0;
            while (i < this.myNumColumns) {
                columnStarts[i] = columnX - columnWidths[i];
                columnX -= columnWidths[i] + this.myHgap;
                ++i;
            }
        }
        int[] rowStarts = new int[numRows];
        int rowY = insets.top + this.myVMargin;
        switch (this.myMatrixVerticalAlignment) {
            case 0: 
            case 3: {
                break;
            }
            case 1: {
                if (totalHeight >= size.height) break;
                rowY += size.height - totalHeight;
                break;
            }
            case 2: {
                if (totalHeight >= size.height) break;
                rowY += (size.height - totalHeight) / 2;
                break;
            }
            default: {
                throw new RuntimeException("Invalid myMatrixVerticalAlignment value");
            }
        }
        int i5 = 0;
        while (i5 < numRows) {
            rowStarts[i5] = rowY;
            rowY += rowHeights[i5] + this.myVgap;
            ++i5;
        }
        i5 = 0;
        while (i5 < numComponents) {
            block47: {
                int y;
                int x;
                int row;
                int newHeight;
                int newWidth;
                Dimension compPrefSize;
                Component comp;
                block49: {
                    int column;
                    block48: {
                        comp = target.getComponent(i5);
                        if (!comp.isVisible()) break block47;
                        compPrefSize = this.getComponentPrefSize(comp);
                        newWidth = compPrefSize.width;
                        newHeight = compPrefSize.height;
                        column = i5 % this.myNumColumns;
                        row = i5 / this.myNumColumns;
                        x = columnStarts[column];
                        y = rowStarts[row];
                        if (!layoutFromLeft) break block48;
                        switch (this.myComponentHorizontalAlignment) {
                            case 0: 
                            case 4: {
                                break block49;
                            }
                            case 1: 
                            case 5: {
                                x += columnWidths[column] - compPrefSize.width;
                                break block49;
                            }
                            case 2: {
                                x += (columnWidths[column] - compPrefSize.width) / 2;
                                break block49;
                            }
                            case 3: {
                                newWidth = columnWidths[column];
                                break block49;
                            }
                            default: {
                                throw new RuntimeException("Invalid myComponentHorizontalAlignment value");
                            }
                        }
                    }
                    switch (this.myComponentHorizontalAlignment) {
                        case 0: 
                        case 5: {
                            break;
                        }
                        case 1: 
                        case 4: {
                            x += columnWidths[column] - compPrefSize.width;
                            break;
                        }
                        case 2: {
                            x += (columnWidths[column] - compPrefSize.width) / 2;
                            break;
                        }
                        case 3: {
                            newWidth = columnWidths[column];
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid myComponentHorizontalAlignment value");
                        }
                    }
                }
                switch (this.myComponentVerticalAlignment) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        y += rowHeights[row] - compPrefSize.height;
                        break;
                    }
                    case 2: {
                        y += (rowHeights[row] - compPrefSize.height) / 2;
                        break;
                    }
                    case 3: {
                        newHeight = rowHeights[row];
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid myComponentVerticalAlignment value");
                    }
                }
                comp.setLocation(x, y);
                comp.setSize(new Dimension(newWidth, newHeight));
            }
            ++i5;
        }
    }

    public String toString() {
        String str = "";
        switch (this.myComponentHorizontalAlignment) {
            case 0: {
                str = String.valueOf(str) + ", cmpHori=left";
                break;
            }
            case 1: {
                str = String.valueOf(str) + ", cmpHori=right";
                break;
            }
            case 2: {
                str = String.valueOf(str) + ", cmpHori=center";
                break;
            }
            case 3: {
                str = String.valueOf(str) + ", cmpHori=stretch";
                break;
            }
            case 4: {
                str = String.valueOf(str) + ", cmpHori=leading";
                break;
            }
            case 5: {
                str = String.valueOf(str) + ", cmpHori=trailing";
                break;
            }
            default: {
                str = String.valueOf(str) + ", cmpHori=INVALID(" + this.myComponentHorizontalAlignment + ")";
            }
        }
        switch (this.myComponentVerticalAlignment) {
            case 0: {
                str = String.valueOf(str) + ", cmpVert=top";
                break;
            }
            case 1: {
                str = String.valueOf(str) + ", cmpVert=bottom";
                break;
            }
            case 2: {
                str = String.valueOf(str) + ", cmpVert=center";
                break;
            }
            case 3: {
                str = String.valueOf(str) + ", cmpVert=stretch";
                break;
            }
            default: {
                str = String.valueOf(str) + ", cmpVert=INVALID(" + this.myComponentVerticalAlignment + ")";
            }
        }
        switch (this.myMatrixHorizontalAlignment) {
            case 0: {
                str = String.valueOf(str) + ", mtxHori=left";
                break;
            }
            case 1: {
                str = String.valueOf(str) + ", mtxHori=right";
                break;
            }
            case 2: {
                str = String.valueOf(str) + ", mtxHori=center";
                break;
            }
            case 3: {
                str = String.valueOf(str) + ", mtxHori=stretch";
                break;
            }
            case 4: {
                str = String.valueOf(str) + ", mtxHori=leading";
                break;
            }
            case 5: {
                str = String.valueOf(str) + ", mtxHori=trailing";
                break;
            }
            default: {
                str = String.valueOf(str) + ", mtxHori=INVALID(" + this.myMatrixHorizontalAlignment + ")";
            }
        }
        switch (this.myMatrixVerticalAlignment) {
            case 0: {
                str = String.valueOf(str) + ", mtxVert=top";
                break;
            }
            case 1: {
                str = String.valueOf(str) + ", mtxVert=bottom";
                break;
            }
            case 2: {
                str = String.valueOf(str) + ", mtxVert=center";
                break;
            }
            case 3: {
                str = String.valueOf(str) + ", mtxVert=stretch";
                break;
            }
            default: {
                str = String.valueOf(str) + ", mtxVert=INVALID(" + this.myMatrixVerticalAlignment + ")";
            }
        }
        str = String.valueOf(this.getClass().getName()) + " [ columns=" + this.myNumColumns + ", hgap=" + this.myHgap + ", vgap=" + this.myVgap + ", hMargin=" + this.myHMargin + ", vMargin=" + this.myVMargin + str + " ]";
        return str;
    }

    private Dimension getComponentPrefSize(Component comp) {
        Dimension compPrefSize = comp.getPreferredSize();
        if (compPrefSize.height == 0 && compPrefSize.width == 0) {
            compPrefSize = comp.getMinimumSize();
        }
        return compPrefSize;
    }

    private int total(int[] array) {
        int total = 0;
        int i = 0;
        while (i < array.length) {
            total += array[i];
            ++i;
        }
        return total;
    }
}

