/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PVerticalLayout
implements LayoutManager {
    public static final int NO_SPACING = 0;
    public static final int SMALL_SPACING = 6;
    public static final int NORMAL_SPACING = 12;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int STRETCH = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    private static final int DEFAULT_VGAP = 12;
    private static final int DEFAULT_HMARGIN = 12;
    private static final int DEFAULT_VMARGIN = 12;
    private int myAlign;
    private int myVgap;
    private int myHMargin;
    private int myVMargin;

    public PVerticalLayout() {
        this(2, 12, 12, 12);
    }

    public PVerticalLayout(int align) {
        this(align, 12, 12, 12);
    }

    public PVerticalLayout(int align, int vGap, int hMargin, int vMargin) {
        if (align != 0 && align != 1 && align != 2 && align != 3 && align != 4 && align != 5) {
            throw new IllegalArgumentException("Illegal alignment value: " + align);
        }
        this.myAlign = align;
        this.myVgap = vGap;
        this.myHMargin = hMargin;
        this.myVMargin = vMargin;
    }

    public int getHorizontalAlignment() {
        return this.myAlign;
    }

    public void setHorizontalAlignment(int align) {
        if (align != 0 && align != 1 && align != 2 && align != 3 && align != 4 && align != 5) {
            throw new IllegalArgumentException("Illegal alignment value: " + align);
        }
        this.myAlign = align;
    }

    public int getVgap() {
        return this.myVgap;
    }

    public void setVgap(int vGap) {
        this.myVgap = vGap;
    }

    public int getHMargin() {
        return this.myHMargin;
    }

    public void setHMargin(int hMargin) {
        this.myHMargin = hMargin;
    }

    public int getVMargin() {
        return this.myVMargin;
    }

    public void setVMargin(int vMargin) {
        this.myVMargin = vMargin;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension prefSize = new Dimension(0, 0);
        int numComponents = target.getComponentCount();
        boolean firstVisible = true;
        int i = 0;
        while (i < numComponents) {
            Component comp = target.getComponent(i);
            if (comp.isVisible()) {
                Dimension compPrefSize = comp.getPreferredSize();
                prefSize.width = Math.max(prefSize.width, compPrefSize.width);
                if (firstVisible) {
                    firstVisible = false;
                } else {
                    prefSize.height += this.myVgap;
                }
                prefSize.height += compPrefSize.height;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        prefSize.width += insets.left + insets.right + this.myHMargin * 2;
        prefSize.height += insets.top + insets.bottom + this.myVMargin * 2;
        return prefSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        int numComponents = target.getComponentCount();
        Insets insets = target.getInsets();
        Dimension size = target.getSize();
        int totalWidth = size.width - (insets.left + insets.right + 2 * this.myHMargin);
        int y = insets.top + this.myVMargin;
        int align = this.myAlign;
        switch (this.myAlign) {
            case 4: {
                if (target.getComponentOrientation().isLeftToRight()) {
                    align = 0;
                    break;
                }
                align = 1;
                break;
            }
            case 5: {
                if (target.getComponentOrientation().isLeftToRight()) {
                    align = 1;
                    break;
                }
                align = 0;
                break;
            }
        }
        int i = 0;
        while (i < numComponents) {
            Component comp = target.getComponent(i);
            if (comp.isVisible()) {
                Dimension compPrefSize = comp.getPreferredSize();
                int newWidth = compPrefSize.width;
                int x = insets.left + this.myHMargin;
                switch (align) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        x += totalWidth - compPrefSize.width;
                        break;
                    }
                    case 2: {
                        x += (totalWidth - compPrefSize.width) / 2;
                        break;
                    }
                    case 3: {
                        newWidth = totalWidth;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid myAlign value");
                    }
                }
                comp.setLocation(x, y);
                comp.setSize(new Dimension(newWidth, compPrefSize.height));
                y += compPrefSize.height + this.myVgap;
            }
            ++i;
        }
    }

    public String toString() {
        String str = "";
        switch (this.myAlign) {
            case 0: {
                str = ", align=left";
                break;
            }
            case 1: {
                str = ", align=right";
                break;
            }
            case 2: {
                str = ", align=center";
                break;
            }
            case 3: {
                str = ", align=stretch";
                break;
            }
            case 4: {
                str = ", align=leading";
                break;
            }
            case 5: {
                str = ", align=trailing";
                break;
            }
            default: {
                str = String.valueOf(str) + ", align=INVALID(" + this.myAlign + ")";
            }
        }
        str = String.valueOf(this.getClass().getName()) + " [ vgap=" + this.myVgap + ", hMargin=" + this.myHMargin + ", vMargin=" + this.myVMargin + str + " ]";
        return str;
    }
}

