/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class RowAlignLayout
implements LayoutManager2 {
    private static final int DEFAULT_MARGIN_HORIZONTAL = 17;
    private static final int DEFAULT_MARGIN_VERTICAL = SystemUtils.isCondensedTheme() ? 11 : 18;
    private static final int DEFAULT_GAP = 5;
    private static final Dimension MAX_DIMENSION = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final String AREA_LEFT = "West";
    public static final String AREA_CENTER = "Center";
    public static final String AREA_RIGHT = "East";
    private int myGap;
    private int myHmargin;
    private int myVmargin;
    private Map myItems = new HashMap();
    private Dimension myMinCompSize;
    private Dimension myMaxCompSize;
    private boolean myCompSizeScaled;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int myAlignment = 0;
    private Component myHelpButton;
    private boolean myIsButtonBar = true;

    public RowAlignLayout(int gap, int hmargin, int vmargin, Dimension minCompSize, Dimension maxCompSize) {
        this(gap, hmargin, vmargin, minCompSize, maxCompSize, false);
    }

    public RowAlignLayout(int gap, int hmargin, int vmargin, Dimension minCompSize, Dimension maxCompSize, boolean scale) {
        this.myGap = gap;
        this.myHmargin = hmargin;
        this.myVmargin = vmargin;
        this.myMinCompSize = minCompSize;
        this.myMaxCompSize = maxCompSize;
        this.setComponentScaled(scale);
    }

    public RowAlignLayout(int gap, int hmargin, int vmargin) {
        this(gap, hmargin, vmargin, null, null, true);
    }

    public RowAlignLayout() {
        this(5, 17, DEFAULT_MARGIN_VERTICAL);
    }

    public RowAlignLayout(Dimension minCompSize, Dimension maxCompSize) {
        this(5, 17, DEFAULT_MARGIN_VERTICAL, minCompSize, maxCompSize, true);
    }

    public RowAlignLayout(Dimension minCompSize, Dimension maxCompSize, boolean scale) {
        this(5, 17, DEFAULT_MARGIN_VERTICAL, minCompSize, maxCompSize, scale);
    }

    public void setButtonBar(boolean isButtonBar) {
        this.myIsButtonBar = isButtonBar;
    }

    public void setAlgnment(int alignment) {
        this.myAlignment = alignment;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        String name = AREA_RIGHT;
        if (comp instanceof JComponent && ClientPropertyUtil.booleanValue((JComponent)comp, "help")) {
            name = AREA_LEFT;
            this.myHelpButton = comp;
        }
        if (constraint != null) {
            name = constraint.toString();
        }
        List<Component> items = this.getItemList(name);
        items.add(comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (List items : this.myItems.values()) {
            if (items.remove(comp)) break;
        }
        if (comp instanceof JComponent && ClientPropertyUtil.booleanValue((JComponent)comp, "help")) {
            this.myHelpButton = null;
        }
    }

    private List<Component> getItemList(Object constraint) {
        ArrayList<Component> items = null;
        if (!this.myItems.containsKey(constraint)) {
            items = new ArrayList();
            this.myItems.put(constraint, items);
        } else {
            items = (List)this.myItems.get(constraint);
        }
        return items;
    }

    private int getMaxHeight(Container target) {
        Component[] comps = target.getComponents();
        int result = 0;
        int idx = 0;
        while (idx < comps.length) {
            if (comps[idx] != this.myHelpButton) {
                result = Math.max(result, comps[idx].getPreferredSize().height);
            }
            ++idx;
        }
        return result;
    }

    @Override
    public void layoutContainer(Container target) {
        List centerItems;
        List rightItems;
        Insets insets = target.getInsets();
        int top = insets.top + this.myVmargin;
        int left = insets.left + this.myHmargin;
        int right = target.getWidth() - insets.right - this.myHmargin;
        int maxHeight = this.getMaxHeight(target);
        List leftItems = (List)this.myItems.get(AREA_LEFT);
        int leftWidth = 0;
        if (leftItems != null) {
            int x = left;
            this.initScaledSize(leftItems);
            if (this.myHelpButton != null) {
                this.myHelpButton.setSize(this.myHelpButton.getPreferredSize());
                int y = top;
                if (this.myAlignment == 0) {
                    y += (maxHeight - this.myHelpButton.getHeight()) / 2;
                }
                this.myHelpButton.setLocation(x, y);
                x += this.myHelpButton.getWidth() + this.myGap;
            }
            for (Component item : leftItems) {
                if (item == this.myHelpButton) continue;
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                int y = top;
                if (this.myAlignment == 0) {
                    y += (maxHeight - itemDim.height) / 2;
                }
                item.setBounds(x, y, itemDim.width, itemDim.height);
                x += itemDim.width + this.myGap;
                leftWidth += itemDim.width + this.myGap;
            }
        }
        if ((rightItems = (List)this.myItems.get(AREA_RIGHT)) != null) {
            int x = right;
            this.initScaledSize(rightItems);
            int i = rightItems.size() - 1;
            while (i >= 0) {
                Component item = (Component)rightItems.get(i);
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                int y = top;
                if (this.myAlignment == 0) {
                    y += (maxHeight - itemDim.height) / 2;
                }
                item.setBounds(x -= itemDim.width, y, itemDim.width, itemDim.height);
                if (item.isVisible()) {
                    x -= this.myGap;
                }
                --i;
            }
        }
        if ((centerItems = (List)this.myItems.get(AREA_CENTER)) != null) {
            int centerX = 0;
            this.initScaledSize(centerItems);
            Iterator iter = centerItems.iterator();
            while (iter.hasNext()) {
                Component item = (Component)iter.next();
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                centerX = (int)((double)centerX + itemDim.getWidth());
                if (!iter.hasNext()) continue;
                centerX += this.myGap;
            }
            int x = target.getWidth() / 2 - centerX / 2;
            if (x < leftWidth && leftItems != null) {
                x = leftWidth + this.myGap * (leftItems.size() + 1);
            }
            for (Component item : centerItems) {
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                int y = top;
                if (this.myAlignment == 0) {
                    y += (maxHeight - itemDim.height) / 2;
                }
                item.setBounds(x, y, itemDim.width, itemDim.height);
                x += itemDim.width + this.myGap;
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int widthadd = insets.left + insets.right + this.myHmargin * 2;
        int heightadd = insets.top + insets.bottom + this.myVmargin * 2 - (this.myIsButtonBar ? 3 : 0);
        int width = 0;
        int height = 0;
        int leftwidth = 0;
        int centerwidth = 0;
        int rightwidth = 0;
        List leftItems = (List)this.myItems.get(AREA_LEFT);
        if (leftItems != null) {
            this.initScaledSize(leftItems);
            Iterator iter = leftItems.iterator();
            while (iter.hasNext()) {
                Component item = (Component)iter.next();
                Dimension itemDim = item.getPreferredSize();
                if (item != this.myHelpButton) {
                    itemDim = this.limitSize(itemDim);
                }
                height = Math.max(height, itemDim.height);
                leftwidth += itemDim.width;
                if (!iter.hasNext()) continue;
                leftwidth += this.myGap;
            }
        }
        width += leftwidth;
        List rightItems = (List)this.myItems.get(AREA_RIGHT);
        if (rightItems != null) {
            this.initScaledSize(rightItems);
            Iterator iter = rightItems.iterator();
            while (iter.hasNext()) {
                Component item = (Component)iter.next();
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                height = Math.max(height, itemDim.height);
                rightwidth += itemDim.width;
                if (!iter.hasNext()) continue;
                rightwidth += this.myGap;
            }
        }
        width += rightwidth;
        List centerItems = (List)this.myItems.get(AREA_CENTER);
        if (centerItems != null) {
            this.initScaledSize(centerItems);
            Iterator iter = centerItems.iterator();
            while (iter.hasNext()) {
                Component item = (Component)iter.next();
                Dimension itemDim = this.limitSize(item.getPreferredSize());
                height = Math.max(height, itemDim.height);
                centerwidth += itemDim.width;
                if (!iter.hasNext()) continue;
                centerwidth += this.myGap;
            }
        }
        width += centerwidth;
        if (leftwidth > 0) {
            width += this.myGap;
        }
        if (rightwidth > 0) {
            width += this.myGap;
        }
        width += widthadd;
        if (height > 0) {
            height += heightadd;
        }
        return new Dimension(width, height);
    }

    private void initScaledSize(List<Component> items) {
        if (!this.myCompSizeScaled) {
            return;
        }
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        for (Component item : items) {
            if (item == this.myHelpButton) continue;
            Dimension itemDim = this.checkSize(item.getPreferredSize());
            this.preferredWidth = Math.max(itemDim.width, this.preferredWidth);
            this.preferredHeight = Math.max(itemDim.height, this.preferredHeight);
        }
    }

    private Dimension limitSize(Dimension dimToCheck) {
        if (this.myCompSizeScaled) {
            dimToCheck.width = this.preferredWidth;
            dimToCheck.height = this.preferredHeight;
        }
        return this.checkSize(dimToCheck);
    }

    private Dimension checkSize(Dimension dimToCheck) {
        if (this.myMaxCompSize != null) {
            dimToCheck.width = Math.min(dimToCheck.width, this.myMaxCompSize.width);
            dimToCheck.height = Math.min(dimToCheck.height, this.myMaxCompSize.height);
        }
        if (this.myMinCompSize != null) {
            dimToCheck.width = Math.max(dimToCheck.width, this.myMinCompSize.width);
            dimToCheck.height = Math.max(dimToCheck.height, this.myMinCompSize.height);
        }
        return dimToCheck;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return MAX_DIMENSION;
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public void setGap(int gap) {
        this.myGap = gap;
    }

    public int getGap() {
        return this.myGap;
    }

    public void setHMargin(int hmargin) {
        this.myHmargin = hmargin;
    }

    public int getHMargin() {
        return this.myHmargin;
    }

    public void setVMargin(int vmargin) {
        this.myVmargin = vmargin;
    }

    public int getVMargin() {
        return this.myVmargin;
    }

    public void setComponentScaled(boolean scale) {
        this.myCompSizeScaled = scale;
    }

    public boolean isComponentScaled() {
        return this.myCompSizeScaled;
    }
}

