/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.layout;

import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.layout.LayoutManagerAdapter;
import com.nokia.widgets.layout.LayoutUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class WizardButtonBarLayout
extends LayoutManagerAdapter {
    public static final Object BACK_BUTTON = "BackButton";
    public static final Object NEXT_BUTTON = "NextButton";
    public static final Object FINISH_BUTTON = "FinishButton";
    public static final Object CANCEL_BUTTON = "CancelButton";
    public static final Object HELP_BUTTON = "HelpButton";
    public static final int MARGIN = 9;
    public static final int HORIZONTAL_MARGIN = SystemUtils.isCondensedTheme() ? 12 : 20;
    public static final int RIGHT_MARGIN = 28;
    public static final int LEFT_MARGIN = 26;
    private Component myHelpButton;
    private Component myBackButton;
    private Component myNextButton;
    private Component myFinishButton;
    private Component myCancelButton;

    @Override
    public void layoutContainer(Container parent) {
        Component[] comps = parent.getComponents();
        Insets insets = parent.getInsets();
        int height = parent.getHeight();
        int width = parent.getWidth();
        Dimension maxDim = LayoutUtils.getMaximumPreferredSize(comps);
        int functionButtonX = 26;
        if (this.myHelpButton != null) {
            functionButtonX += this.myHelpButton.getPreferredSize().width + 9;
        }
        int idx = 0;
        while (idx < comps.length) {
            Component comp = comps[idx];
            if (comp == this.myHelpButton) {
                comp.setSize(comp.getPreferredSize());
            } else {
                comp.setSize(maxDim);
            }
            int compY = (height - comp.getHeight()) / 2;
            int compX = insets.left;
            int cancelButtonX = width - insets.right - 28 - comp.getWidth();
            if (comp == this.myHelpButton) {
                compX += 9;
            } else if (comp == this.myBackButton) {
                compX = cancelButtonX - this.getNextCloseGap(maxDim.width) - 2 * comp.getWidth() - 9;
            } else if (comp == this.myNextButton) {
                compX = cancelButtonX - this.getNextCloseGap(maxDim.width) - comp.getWidth();
            } else if (comp == this.myFinishButton) {
                compX = cancelButtonX - 9 - comp.getWidth();
            } else if (comp == this.myCancelButton) {
                compX = cancelButtonX;
            } else {
                compX = functionButtonX;
                functionButtonX += comp.getWidth() + 9;
            }
            comp.setLocation(compX, compY);
            ++idx;
        }
    }

    private int getNextCloseGap(int buttonWidth) {
        return 18 + buttonWidth + 9;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] comps = parent.getComponents();
        Dimension maxDim = LayoutUtils.getMaximumPreferredSize(comps);
        Insets insets = parent.getInsets();
        int prefHeight = maxDim.height;
        if (this.myHelpButton != null) {
            prefHeight = Math.max(maxDim.height, this.myHelpButton.getPreferredSize().height);
        }
        prefHeight += 2 * HORIZONTAL_MARGIN + insets.top + insets.bottom;
        int prefWidth = 3 * maxDim.width + this.getNextCloseGap(maxDim.width) + 9 + 28 + insets.left + insets.right;
        if (this.myHelpButton != null) {
            prefWidth += this.myHelpButton.getPreferredSize().width;
        }
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this.myHelpButton) {
            this.myHelpButton = null;
        } else if (comp == this.myBackButton) {
            this.myBackButton = null;
        } else if (comp == this.myNextButton) {
            this.myNextButton = null;
        } else if (comp == this.myFinishButton) {
            this.myFinishButton = null;
        } else if (comp == this.myCancelButton) {
            this.myCancelButton = null;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (HELP_BUTTON.equals(constraints) || comp instanceof PHelpButton) {
            this.myHelpButton = comp;
        } else if (BACK_BUTTON.equals(constraints)) {
            this.myBackButton = comp;
        } else if (NEXT_BUTTON.equals(constraints)) {
            this.myNextButton = comp;
        } else if (FINISH_BUTTON.equals(constraints)) {
            this.myFinishButton = comp;
        } else if (CANCEL_BUTTON.equals(constraints)) {
            this.myCancelButton = comp;
        }
    }
}

