/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.list;

import com.nokia.widgets.list.FilteredListModel;
import com.nokia.widgets.list.ListFilter;
import java.util.regex.Pattern;

public class DefaultListFilter
implements ListFilter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Pattern NEWLINE_PATTERN = Pattern.compile("[\n'" + LINE_SEPARATOR + "']");
    private String myText;
    private boolean myIsExactMatch;
    private String myLowerCaseText;

    public DefaultListFilter(String text) {
        this.myText = text;
        this.myLowerCaseText = this.myText.toLowerCase();
    }

    public boolean isIsExactMatch() {
        return this.myIsExactMatch;
    }

    public void setIsExactMatch(boolean isExactMatch) {
        this.myIsExactMatch = isExactMatch;
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text) {
        this.myText = text;
        this.myLowerCaseText = this.myText.toLowerCase();
    }

    @Override
    public boolean isIncluded(int rowIndex, FilteredListModel listModel) {
        String stringVal = listModel.getStringValueAt(rowIndex);
        if (stringVal != null) {
            stringVal = this.removeLineSeparators(stringVal);
            return this.myIsExactMatch ? stringVal.toLowerCase().equals(this.myLowerCaseText) : stringVal.toLowerCase().contains(this.myLowerCaseText);
        }
        return true;
    }

    private String removeLineSeparators(String text) {
        return text == null ? text : NEWLINE_PATTERN.matcher(text).replaceAll(" ");
    }

    @Override
    public boolean isActive() {
        return this.myText != null;
    }
}

