/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.list;

import com.nokia.widgets.list.ListFilter;
import com.nokia.widgets.list.ListFilterEvent;
import com.nokia.widgets.list.ListFilterListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class FilteredListModel
extends AbstractListModel {
    private ListModel myModel;
    private ListFilter myFilter;
    private int myCachedRowCount;
    private Map<Integer, Integer> myOriginalRowIndexCache = new HashMap<Integer, Integer>();
    private List<ListFilterListener> myListeners = new ArrayList<ListFilterListener>();
    private ListFilterEvent myEvent = new ListFilterEvent(this);

    public FilteredListModel(ListModel model) {
        this.myModel = model;
    }

    @Override
    public int getSize() {
        if (this.myFilter == null || !this.myFilter.isActive()) {
            return this.myModel.getSize();
        }
        if (this.myCachedRowCount != -1) {
            return this.myCachedRowCount;
        }
        int result = this.myModel.getSize();
        int row = 0;
        while (row < this.myModel.getSize()) {
            if (!this.myFilter.isIncluded(row, this)) {
                --result;
            }
            ++row;
        }
        this.myCachedRowCount = result;
        return result;
    }

    public void addListFilterListener(ListFilterListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListFilterListener(ListFilterListener listener) {
        this.myListeners.remove(listener);
    }

    public ListFilter getFilter() {
        return this.myFilter;
    }

    public void setFilter(ListFilter filter) {
        this.myFilter = filter;
        this.clearCachedValues();
    }

    public ListModel getWrappedModel() {
        return this.myModel;
    }

    @Override
    public Object getElementAt(int index) {
        return this.myModel.getElementAt(this.getOriginalIndex(index));
    }

    public int getOriginalIndex(int row) {
        if (this.myFilter == null) {
            return row;
        }
        Integer cachedRowIndex = this.myOriginalRowIndexCache.get(row);
        if (cachedRowIndex != null) {
            return cachedRowIndex;
        }
        int includedRow = -1;
        int viewRow = 0;
        while (viewRow < this.myModel.getSize()) {
            if (this.myFilter.isIncluded(viewRow, this)) {
                ++includedRow;
            }
            if (includedRow == row) {
                this.myOriginalRowIndexCache.put(row, viewRow);
                return viewRow;
            }
            ++viewRow;
        }
        return -1;
    }

    public String getStringValueAt(int rowIndex) {
        Object element = this.myModel.getElementAt(rowIndex);
        return element == null ? "" : element.toString();
    }

    public void filter() {
        this.fireListWillBeFiltered();
        this.clearCachedValues();
        this.fireContentsChanged(this, 0, this.getSize());
        this.fireListFiltered();
    }

    protected void clearCachedValues() {
        this.myCachedRowCount = -1;
        this.myOriginalRowIndexCache.clear();
    }

    protected void fireListWillBeFiltered() {
        for (ListFilterListener listener : this.myListeners) {
            listener.listWillBeFiltered(this.myEvent);
        }
    }

    protected void fireListFiltered() {
        for (ListFilterListener listener : this.myListeners) {
            listener.listFiltered(this.myEvent);
        }
    }
}

