/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.list;

import com.nokia.widgets.list.DefaultListFilter;
import com.nokia.widgets.list.FilteredListModel;
import com.nokia.widgets.text.DocumentAdapter;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;

public class ListFilterTextField
extends PTextField {
    private JList myList;
    final DefaultListFilter myFilter;
    private int myAutoDelay = 0;
    private Timer myTimer = new Timer(this.myAutoDelay, this.createFilterAction());

    public ListFilterTextField(JList list) {
        this(list, 10);
    }

    public ListFilterTextField(JList list, int columns) {
        super(columns);
        this.myList = list;
        this.myFilter = new DefaultListFilter("");
        this.getFilteredModel().setFilter(this.myFilter);
        this.bindKeyboardAction();
    }

    @Override
    protected void init() {
        super.init();
        this.setSearchField(true);
        this.setLabel(WidgetResources.getString("Filter.filterPrompt"));
        this.addDocumentListener(new DocumentAdapter(){

            @Override
            public void onEvent(DocumentEvent e) {
                if (ListFilterTextField.this.getText() == null || ListFilterTextField.this.getText().length() == 0 || ListFilterTextField.this.myAutoDelay == 0) {
                    ListFilterTextField.this.createFilterAction().actionPerformed(new ActionEvent(this, 1, ""));
                } else if (ListFilterTextField.this.myTimer != null) {
                    ListFilterTextField.this.myTimer.restart();
                }
            }
        });
    }

    private void bindKeyboardAction() {
        this.getInputMap(0).put(KeyStroke.getKeyStroke("UP"), "previous");
        this.getActionMap().put("previous", new ChangeSelectionAction(-1));
        this.getInputMap(0).put(KeyStroke.getKeyStroke("DOWN"), "next");
        this.getActionMap().put("next", new ChangeSelectionAction(1));
    }

    private FilteredListModel getFilteredModel() {
        return this.myList.getModel() instanceof FilteredListModel ? (FilteredListModel)this.myList.getModel() : null;
    }

    public void setAutoDelay(int delay) {
        this.myAutoDelay = delay;
        if (delay < 0) {
            this.myTimer.stop();
            this.myTimer = null;
        } else if (this.myTimer == null) {
            this.myTimer = new Timer(delay, this.createFilterAction());
            this.myTimer.setRepeats(false);
        } else {
            this.myTimer.setDelay(delay);
        }
    }

    protected Action createFilterAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListFilterTextField.this.myFilter.setText(ListFilterTextField.this.getText());
                ListFilterTextField.this.getFilteredModel().filter();
            }
        };
    }

    private final class ChangeSelectionAction
    extends AbstractAction {
        private int myChange = 1;

        public ChangeSelectionAction(int change) {
            this.myChange = change;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ListFilterTextField.this.myList.isSelectionEmpty() || ListFilterTextField.this.myList.getSelectedIndex() >= ListFilterTextField.this.myList.getModel().getSize()) {
                ListFilterTextField.this.myList.setSelectedIndex(0);
                return;
            }
            int newIndex = ListFilterTextField.this.myList.getSelectedIndex() + this.myChange;
            ListFilterTextField.this.myList.setSelectedIndex(newIndex);
            Rectangle cellBounds = ListFilterTextField.this.myList.getCellBounds(newIndex, newIndex);
            if (cellBounds != null) {
                ListFilterTextField.this.myList.scrollRectToVisible(cellBounds);
            }
        }
    }
}

