/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.list;

import com.nokia.widgets.IconBorder;
import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.icons.MandatoryStripeIcon;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.util.WidgetResources;
import com.nokia.widgets.validation.ValidationResult;
import com.nokia.widgets.validation.Validator;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class StatusListCellRenderer
extends DefaultListCellRenderer {
    public static final Icon MANDATORY_STRIPE_ICON = new CompoundIcon(18, 16, MandatoryStripeIcon.ICON_8);
    public static final Icon WARNING_ICON = new CompoundIcon(18, 16, WidgetResources.getImageIcon("Warning.Icon"), 4);
    protected IconBorder myIconBorder = new IconBorder(1, 1, 0, 11, 4);
    public static final Border FOCUSED_BORDER = new CompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(0, 17, 0, 6));

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        ValidationResult result = this.validate(list, value, index);
        Icon icon = this.getIcon(result);
        this.myIconBorder.setIcon(isSelected ? PEmptyIcon.ICON_18 : icon);
        this.setBorder(cellHasFocus ? FOCUSED_BORDER : this.myIconBorder);
        return this;
    }

    protected Icon getIcon(ValidationResult result) {
        Icon icon = PEmptyIcon.ICON_18;
        if (result.hasErrors()) {
            icon = WARNING_ICON;
        } else if (result.hasMissingValues()) {
            icon = MANDATORY_STRIPE_ICON;
        }
        return icon;
    }

    protected ValidationResult validate(JList list, Object value, int index) {
        Validator validator = null;
        validator = list.getModel() instanceof Validator ? (Validator)((Object)list.getModel()) : (Validator)list.getClientProperty("OrangeTouch.validator");
        if (validator != null) {
            return validator.validate(value);
        }
        return null;
    }

    public static class UIResource
    extends StatusListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

