/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.navigation;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.navigation.NavigationButtonUI;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class AnimatedScrollPanel
extends JPanel {
    private static final Insets SCROLL_BUTTON_MARGIN = new Insets(0, 3, 0, 3);
    private static final int TIMER_DELAY = 30;
    private static final float MIN_SPEED = 2.0f;
    private static final float MAX_SPEED = 24.0f;
    private static final float SPEED_CHANGE = 0.8f;
    private static final int SCROLL_BUTTON_SPACE = 1;
    private static final float BUFFER_ZONE_PIXELS = 8.0f;
    private static final int SCROLL_UP = 0;
    private static final int SCROLL_DOWN = 1;
    protected PPanel myComponentPanel;
    protected float mySpeed = 2.0f;
    private transient ActionListener myAnimateScrollDownListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimatedScrollPanel.this.animateScrollDown();
        }
    };
    private transient ActionListener myAnimateScrollUpListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimatedScrollPanel.this.animateScrollUp();
        }
    };
    private Icon myScrollDownIcon;
    private Icon myScrollUpIcon;
    private AbstractButton myScrollDownButton;
    private AbstractButton myScrollUpButton;
    private JViewport myComponentPanelViewPort = new JViewport();
    private List myComponentList;
    private transient MouseListener myMouseOverListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            AnimatedScrollPanel.this.mouseEntered(e.getComponent());
        }
    };
    private Timer myScrollAnimationTimer = null;
    private boolean myEnableAnimation = true;
    private int myTopSpace = 6;
    private int myBottomSpace = 6;
    private int myInterComponentSpace = 6;
    private int myCurrentScrollComponentIndex;
    private int myScrollDirection;
    private int myTargetScrollPosition = 0;

    public AnimatedScrollPanel() {
        this((List)null);
    }

    public AnimatedScrollPanel(List componentList) {
        this.setLayout(new GridBagLayout());
        this.myScrollUpIcon = WidgetResources.getImageIcon("PAnimatedScrollPanel.UpEnabledIcon");
        this.myScrollUpButton = this.createScrollUpButton();
        this.myScrollDownIcon = WidgetResources.getImageIcon("PAnimatedScrollPanel.DownEnabledIcon");
        this.myScrollDownButton = this.createScrollDownButton();
        this.myComponentPanel = new PPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D graphics = (Graphics2D)g;
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color oldColor = graphics.getColor();
                if (AnimatedScrollPanel.this.myComponentList.size() != 0) {
                    RectangularShape roundRect = NetUtils.getOutline(this);
                    graphics.setColor(new Color(0, 0, 0, 0));
                    graphics.fill(roundRect);
                    RectangularShape insideRect = NavigationButtonUI.getRoundRect(this.getWidth() - 4, this.getHeight() + 1);
                    int x = insideRect.getBounds().x;
                    int w = insideRect.getBounds().width;
                    int y = roundRect.getBounds().y;
                    int h = roundRect.getBounds().height;
                    RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x + 5, y + 6, x + w - 13, h - 15, 14.0, 14.0);
                    graphics.setPaint(new GradientPaint(x + w / 2, y, UIManager.getColor("NavigationPanel.color"), x + w / 2, y + h, Color.white));
                    graphics.fill(rect);
                    graphics.setColor(Color.white);
                    graphics.setStroke(new BasicStroke(1.0f));
                    graphics.draw(rect);
                }
                graphics.setColor(oldColor);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        this.myComponentPanel.setLayout(new GridBagLayout());
        this.myComponentPanel.setOpaque(false);
        this.myComponentPanel.setCurvedSheet(true);
        this.myComponentPanel.setPaintSheetOutline(false);
        this.setOpaque(false);
        this.myComponentPanelViewPort.setView(this.myComponentPanel);
        this.myComponentPanelViewPort.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets.left = 2;
        gbc.insets.right = 2;
        gbc.fill = 2;
        gbc.insets.top = 1;
        this.add((Component)this.myScrollUpButton, gbc);
        gbc.gridy = 2;
        gbc.insets.top = 0;
        gbc.insets.bottom = 1;
        this.add((Component)this.myScrollDownButton, gbc);
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.insets.bottom = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.myComponentPanelViewPort, gbc);
        if (componentList != null) {
            this.loadComponents(componentList);
        }
        this.setupListeners();
    }

    public void setBottomSpace(int bottomSpace) {
        this.myBottomSpace = bottomSpace;
    }

    public int getBottomSpace() {
        return this.myBottomSpace;
    }

    public void setComponentList(List componentList) {
        if (this.myScrollAnimationTimer != null) {
            this.myScrollAnimationTimer.stop();
            this.myScrollAnimationTimer = null;
            this.mySpeed = 2.0f;
        }
        this.myComponentPanel.removeAll();
        if (this.myComponentList != null) {
            int componentCounter = 0;
            while (componentCounter < this.myComponentList.size()) {
                Component currentComponent = (Component)this.myComponentList.get(componentCounter);
                currentComponent.removeMouseListener(this.myMouseOverListener);
                ++componentCounter;
            }
        }
        this.loadComponents(componentList);
        this.scheduleRefreshGUI();
    }

    public void setEnableAnimation(boolean enableAnimation) {
        this.myEnableAnimation = enableAnimation;
    }

    public void setInterComponentSpace(int interComponentSpace) {
        this.myInterComponentSpace = interComponentSpace;
    }

    public int getInterComponentSpace() {
        return this.myInterComponentSpace;
    }

    public void setTopSpace(int topSpace) {
        this.myTopSpace = topSpace;
    }

    public int getTopSpace() {
        return this.myTopSpace;
    }

    public void setWidth(int width) {
        this.myComponentPanel.setSize(width, this.myComponentPanel.getHeight());
    }

    public void mouseEntered(Component component) {
        if (this.myScrollAnimationTimer != null) {
            return;
        }
        int componentTopY = component.getY();
        int componentBottomY = componentTopY + component.getHeight();
        int viewTopY = this.myComponentPanelViewPort.getViewPosition().y;
        int viewBottomY = viewTopY + this.myComponentPanelViewPort.getExtentSize().height;
        this.myCurrentScrollComponentIndex = this.myComponentList.indexOf(component);
        if (this.myCurrentScrollComponentIndex == 0) {
            if (viewTopY > 0) {
                this.myScrollDirection = 0;
                this.scrollUp(0);
            }
        } else if (this.myCurrentScrollComponentIndex == this.myComponentList.size() - 1) {
            int lowestViewPosition = this.myComponentPanel.getHeight() - this.myComponentPanelViewPort.getExtentSize().height;
            if (viewTopY < lowestViewPosition) {
                this.myScrollDirection = 1;
                this.scrollDown(lowestViewPosition);
            }
        } else if (componentTopY - this.myInterComponentSpace < viewTopY) {
            this.myScrollDirection = 0;
            this.scrollUp(componentTopY - this.myInterComponentSpace);
        } else if (componentBottomY + this.myInterComponentSpace > viewBottomY) {
            this.myScrollDirection = 1;
            this.scrollDown(componentBottomY + this.myInterComponentSpace - this.myComponentPanelViewPort.getExtentSize().height);
        }
    }

    public void refreshGUI() {
        int componentPanelHeight;
        int myHeight = this.getHeight();
        if (myHeight >= (componentPanelHeight = this.myComponentPanel.getHeight())) {
            this.myScrollUpButton.setVisible(false);
            this.myScrollDownButton.setVisible(false);
            return;
        }
        this.myScrollUpButton.setVisible(true);
        this.myScrollDownButton.setVisible(true);
        this.scheduleRefreshScrollButtons();
    }

    protected void scheduleRefreshScrollButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnimatedScrollPanel.this.refreshScrollButtons();
            }
        });
    }

    protected void animateScrollDown() {
        int currentPosition = this.myComponentPanelViewPort.getViewPosition().y;
        if (currentPosition < this.myTargetScrollPosition) {
            int newPosition = currentPosition + (int)this.mySpeed;
            if (newPosition > this.myTargetScrollPosition) {
                newPosition = this.myTargetScrollPosition;
            } else if (newPosition <= this.myTargetScrollPosition - 8) {
                this.mySpeed += 0.8f;
                this.mySpeed = Math.min(this.mySpeed, 24.0f);
            } else {
                this.mySpeed -= 0.8f;
                this.mySpeed = Math.max(this.mySpeed, 2.0f);
            }
            this.myComponentPanelViewPort.setViewPosition(new Point(0, newPosition));
        } else {
            this.myScrollAnimationTimer.stop();
            this.mySpeed = 2.0f;
            this.myScrollAnimationTimer = null;
            this.myTargetScrollPosition = 0;
            this.refreshScrollButtons();
        }
    }

    protected void setupListeners() {
        this.myScrollUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimatedScrollPanel.this.scrollUp();
            }
        });
        this.myScrollDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimatedScrollPanel.this.scrollDown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AnimatedScrollPanel.this.refreshGUI();
            }
        });
    }

    protected void scheduleRefreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnimatedScrollPanel.this.refreshGUI();
            }
        });
    }

    protected void animateScrollUp() {
        int currentPosition = this.myComponentPanelViewPort.getViewPosition().y;
        if (currentPosition > this.myTargetScrollPosition) {
            int newPosition = currentPosition - (int)this.mySpeed;
            if (newPosition < this.myTargetScrollPosition) {
                newPosition = this.myTargetScrollPosition;
            } else if (newPosition >= this.myTargetScrollPosition + 8) {
                this.mySpeed += 0.8f;
                this.mySpeed = Math.min(this.mySpeed, 24.0f);
            } else {
                this.mySpeed -= 0.8f;
                this.mySpeed = Math.max(this.mySpeed, 2.0f);
            }
            this.myComponentPanelViewPort.setViewPosition(new Point(0, newPosition));
        } else {
            this.myScrollAnimationTimer.stop();
            this.mySpeed = 2.0f;
            this.myScrollAnimationTimer = null;
            this.myTargetScrollPosition = 0;
            this.refreshScrollButtons();
        }
    }

    protected void scrollDown(int targetScrollPosition) {
        if (!this.myEnableAnimation) {
            this.myComponentPanelViewPort.setViewPosition(new Point(0, targetScrollPosition));
        } else {
            if (this.myScrollAnimationTimer != null) {
                this.myScrollAnimationTimer.stop();
                this.mySpeed = 2.0f;
                this.myScrollAnimationTimer = null;
            }
            this.myScrollAnimationTimer = new Timer(30, this.myAnimateScrollDownListener);
            this.myScrollAnimationTimer.setCoalesce(false);
            this.myTargetScrollPosition = targetScrollPosition;
            this.myScrollAnimationTimer.start();
        }
    }

    protected void scrollDown() {
        if (this.myScrollAnimationTimer != null) {
            if (this.myScrollDirection == 1) {
                if (this.myCurrentScrollComponentIndex < this.myComponentList.size() - 1) {
                    ++this.myCurrentScrollComponentIndex;
                    if (this.myCurrentScrollComponentIndex == this.myComponentList.size() - 1) {
                        this.myTargetScrollPosition = this.myComponentPanel.getHeight() - this.myComponentPanelViewPort.getExtentSize().height;
                        this.myScrollDownButton.setEnabled(false);
                        this.myScrollDownButton.setIcon(null);
                    } else {
                        Component currentComponent = (Component)this.myComponentList.get(this.myCurrentScrollComponentIndex);
                        this.myTargetScrollPosition = currentComponent.getY() + currentComponent.getHeight() + this.myInterComponentSpace - this.myComponentPanelViewPort.getExtentSize().height;
                    }
                }
                return;
            }
            this.myScrollAnimationTimer.stop();
            this.mySpeed = 2.0f;
            this.myScrollAnimationTimer = null;
        }
        int currentPosition = this.myComponentPanelViewPort.getViewPosition().y + this.myComponentPanelViewPort.getExtentSize().height + 1;
        int maxComponentPosition = currentPosition + this.myInterComponentSpace;
        Component currentComponent = null;
        while ((currentComponent == null || currentComponent == this.myComponentPanel) && currentPosition <= maxComponentPosition) {
            currentComponent = this.myComponentPanel.getComponentAt(2, currentPosition);
            ++currentPosition;
        }
        if (currentComponent != this.myComponentPanel && currentComponent != null) {
            this.myCurrentScrollComponentIndex = this.myComponentList.indexOf(currentComponent);
            this.myScrollDirection = 1;
            if (this.myCurrentScrollComponentIndex == this.myComponentList.size() - 1) {
                this.scrollDown(this.myComponentPanel.getHeight() - this.myComponentPanelViewPort.getExtentSize().height);
                this.myScrollDownButton.setEnabled(false);
                this.myScrollDownButton.setIcon(null);
            } else {
                this.scrollDown(currentComponent.getY() + currentComponent.getHeight() + this.myInterComponentSpace - this.myComponentPanelViewPort.getExtentSize().height);
            }
        }
    }

    protected void scrollUp(int targetScrollPosition) {
        if (!this.myEnableAnimation) {
            this.myComponentPanelViewPort.setViewPosition(new Point(0, targetScrollPosition));
        } else {
            if (this.myScrollAnimationTimer != null) {
                this.myScrollAnimationTimer.stop();
                this.myScrollAnimationTimer = null;
                this.mySpeed = 2.0f;
            }
            this.myScrollAnimationTimer = new Timer(30, this.myAnimateScrollUpListener);
            this.myScrollAnimationTimer.setCoalesce(false);
            this.myTargetScrollPosition = targetScrollPosition;
            this.myScrollAnimationTimer.start();
        }
    }

    protected void scrollUp() {
        if (this.myScrollAnimationTimer != null) {
            if (this.myScrollDirection == 0) {
                if (this.myCurrentScrollComponentIndex > 0) {
                    --this.myCurrentScrollComponentIndex;
                    if (this.myCurrentScrollComponentIndex == 0) {
                        this.myTargetScrollPosition = 0;
                        this.myScrollUpButton.setEnabled(false);
                        this.myScrollUpButton.setIcon(null);
                    } else {
                        Component currentComponent = (Component)this.myComponentList.get(this.myCurrentScrollComponentIndex);
                        this.myTargetScrollPosition = currentComponent.getY() - this.myInterComponentSpace;
                    }
                }
                return;
            }
            this.myScrollAnimationTimer.stop();
            this.mySpeed = 2.0f;
            this.myScrollAnimationTimer = null;
        }
        int currentPosition = this.myComponentPanelViewPort.getViewPosition().y - 1;
        int minComponentPosition = currentPosition - this.myInterComponentSpace;
        Component currentComponent = null;
        while ((currentComponent == null || currentComponent == this.myComponentPanel) && currentPosition >= minComponentPosition) {
            currentComponent = this.myComponentPanel.getComponentAt(2, currentPosition);
            --currentPosition;
        }
        if (currentComponent != this.myComponentPanel && currentComponent != null) {
            this.myCurrentScrollComponentIndex = this.myComponentList.indexOf(currentComponent);
            this.myScrollDirection = 0;
            if (this.myCurrentScrollComponentIndex == 0) {
                this.scrollUp(0);
                this.myScrollUpButton.setEnabled(false);
                this.myScrollUpButton.setIcon(null);
            } else {
                this.scrollUp(currentComponent.getY() - this.myInterComponentSpace);
            }
        }
    }

    protected AbstractButton createScrollDownButton() {
        PToolButton button = new PToolButton();
        button.setName("PAnimatedScrollPanel.ScrollDownButton");
        button.setIcon(this.myScrollDownIcon);
        button.setMargin(SCROLL_BUTTON_MARGIN);
        button.setPressedIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.DownPressedIcon"));
        button.setDisabledIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.DownDisabledIcon"));
        button.setRolloverIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.DownRolloverIcon"));
        button.setMinimumSize(button.getPreferredSize());
        return button;
    }

    protected AbstractButton createScrollUpButton() {
        PToolButton button = new PToolButton();
        button.setMargin(SCROLL_BUTTON_MARGIN);
        button.setName("PAnimatedScrollPanel.ScrollUpButton");
        button.setIcon(this.myScrollUpIcon);
        button.setPressedIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.UpPressedIcon"));
        button.setDisabledIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.UpDisabledIcon"));
        button.setRolloverIcon(WidgetResources.getImageIcon("PAnimatedScrollPanel.UpRolloverIcon"));
        button.setMinimumSize(button.getPreferredSize());
        return button;
    }

    private void loadComponents(List componentList) {
        this.myComponentList = componentList;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 19;
        int componentListCount = componentList.size();
        int componentCounter = 0;
        while (componentCounter < componentListCount) {
            int insetsTop = componentCounter == 0 ? this.myTopSpace : this.myInterComponentSpace;
            gbc.insets = new Insets(insetsTop, 1, 0, 1);
            gbc.gridy = componentCounter;
            Component currentComponent = (Component)componentList.get(componentCounter);
            this.myComponentPanel.add(currentComponent, gbc);
            currentComponent.addMouseListener(this.myMouseOverListener);
            ++componentCounter;
        }
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.insets = new Insets(this.myInterComponentSpace, 0, this.myBottomSpace, 0);
        gbc.gridy = componentListCount;
        this.myComponentPanel.add((Component)new PLabel(), gbc);
    }

    private void refreshScrollButtons() {
        int viewTopY = this.myComponentPanelViewPort.getViewPosition().y;
        int viewBottomY = viewTopY + this.myComponentPanelViewPort.getExtentSize().height;
        if (viewTopY >= this.myTopSpace) {
            this.myScrollUpButton.setEnabled(true);
            this.myScrollUpButton.setIcon(this.myScrollUpIcon);
            this.myScrollUpButton.setVisible(true);
        } else {
            this.myScrollUpButton.setEnabled(false);
            this.myScrollUpButton.setIcon(null);
            this.myScrollUpButton.setVisible(false);
        }
        if (viewBottomY < this.myComponentPanel.getHeight() - this.myBottomSpace) {
            this.myScrollDownButton.setEnabled(true);
            this.myScrollDownButton.setIcon(this.myScrollDownIcon);
            this.myScrollDownButton.setVisible(true);
        } else {
            this.myScrollDownButton.setEnabled(false);
            this.myScrollDownButton.setIcon(null);
            this.myScrollDownButton.setVisible(false);
        }
    }
}

