/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.navigation;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.buttons.PToggleToolButton;
import com.nokia.widgets.navigation.NavigationButtonUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;

public class NavigationButton
extends PToggleToolButton {
    private static String uiClassID = "NavigationButtonUI";
    protected boolean myAnimationEnabled = true;
    private JLabel myAnimationIconLabel = new JLabel();
    private boolean myAnimationIconLabelAdded = false;
    private boolean myShowText = true;

    public NavigationButton(Action action) {
        super((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"), false);
        this.setLayout(null);
        this.setIconTextGap(5);
        this.setName((String)action.getValue("Name"));
        this.setAction(new LocalizedAction(action));
        if ((Integer)action.getValue("MnemonicKey") != null) {
            this.setMnemonic((Integer)action.getValue("MnemonicKey"));
        }
        if ((Integer)action.getValue("SwingDisplayedMnemonicIndexKey") != null) {
            this.setDisplayedMnemonicIndex((Integer)action.getValue("SwingDisplayedMnemonicIndexKey"));
        }
        this.init();
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.myAnimationEnabled = animationEnabled;
        if (this.myAnimationIconLabelAdded && !this.myAnimationEnabled) {
            this.remove(this.myAnimationIconLabel);
            this.myAnimationIconLabelAdded = false;
            this.repaint();
        } else if (!this.myAnimationIconLabelAdded && this.myAnimationEnabled) {
            this.add(this.myAnimationIconLabel);
            this.myAnimationIconLabelAdded = true;
        }
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled;
    }

    public void setAnimationIcon(Icon animationIcon) {
        this.myAnimationIconLabel.setIcon(animationIcon);
        if (animationIcon == null || this.myAnimationIconLabelAdded) {
            this.remove(this.myAnimationIconLabel);
            this.myAnimationIconLabelAdded = false;
        }
        if (animationIcon != null) {
            this.myAnimationIconLabel.setSize(animationIcon.getIconWidth(), animationIcon.getIconHeight());
            this.add(this.myAnimationIconLabel);
            this.myAnimationIconLabelAdded = true;
        }
    }

    public Icon getAnimationIcon() {
        return this.myAnimationIconLabel.getIcon();
    }

    public void setShowText(boolean showText) {
        this.myShowText = showText;
        this.repaint();
    }

    public boolean isShowingText() {
        return this.myShowText;
    }

    @Override
    public String getText() {
        if (this.myShowText) {
            return super.getText();
        }
        return "";
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(NavigationButtonUI.createUI(this));
        this.setBackground(NetLookAndFeel.getWhite());
    }

    protected void setAnimationIconPosition(int x, int y) {
        this.myAnimationIconLabel.setLocation(x, y);
    }

    protected void init() {
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setFocusable(false);
        this.setBackground(NetLookAndFeel.getWhite());
        this.setBorderPainted(false);
    }

    class LocalizedAction
    extends AbstractAction {
        private Action myAction;

        LocalizedAction(Action action) {
            this.myAction = action;
            this.putValue("Name", NavigationButton.this.getText());
            this.putValue("SmallIcon", NavigationButton.this.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myAction.actionPerformed(e);
        }
    }
}

