/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.navigation;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.NetToggleButtonUI;
import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.navigation.NavigationButton;
import com.nokia.widgets.navigation.NavigationPanel;
import com.nokia.widgets.util.SystemUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class NavigationButtonUI
extends NetToggleButtonUI {
    protected static final int ANIMATION_ICON_SPACE = 9;
    public static final NavigationButtonUI SHARED_INSTANCE = new NavigationButtonUI();
    protected static final int MINIMUM_WIDTH = 70;
    protected static final String CONTINUATION_TEXT = "...";
    protected static final int MAX_TEXT_ROWS = 3;
    protected static final int TEXT_SPACE = 2;
    private static final int EXTRA_PADDING = 6;
    static final double VIEWBAR_ARC_WIDTH = 14.0;
    static final double VIEWBAR_ARC_HEIGHT = 14.0;

    private NavigationButtonUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        return SHARED_INSTANCE;
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        return this.calculateSize(component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        return this.calculateSize(component);
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        AbstractButton viewBarButton = (AbstractButton)component;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ButtonModel model = viewBarButton.getModel();
        Dimension size = viewBarButton.getSize();
        Color oldColor = graphics.getColor();
        if (model.isArmed() && model.isPressed()) {
            if (model.isEnabled()) {
                this.paintPressed(graphics2D, viewBarButton, size);
            } else {
                this.paintPressedDisabled(graphics2D, viewBarButton, size);
            }
        } else if (model.isSelected()) {
            if (model.isEnabled()) {
                this.paintSelected(graphics2D, viewBarButton, size);
            } else {
                this.paintPressedDisabled(graphics2D, viewBarButton, size);
            }
        } else if (model.isEnabled()) {
            if (model.isRollover()) {
                this.paintRollover(graphics2D, viewBarButton, size);
            } else {
                this.paintNormal(graphics2D, viewBarButton, size);
            }
        } else {
            this.paintDisabled(graphics2D, viewBarButton, size);
        }
        graphics.setColor(oldColor);
    }

    /*
     * Unable to fully structure code
     */
    public String[] wrapTextShortened(String text, FontMetrics fontMetrics, int lineWidth, int maxRows) {
        textList = new ArrayList<String>();
        textWidth = fontMetrics.stringWidth(text);
        rowIndex = 1;
        tempTextParam = text;
        while (textWidth > lineWidth) {
            lastRow = rowIndex == maxRows;
            ++rowIndex;
            tempText = text;
            firstPart = "";
            if (!lastRow || textWidth <= lineWidth) ** GOTO lbl33
            continuationTextWidth = fontMetrics.stringWidth("...");
            while (textWidth > lineWidth - continuationTextWidth && tempText.length() > 0) {
                firstPart = tempText.substring(0, tempText.length() - 1);
                textWidth = fontMetrics.stringWidth(String.valueOf(firstPart) + "...");
                tempText = firstPart;
            }
            textList.add(String.valueOf(firstPart) + "...");
            textWidth = 0;
            tempTextParam = null;
            continue;
lbl-1000:
            // 1 sources

            {
                index = tempText.lastIndexOf(32);
                if (index == -1) {
                    while (textWidth > lineWidth && tempText.length() > 0) {
                        firstPart = tempText.substring(0, tempText.length() - 1);
                        textWidth = fontMetrics.stringWidth(firstPart);
                        tempText = firstPart;
                    }
                    break;
                }
                firstPart = tempText.substring(0, index);
                textWidth = fontMetrics.stringWidth(firstPart);
                tempText = firstPart;
lbl33:
                // 2 sources

                ** while (textWidth > lineWidth)
            }
lbl34:
            // 2 sources

            textList.add(firstPart);
            tempTextParam = tempTextParam.substring(firstPart.length(), tempTextParam.length()).trim();
            textWidth = fontMetrics.stringWidth(tempTextParam);
        }
        if (tempTextParam != null) {
            textList.add(tempTextParam);
        }
        return textList.toArray(new String[textList.size()]);
    }

    protected void paintDisabled(Graphics2D graphics, AbstractButton button, Dimension size) {
        Icon icon = button.getDisabledIcon();
        if (icon == null) {
            icon = button.getIcon();
        }
        this.drawButtonIconAndLabel(button, icon, graphics, size);
    }

    protected void paintNormal(Graphics2D graphics, AbstractButton button, Dimension size) {
        this.drawButtonIconAndLabel(button, button.getIcon(), graphics, size);
    }

    protected void paintRollover(Graphics2D graphics, AbstractButton button, Dimension size) {
        Icon icon = button.getRolloverIcon();
        if (!SystemUtils.isOrangeTouch() || icon == null) {
            icon = button.getIcon();
        }
        this.drawGradients(button, graphics);
        this.drawBottomBorder(button, graphics);
        this.drawLeftRightBorders(button, graphics);
        this.drawRolloverTopBorder(button, graphics);
        this.drawButtonIconAndLabel(button, icon, graphics, size);
    }

    protected void paintPressed(Graphics2D graphics, AbstractButton button, Dimension size) {
        Icon icon = button.getPressedIcon();
        if (icon == null) {
            icon = button.getIcon();
        }
        this.drawPressedGradients(button, graphics);
        this.drawPressedOutline(button, graphics);
        this.drawButtonIconAndLabel(button, icon, graphics, size);
    }

    protected void paintSelected(Graphics2D graphics, AbstractButton button, Dimension size) {
        Icon icon = button.getPressedIcon();
        if (icon == null) {
            icon = button.getIcon();
        }
        this.drawGradients(button, graphics);
        this.drawBottomBorder(button, graphics);
        this.drawLeftRightBorders(button, graphics);
        this.drawSelectedTopBorder(button, graphics);
        this.drawButtonIconAndLabel(button, icon, graphics, size);
    }

    private void drawRolloverTopBorder(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Shape topHighlightOutline = NavigationButtonUI.getGrayBorder(button);
        graphics.setColor(UIManager.getColor("NavigationButton.rolloverTopBorder"));
        graphics.fill(topHighlightOutline);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawSelectedTopBorder(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Shape topHighlightOutline = NavigationButtonUI.getOrangeBorder(button);
        Color orange = UIManager.getColor("NavigationButton.selectedTopBorder");
        graphics.setColor(orange);
        graphics.fill(topHighlightOutline);
        Color shadow = UIManager.getColor("NavigationButton.selectedTopBorderShadow");
        graphics.setColor(shadow);
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(button.getWidth() - 4, button.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        graphics.drawLine(x + 6, y + 2, x + w - 6, y + 3);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawBottomBorder(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Shape bottomHighlightOutline = NavigationButtonUI.getViewBarGrayHighlightOutline(button);
        Color color = UIManager.getColor("NavigationButton.bottomBorder");
        graphics.setColor(color);
        graphics.fill(bottomHighlightOutline);
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(button.getWidth() - 4, button.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        int commonX = x + 4;
        int commonY = x + w - 5;
        color = UIManager.getColor("NavigationButton.bottomBorderShadow5");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 7, commonY, y + h - 7);
        color = UIManager.getColor("NavigationButton.bottomBorderShadow4");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 6, commonY, y + h - 6);
        color = UIManager.getColor("NavigationButton.bottomBorderShadow3");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 5, commonY, y + h - 5);
        color = UIManager.getColor("NavigationButton.bottomBorderShadow2");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 4, commonY, y + h - 4);
        color = UIManager.getColor("NavigationButton.bottomBorderShadow1");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 3, commonY, y + h - 3);
        color = UIManager.getColor("NavigationButton.bottomBorderShadow1");
        graphics.setColor(color);
        graphics.drawLine(commonX, y + h - 2, commonY, y + h - 2);
        Object[] colors = (Object[])UIManager.getDefaults().get("NavigationButton.whiteunderlay");
        int i = 0;
        while (i < 6) {
            graphics.setColor((Color)colors[i]);
            graphics.drawLine(commonX, y + h - (i + 2), commonX, y + h - (i + 2));
            graphics.drawLine(commonY, y + h - (i + 2), commonY, y + h - (i + 2));
            ++i;
        }
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawGradients(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Shape[] gradientAreas = NavigationButtonUI.getOutlineParts(button);
        Color color1 = Color.white;
        Color color2 = UIManager.getColor("NavigationButton.gradient1");
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color1, color2}, gradientAreas[0]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color2, color1}, gradientAreas[1]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color2, color1}, gradientAreas[2]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color1, color2}, gradientAreas[3]);
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(button.getWidth() - 5, button.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int width = roundRect.getBounds().width;
        int height = roundRect.getBounds().height;
        Color shadow = UIManager.getColor("NavigationButton.gradientShadow1");
        graphics.setColor(shadow);
        graphics.drawLine(x, y + 5, x, y + height - 8);
        graphics.drawLine(x + width, y + 5, x + width, y + height - 8);
        shadow = UIManager.getColor("NavigationButton.gradientShadow2");
        graphics.setColor(shadow);
        graphics.drawLine(x + 1, y + 3, x + 1, y + height - 9);
        graphics.drawLine(x + width - 1, y + 3, x + width - 1, y + height - 9);
        shadow = UIManager.getColor("NavigationButton.gradientShadow3");
        graphics.setColor(shadow);
        graphics.drawLine(x + 2, y + 3, x + 2, y + height - 9);
        graphics.drawLine(x + width - 2, y + 3, x + width - 2, y + height - 9);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawLeftRightBorders(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(button.getWidth() - 5, button.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        Color shadow = UIManager.getColor("NavigationButton.leftrightBorder");
        graphics.setColor(shadow);
        graphics.drawLine(x, y + 4, x, y + h - 5);
        graphics.drawLine(x + w, y + 4, x + w, y + h - 5);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawPressedGradients(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Shape[] gradientAreas = NavigationButtonUI.getOutlineParts(button);
        Color color1 = UIManager.getColor("NavigationButton.pressedGradient1");
        Color color2 = UIManager.getColor("NavigationButton.pressedGradient2");
        Color color3 = UIManager.getColor("NavigationButton.pressedGradient3");
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color1, color2}, gradientAreas[0]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color2, color1}, gradientAreas[1]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color2, color3}, gradientAreas[2]);
        GradientUtils.drawHorizontalGradient((JComponent)button, (Graphics)graphics, new Color[]{color3, color2}, gradientAreas[3]);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawPressedOutline(AbstractButton button, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        Color lineColor = UIManager.getColor("NavigationButton.pressedOutline");
        Shape etchedRoundRect = NavigationButtonUI.getButtonOutline(button);
        graphics.setColor(lineColor);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.draw(etchedRoundRect);
        graphics.setColor(oldColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintPressedDisabled(Graphics2D graphics, AbstractButton button, Dimension size) {
        Icon icon = button.getDisabledIcon();
        if (icon == null) {
            icon = button.getIcon();
        }
        this.drawButtonIconAndLabel(button, icon, graphics, size);
    }

    private Icon getCorrectIcon(AbstractButton button) {
        ButtonModel model = button.getModel();
        Icon icon = null;
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            icon = model.isEnabled() ? button.getPressedIcon() : button.getDisabledIcon();
        } else {
            Icon icon2 = model.isEnabled() ? (model.isRollover() ? button.getRolloverIcon() : button.getIcon()) : (icon = button.getDisabledIcon());
        }
        if (icon == null) {
            icon = button.getIcon();
        }
        return icon;
    }

    private Dimension calculateSize(JComponent component) {
        AbstractButton button = (AbstractButton)component;
        Icon buttonIcon = this.getCorrectIcon(button);
        int height = 0;
        int width = 70;
        if (button.getText() != null && button.getText().length() != 0) {
            Container panel;
            Container parent = button.getParent();
            if (parent != null && (panel = parent.getParent().getParent().getParent()) instanceof NavigationPanel) {
                width = ((NavigationPanel)panel).getPreferredWidth() - 6;
                width += 4 * NetLookAndFeel.getFontSizeIncrement();
            }
        } else if (buttonIcon != null) {
            width = 9 + buttonIcon.getIconWidth();
        }
        if (buttonIcon != null) {
            height += buttonIcon.getIconHeight() + button.getIconTextGap();
        }
        FontMetrics fontMetrics = button.getFontMetrics(button.getFont());
        String buttonText = button.getText();
        if (button instanceof NavigationButton && ((NavigationButton)button).getText().length() == 0) {
            buttonText = null;
        }
        if (buttonText != null && !"".equals(buttonText)) {
            height = (int)((double)height + 15.600000000000001);
            if (buttonIcon == null) {
                height += 2;
            }
            height += fontMetrics.getHeight() * this.wrapTextShortened(buttonText, fontMetrics, width - 4, 3).length;
        } else {
            width += 2;
            height += 6;
        }
        return new Dimension(width, height);
    }

    private void drawButtonIconAndLabel(AbstractButton button, Icon currentIcon, Graphics2D graphics, Dimension size) {
        Icon animationIcon;
        NavigationButton naviButton;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = graphics.getColor();
        ButtonModel model = button.getModel();
        if (model.isEnabled()) {
            if (model.isRollover() && !model.isPressed()) {
                ColorUIResource orange = NetTheme.getTextHoverColor();
                graphics.setColor(orange);
            } else {
                graphics.setColor(button.getForeground());
            }
        } else {
            graphics.setColor(this.getDisabledTextColor());
        }
        int iconPosition = 0;
        int iconHeight = 0;
        int textTop = 0;
        String buttonText = button.getText();
        if (currentIcon != null) {
            textTop = buttonText == null || buttonText.trim().length() == 0 ? 2 : 6;
            iconPosition = size.width / 2 - currentIcon.getIconWidth() / 2 + 1;
            currentIcon.paintIcon(button, graphics, iconPosition, textTop + 3);
            iconHeight = currentIcon.getIconHeight();
            textTop += iconHeight + button.getIconTextGap();
        } else {
            textTop += 12;
        }
        if (button instanceof NavigationButton && (naviButton = (NavigationButton)button).isAnimationEnabled() && (animationIcon = naviButton.getAnimationIcon()) != null) {
            int animationIconPosition = iconPosition - animationIcon.getIconWidth();
            if (animationIconPosition < 9) {
                animationIconPosition = 9;
            }
            int animIconY = buttonText == null || "".equals(button.getText()) ? naviButton.getHeight() - animationIcon.getIconHeight() - 3 : iconHeight - animationIcon.getIconHeight();
            naviButton.setAnimationIconPosition(animationIconPosition, animIconY);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        NetLookAndFeel.toggleTextAntialiasing(graphics);
        if (buttonText != null && !"".equals(buttonText)) {
            if (button.isEnabled()) {
                Color mainColor = graphics.getColor();
                graphics.setColor(NetLookAndFeel.getWhite());
                this.paintText(button, graphics, size, textTop - 2, buttonText);
                graphics.setColor(mainColor);
            }
            this.paintText(button, graphics, size, textTop - 3, buttonText);
        }
        graphics.setColor(oldColor);
    }

    private void paintText(AbstractButton button, Graphics2D graphics, Dimension size, int textTop, String buttonText) {
        Font font = button.getFont();
        FontMetrics fontMetrics = button.getFontMetrics(font);
        graphics.setFont(font);
        String[] texts = this.wrapTextShortened(buttonText, fontMetrics, size.width - 4, 3);
        int mnemonicIndex = this.getCorrectMnemonicIndex(button.getDisplayedMnemonicIndex(), texts, buttonText);
        int[] mnemonicWordIndex = this.getWordLocation(mnemonicIndex, texts);
        int textIndex = 0;
        while (textIndex < texts.length) {
            if (textIndex == mnemonicWordIndex[0]) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, texts[textIndex], mnemonicWordIndex[1], size.width / 2 - fontMetrics.stringWidth(texts[textIndex]) / 2, textTop + (textIndex + 1) * fontMetrics.getHeight() - fontMetrics.getDescent());
            } else {
                graphics.drawString(texts[textIndex], size.width / 2 - fontMetrics.stringWidth(texts[textIndex]) / 2, textTop + (textIndex + 1) * fontMetrics.getHeight() - fontMetrics.getDescent());
            }
            ++textIndex;
        }
    }

    public int[] getWordLocation(int displayMnemonicIndex, String[] texts) {
        int[] result = new int[2];
        int count = 0;
        int prevCount = 0;
        int textIndex = 0;
        while (textIndex < texts.length) {
            int stringBound = texts[textIndex].length();
            if (displayMnemonicIndex < (count += stringBound)) {
                result[0] = textIndex;
                result[1] = displayMnemonicIndex - prevCount;
                break;
            }
            prevCount += stringBound;
            ++textIndex;
        }
        return result;
    }

    public int getCorrectMnemonicIndex(int displayMnemonicIndex, String[] texts, String oldText) {
        int mnemonicIndex = displayMnemonicIndex;
        StringBuffer textBuffer = new StringBuffer();
        int i = 0;
        while (i < texts.length) {
            textBuffer.append(texts[i]);
            ++i;
        }
        String newText = textBuffer.toString();
        int i2 = 0;
        while (i2 < texts.length) {
            int oldTextIndex;
            int startLetter = oldTextIndex = oldText.indexOf(texts[i2]);
            int endLetter = startLetter + texts[i2].length() - 1;
            int newTextIndex = newText.indexOf(texts[i2]);
            if (newTextIndex < oldTextIndex && mnemonicIndex >= startLetter && mnemonicIndex <= endLetter) {
                mnemonicIndex -= oldTextIndex - newTextIndex;
            }
            ++i2;
        }
        if (newText.endsWith(CONTINUATION_TEXT) && newText.lastIndexOf(CONTINUATION_TEXT) <= mnemonicIndex) {
            return -1;
        }
        return mnemonicIndex;
    }

    public static Shape getOrangeBorder(JComponent comp) {
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(comp.getWidth() - 4, comp.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        RoundRectangle2D.Double downRect = new RoundRectangle2D.Double(x, y + 3, w, h - 3, 14.0, 14.0);
        Area downRectArea = new Area(downRect);
        Area roundRectArea = new Area(roundRect);
        roundRectArea.subtract(downRectArea);
        return roundRectArea;
    }

    public static Shape getGrayBorder(JComponent comp) {
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(comp.getWidth() - 4, comp.getHeight() + 1);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        RoundRectangle2D.Double upRect = new RoundRectangle2D.Double(x, y, w, y + 10, 14.0, 14.0);
        Area upRectArea = new Area(upRect);
        RoundRectangle2D.Double downRect = new RoundRectangle2D.Double(x, y + 1, w, y + 10, 14.0, 14.0);
        Area downRectArea = new Area(downRect);
        upRectArea.subtract(downRectArea);
        return upRectArea;
    }

    public static Shape getViewBarGrayHighlightOutline(JComponent comp) {
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(comp.getWidth() - 4, comp.getHeight());
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        RoundRectangle2D.Double bottomRect = new RoundRectangle2D.Double(x, y + h - 7, w, 7.0, 14.0, 14.0);
        Area bottomRectArea = new Area(bottomRect);
        Rectangle2D.Double bottomEdge = new Rectangle2D.Double(x + 5, y + h - 4, w - 10, 15.0);
        Area bottomEdgeArea = new Area(bottomEdge);
        bottomRectArea.subtract(bottomEdgeArea);
        return bottomRectArea;
    }

    public static Shape getButtonOutline(JComponent comp) {
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(comp.getWidth() - 5, comp.getHeight() + 1);
        Area rectArea = new Area(roundRect);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int w = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        Rectangle2D.Double bottomCrop = new Rectangle2D.Double(x + 3, y + h - 5, w - 6, 15.0);
        Area bottomCropArea = new Area(bottomCrop);
        rectArea.subtract(bottomCropArea);
        return rectArea;
    }

    public static Shape[] getOutlineParts(JComponent comp) {
        Shape[] parts = new Shape[4];
        RectangularShape roundRect = NavigationButtonUI.getRoundRect(comp.getWidth() - 4, comp.getHeight() + 1);
        Area roundRectArea = new Area(roundRect);
        int x = roundRect.getBounds().x;
        int y = roundRect.getBounds().y;
        int width = roundRect.getBounds().width;
        int h = roundRect.getBounds().height;
        Rectangle2D.Double leftEdge = new Rectangle2D.Double();
        leftEdge.setFrame(x, y, 20.0, h);
        Area leftEdgeArea = new Area(leftEdge);
        Rectangle2D.Double rightEdge = new Rectangle2D.Double();
        rightEdge.setFrame(width - 19, y, 20.0, h);
        Area rightEdgeArea = new Area(rightEdge);
        leftEdgeArea.intersect(roundRectArea);
        rightEdgeArea.intersect(roundRectArea);
        Rectangle2D.Double leftCenter = new Rectangle2D.Double();
        int spanOfGradient = width / 2 - 20;
        leftCenter.setFrame(x + 20, y, spanOfGradient, h);
        Area leftCenterArea = new Area(leftCenter);
        Rectangle2D.Double rightCenter = new Rectangle2D.Double();
        rightCenter.setFrame(x + width / 2, y, spanOfGradient, h);
        Area rightCenterArea = new Area(rightCenter);
        Rectangle2D.Double cropEdge = new Rectangle2D.Double(x + 4, y + h - 5, width - 8, 15.0);
        Area cropEdgeArea = new Area(cropEdge);
        leftEdgeArea.subtract(cropEdgeArea);
        leftCenterArea.subtract(cropEdgeArea);
        rightCenterArea.subtract(cropEdgeArea);
        rightEdgeArea.subtract(cropEdgeArea);
        parts[0] = leftEdgeArea;
        parts[1] = rightEdgeArea;
        parts[2] = leftCenterArea;
        parts[3] = rightCenterArea;
        return parts;
    }

    public static RectangularShape getRoundRect(int width, int height) {
        return new RoundRectangle2D.Double(2.0, 0.0, width, height, 14.0, 14.0);
    }
}

