/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.navigation;

import com.nokia.widgets.PPanel;
import com.nokia.widgets.navigation.AnimatedScrollPanel;
import com.nokia.widgets.navigation.NavigationButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;

public class NavigationPanel
extends PPanel {
    private AnimatedScrollPanel myScrollPanel;
    private List<NavigationButton> myNavigationButtons = new ArrayList<NavigationButton>();
    private ButtonGroup myButtonGroup = new ButtonGroup();
    private JPopupMenu myPopupMenu;
    private transient MouseListener myPopupListener;
    private boolean myNavibuttonTextsVisible = true;
    private Image myBackgroundImage = null;
    private int myPreferredWidth = 113;

    public NavigationPanel() {
        this.setLayout(new BorderLayout(6, 0));
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.myScrollPanel = new AnimatedScrollPanel();
        this.myScrollPanel.setInterComponentSpace(0);
        this.add(this.myScrollPanel);
        this.myPopupListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.handleEvent(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.handleEvent(evt);
            }

            private void handleEvent(MouseEvent evt) {
                if (evt.isPopupTrigger() && NavigationPanel.this.myPopupMenu != null) {
                    NavigationPanel.this.myPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        };
        this.addMouseListener(this.myPopupListener);
    }

    public void refreshGUI() {
        this.myScrollPanel.refreshGUI();
    }

    public void showNaviButtonTexts(boolean value) {
        this.myNavibuttonTextsVisible = value;
        int i = 0;
        while (i < this.myNavigationButtons.size()) {
            this.myNavigationButtons.get(i).setShowText(this.myNavibuttonTextsVisible);
            ++i;
        }
        this.myScrollPanel.setComponentList(this.myNavigationButtons);
        this.myScrollPanel.revalidate();
    }

    public boolean isNaviButtonTextsShown() {
        return this.myNavibuttonTextsVisible;
    }

    public void addPopUpMenuItem(Component item) {
        if (this.myPopupMenu == null) {
            this.myPopupMenu = new JPopupMenu();
        }
        this.myPopupMenu.add(item);
    }

    public void removePopUpMenuItem(Component item) {
        this.myPopupMenu.remove(item);
    }

    public int add(Action action) {
        return this.add(action, false);
    }

    public int add(Action action, boolean executeAction) {
        return this.add(action, executeAction, -1);
    }

    public int add(Action action, int index) {
        return this.add(action, false, index);
    }

    public int add(Action action, boolean executeAction, int index) {
        return this.addButton(new NavigationButton(action), executeAction, index);
    }

    public int addButton(NavigationButton button, boolean executeAction, int index) {
        button.addMouseListener(this.myPopupListener);
        button.setShowText(this.myNavibuttonTextsVisible);
        this.myButtonGroup.add(button);
        if (index != -1) {
            this.myNavigationButtons.add(index, button);
        } else {
            this.myNavigationButtons.add(button);
        }
        this.myScrollPanel.setComponentList(this.myNavigationButtons);
        if (executeAction) {
            button.doClick();
        }
        return this.myNavigationButtons.indexOf(button);
    }

    public int addButton(NavigationButton button) {
        return this.addButton(button, false, -1);
    }

    public NavigationButton getButton(int index) {
        if (index < this.myNavigationButtons.size()) {
            return this.myNavigationButtons.get(index);
        }
        return null;
    }

    public List<NavigationButton> getButtons() {
        ArrayList<NavigationButton> copy = null;
        if (this.myNavigationButtons != null) {
            copy = new ArrayList<NavigationButton>(this.myNavigationButtons);
        }
        return copy;
    }

    public NavigationButton getButton(String name) {
        int i = 0;
        while (i < this.myNavigationButtons.size()) {
            NavigationButton button = this.myNavigationButtons.get(i);
            if (button instanceof AbstractButton && (name.equals(((AbstractButton)button).getName()) || name.equals(((AbstractButton)button).getAction().getValue("Name")))) {
                return button;
            }
            ++i;
        }
        return null;
    }

    public Action getAction(int index) {
        if (index < this.myNavigationButtons.size()) {
            return this.getButton(index).getAction();
        }
        return null;
    }

    public void setPreferredWidth(int width) {
        this.myPreferredWidth = width;
    }

    public int getPreferredWidth() {
        return this.myPreferredWidth;
    }

    public void setSelected(String name, boolean selected) {
        NavigationButton button = this.getButton(name);
        if (button != null) {
            this.myButtonGroup.setSelected(button.getModel(), selected);
        }
    }

    public void remove(String name) {
        NavigationButton button = this.getButton(name);
        this.removeButton(button);
    }

    public void removeButton(NavigationButton button) {
        if (button != null) {
            button.removeMouseListener(this.myPopupListener);
            this.myNavigationButtons.remove(button);
            this.myButtonGroup.remove(button);
            this.myScrollPanel.setComponentList(this.myNavigationButtons);
        }
    }

    public Image getBackgroundImage() {
        return this.myBackgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.myBackgroundImage = image;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myBackgroundImage != null) {
            g.drawImage(this.myBackgroundImage, this.getWidth() - this.myBackgroundImage.getWidth(null), this.getHeight() - this.myBackgroundImage.getHeight(null), this);
        }
    }

    public void setButtonsEnabled(boolean value) {
        boolean change = false;
        int i = 0;
        while (i < this.myNavigationButtons.size()) {
            if (this.getButton(i).isEnabled() != value) {
                change = true;
            }
            this.getButton(i).setEnabled(value);
            ++i;
        }
        if (change) {
            this.firePropertyChange("buttonsEnabled", !value, value);
        }
    }

    public boolean isButtonsEnabled() {
        boolean value = true;
        int i = 0;
        while (i < this.myNavigationButtons.size()) {
            value = value && this.getButton(i).isEnabled();
            ++i;
        }
        return value;
    }

    public int getButtonCount() {
        return this.myNavigationButtons.size();
    }

    public void removeAllButtons() {
        while (this.myNavigationButtons.size() > 0) {
            NavigationButton button = this.myNavigationButtons.get(0);
            this.myButtonGroup.remove(button);
            this.myNavigationButtons.get(0).removeMouseListener(this.myPopupListener);
            this.myNavigationButtons.remove(0);
        }
    }
}

