/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.navigation;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.navigation.ViewProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ViewSwitcher {
    public static final String ACTIVE_VIEW = "ActiveView";
    protected PPanel myPanel = new PPanel(new BorderLayout());
    protected Map myComponentToFontUptoDate;
    protected String myActiveView;
    protected PropertyChangeSupport mySupport;

    public ViewSwitcher() {
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.myComponentToFontUptoDate = new WeakHashMap();
        this.mySupport = new PropertyChangeSupport(this);
        NetLookAndFeel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("fontSizeIncrement".equals(evt.getPropertyName())) {
                    Iterator iter = ViewSwitcher.this.myComponentToFontUptoDate.keySet().iterator();
                    while (iter.hasNext()) {
                        ViewSwitcher.this.myComponentToFontUptoDate.put(iter.next(), Boolean.FALSE);
                    }
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.removePropertyChangeListener(listener);
    }

    public String getActiveView() {
        return this.myActiveView;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public Action createActionFor(final Component comp, String name) {
        return this.createActionFor(new ViewProvider(){

            @Override
            public Component getView() {
                return comp;
            }
        }, name);
    }

    public Action createActionFor(final ViewProvider provider, String name) {
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent arg) {
                Component view = provider.getView();
                ViewSwitcher.this.myPanel.removeAll();
                ViewSwitcher.this.myPanel.add(view, "Center");
                ViewSwitcher.this.myComponentToFontUptoDate.put(view, Boolean.TRUE);
                ViewSwitcher.this.mySupport.firePropertyChange(new PropertyChangeEvent(this, ViewSwitcher.ACTIVE_VIEW, ViewSwitcher.this.myActiveView, this.getValue("Name")));
                ViewSwitcher.this.myActiveView = (String)this.getValue("Name");
                ViewSwitcher.this.myPanel.revalidate();
                ViewSwitcher.this.myPanel.repaint();
            }
        };
    }
}

