/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.notification;

import com.nokia.laf.NetInternalFrameUI;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.hyperlink.Hyperlink;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.infotip.TipShadowBorder;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.util.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Notification
extends JInternalFrame {
    public static final int INFO_NOTIFICATION = 0;
    public static final int WARNING_NOTIFICATION = 1;
    public static final int ERROR_NOTIFICATION = 2;
    public static final int DEFAULT_DISAPPEAR_TIME = 9000;
    private int myType;
    private String myHeadline;
    private String myMessage;
    private Component myParent;
    private Timer myDismissTimer;
    private Timer myAlphaTimer;
    private Timer myCloseAlphaTimer;
    private Action myLink;
    private float myAlpha = 1.0f;
    private BufferedImage myImage;
    private boolean myUserChangedLocation = false;
    private ComponentListener myComponentListener;
    private static final int MARGIN = 16;

    public Notification(Component parent, String headline, String message) {
        this(parent, headline, message, 0, null);
    }

    public Notification(Component parent, String headline, String message, int type) {
        this(parent, headline, message, type, null);
    }

    public Notification(Component parent, String headline, String message, int type, Action action) {
        this.myHeadline = headline;
        this.myMessage = message;
        this.myType = type;
        this.myParent = parent;
        this.myLink = action;
        this.myAlphaTimer = new Timer(90, new AlphaAction(false));
        this.myCloseAlphaTimer = new Timer(90, new AlphaAction(true));
        this.myComponentListener = new ComponentHandler();
        this.setDismissDelay(9000);
        this.setOpaque(false);
        this.setClosable(false);
        this.setBorder(new TipShadowBorder());
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.buildUI();
    }

    public int getType() {
        return this.myType;
    }

    public String getHeadline() {
        return this.myHeadline;
    }

    public String getMessage() {
        return this.myMessage;
    }

    @Override
    public Component getMostRecentFocusOwner() {
        return null;
    }

    @Override
    public void restoreSubcomponentFocus() {
    }

    @Override
    public Component getFocusOwner() {
        return null;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible) {
                this.pack();
                RootPaneContainer root = null;
                root = this.myParent instanceof RootPaneContainer ? (RootPaneContainer)((Object)this.myParent) : (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this.myParent));
                if (root != null) {
                    JLayeredPane layeredPane = root.getLayeredPane();
                    this.setLocation(layeredPane.getWidth() - this.getWidth() - 16, layeredPane.getHeight() - this.getHeight() - 16);
                    layeredPane.add(this);
                    layeredPane.addComponentListener(this.myComponentListener);
                    this.toFront();
                    this.myAlpha = 0.0f;
                    this.myAlphaTimer.start();
                    this.myDismissTimer.start();
                }
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.remove(this);
                    ((JComponent)parent).revalidate();
                    ((JComponent)parent).repaint();
                    parent.removeComponentListener(this.myComponentListener);
                }
            }
        }
        super.setVisible(visible);
    }

    public void setDismissDelay(int dismissDelay) {
        int oldValue = -1;
        if (this.myDismissTimer == null) {
            this.myDismissTimer = new Timer(dismissDelay, new AutoCloseAction());
            this.myDismissTimer.setRepeats(false);
        } else {
            oldValue = this.myDismissTimer.getInitialDelay();
            this.myDismissTimer.setInitialDelay(dismissDelay);
        }
        this.firePropertyChange("dismissDelay", oldValue, dismissDelay);
    }

    @Override
    public void updateUI() {
        this.setUI(new NotificationUI(this));
    }

    @Override
    public void paint(Graphics g) {
        if (this.myImage == null || this.myImage.getWidth() != this.getWidth() || this.myImage.getHeight() != this.getHeight()) {
            if (this.myImage != null) {
                this.myImage.flush();
            }
            this.myImage = ImageUtils.createCompatibleTranslucentImage(this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = this.myImage.createGraphics();
        if (this.myAlpha > 1.0f) {
            this.myAlpha = 1.0f;
        }
        if (this.myAlpha < 0.0f) {
            this.myAlpha = 0.0f;
        }
        g2d.setComposite(AlphaComposite.getInstance(2, this.myAlpha));
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        RectangularShape internals = NetUtils.getOutline(this);
        internals.setFrame(insets.left, insets.top, internals.getWidth() - (double)(insets.left + insets.right) + 1.0, internals.getHeight() - (double)(insets.top + insets.bottom) + 1.0);
        GradientUtils.drawVerticalGradient((JComponent)this, g, "Balloon.backgroundGradient", (Shape)internals);
    }

    protected void buildUI() {
        ExtendedGridBagConstraints gc = new ExtendedGridBagConstraints();
        gc.insets = new Insets(11, 15, 0, 5);
        Container contentPane = this.getContentPane();
        ((JComponent)contentPane).setOpaque(false);
        contentPane.setLayout(new GridBagLayout());
        PLabel headlineLabel = PLabel.createTipText(this.myHeadline);
        contentPane.add((Component)headlineLabel, gc);
        gc.nextColumn();
        JButton closeButton = new JButton(new CloseAction());
        closeButton.setContentAreaFilled(false);
        CloseIcon closeIcon = new CloseIcon();
        closeIcon.setPaintRoundBackground(true);
        closeIcon.setSize(16);
        closeIcon.setMargin(5);
        closeIcon.setStrokeWidth(2);
        closeButton.setIcon(closeIcon);
        closeButton.setRolloverIcon(closeIcon);
        closeButton.setMargin(new Insets(0, 0, 0, 2));
        closeButton.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        closeButton.setFocusable(false);
        closeButton.setContentAreaFilled(false);
        closeButton.setBorderPainted(false);
        contentPane.add((Component)closeButton, gc);
        gc.nextRow();
        PLabel messageLabel = PLabel.createTipText(this.myMessage);
        gc.setBottomInset(10);
        gc.setTopInset(4);
        contentPane.add((Component)messageLabel, gc);
        if (this.myLink != null) {
            gc.nextRowSameColumn();
            contentPane.add((Component)new Hyperlink(this.myLink), gc);
        }
    }

    private final class AlphaAction
    implements ActionListener {
        private boolean myFadeOut;
        private static final float myAlphaDelta = 0.07f;

        public AlphaAction(boolean fadeOut) {
            this.myFadeOut = fadeOut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myFadeOut) {
                if ((double)Notification.this.myAlpha > 0.05) {
                    Notification notification = Notification.this;
                    notification.myAlpha = notification.myAlpha - 0.07f;
                } else {
                    Notification.this.myAlpha = 0.0f;
                    Notification.this.myAlphaTimer.stop();
                    Notification.this.setVisible(false);
                }
            } else if (Notification.this.myAlpha < 0.95f) {
                Notification notification = Notification.this;
                notification.myAlpha = notification.myAlpha + 0.07f;
            } else {
                Notification.this.myAlpha = 1.0f;
                Notification.this.myAlphaTimer.stop();
            }
            Notification.this.repaint();
        }
    }

    private class AutoCloseAction
    extends AbstractAction {
        private AutoCloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notification.this.myCloseAlphaTimer.restart();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Notification.this.setVisible(false);
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, Notification.this.myParent));
            if (root != null) {
                JLayeredPane layeredPane = root.getLayeredPane();
                Notification.this.setLocation(layeredPane.getWidth() - Notification.this.getWidth() - 16, layeredPane.getHeight() - Notification.this.getHeight() - 16);
                Notification.this.repaint();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Point myMousePressPoint;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Notification.this.myCloseAlphaTimer.stop();
            Notification.this.myDismissTimer.stop();
            Notification.this.myAlpha = 1.0f;
            Notification.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (Notification.this.myUserChangedLocation) {
                return;
            }
            Notification.this.myDismissTimer.restart();
            Notification.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myMousePressPoint = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.myMousePressPoint = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Notification.this.myUserChangedLocation = true;
            Notification.this.myCloseAlphaTimer.stop();
            int x = (int)((double)e.getX() - this.myMousePressPoint.getX() + (double)Notification.this.getX());
            int y = (int)((double)e.getY() - this.myMousePressPoint.getY() + (double)Notification.this.getY());
            Notification.this.setLocation(x, y);
            Notification.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private static class NotificationUI
    extends NetInternalFrameUI {
        public NotificationUI(JInternalFrame frame) {
            super(frame);
        }

        @Override
        protected JComponent createNorthPane(JInternalFrame jframe) {
            return null;
        }
    }
}

