/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.numberrangemodel;

import com.nokia.widgets.numberrangemodel.NumberRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultNumberRangeModel<T extends Number>
implements NumberRangeModel<T> {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList myListenerList = new EventListenerList();
    private T myValue;
    private T myMin;
    private T myMax;

    public DefaultNumberRangeModel(T value, T min, T max) {
        if (!(((Number)max).doubleValue() >= ((Number)min).doubleValue())) {
            throw new IllegalArgumentException("Invalid range properties");
        }
        this.myValue = value;
        this.myMin = min;
        this.myMax = max;
    }

    @Override
    public T getMinimum() {
        return this.myMin;
    }

    @Override
    public void setMinimum(T minimum) {
        T oldMin = this.myMin;
        this.myMin = minimum;
        if (!oldMin.equals(this.myMin)) {
            this.fireStateChanged();
        }
    }

    @Override
    public T getMaximum() {
        return this.myMax;
    }

    @Override
    public void setMaximum(T maximum) {
        T oldMax = this.myMax;
        this.myMax = maximum;
        if (!oldMax.equals(this.myMax)) {
            this.fireStateChanged();
        }
    }

    @Override
    public T getValue() {
        return this.myValue;
    }

    @Override
    public void setValue(T value) {
        T oldValue = this.myValue;
        this.myValue = value;
        if (!oldValue.equals(this.myValue)) {
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.myListenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.myListenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.myListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

