/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.print;

import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.PTabbedPane;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.print.PrintModel;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.SwingWorker;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintDialog
extends JDialog {
    private static final int DEFAULT_COPY_COUNT = 1;
    private static final double MARGIN_DEFAULT_VALUE = 25.0;
    private static final double INCH_TO_MILLIMETERS = 25.0;
    private PTabbedPane myTabbedPane;
    private PrintModel myPrintModel;
    private PLabel myPrinterStatusLabel;
    private PLabel myPrinterTypeLabel;
    private PLabel myPrinterLocationLabel;
    private PLabel myPrinterCommentLabel;
    private PComboBox myPrinterComboBox;
    private PComboBox myPaperSizeComboBox;
    private PComboBox myPaperSourceComboBox;
    private JCheckBox myPrintToFileCheckBox;
    private JCheckBox myCollateCheckBox;
    private JRadioButton myPageSelectionAllButton;
    private JRadioButton myPageSelectionCurrentButton;
    private JRadioButton myPageSelectionPagesButton;
    private JRadioButton myPortraitButton;
    private JRadioButton myLandscapeButton;
    private JRadioButton myMillimeterButton;
    private JRadioButton myInchesButton;
    private PTextField myPageSelectionPagesField;
    private PButton myPrintButton;
    private JButton myCancelButton;
    private PHelpButton myHelpButton;
    private PSpinner myNumberOfCopiesSpinner;
    private PSpinner myLeftMarginSpinner;
    private PSpinner myTopMarginSpinner;
    private PSpinner myBottomMarginSpinner;
    private PSpinner myRightMarginSpinner;
    private int myCurrentPage;

    public PrintDialog(Frame frame, Printable printable) {
        super(frame);
        this.myPrintModel = new PrintModel(printable);
        this.buildUi();
    }

    public PrintDialog(Frame frame, boolean isModal, Printable printable) {
        super(frame, isModal);
        this.myPrintModel = new PrintModel(printable);
        this.buildUi();
    }

    public PrintDialog(Frame frame, boolean isModal, Printable printable, int currentPage) {
        super(frame, isModal);
        this.myPrintModel = new PrintModel(printable);
        this.myCurrentPage = currentPage;
        this.buildUi();
    }

    private void buildUi() {
        this.setTitle(WidgetResources.getString("PrintDialog.DialogTitle"));
        JPanel containerPanel = (JPanel)this.getContentPane();
        containerPanel.add((Component)this.createTabbedPane(), "North");
        containerPanel.add((Component)this.createButtonPanel(), "South");
        this.setDefaultUiValues();
        this.setListeners();
        this.pack();
        this.setResizable(false);
    }

    private JTabbedPane createTabbedPane() {
        this.myTabbedPane = new PTabbedPane();
        this.myTabbedPane.add(WidgetResources.getString("PrintDialog.GeneralTabTitle"), this.createGeneralPanel());
        this.myTabbedPane.add(WidgetResources.getString("PrintDialog.PageTabTitle"), this.createPagePanel());
        this.myTabbedPane.setBorder(BorderFactory.createEmptyBorder(8, 3, 3, 3));
        return this.myTabbedPane;
    }

    private JPanel createGeneralPanel() {
        JPanel wholePanel = new JPanel();
        PVerticalLayout wholePanelLayout = new PVerticalLayout(0);
        wholePanelLayout.setVgap(7);
        wholePanel.setLayout(wholePanelLayout);
        JPanel generalPanel = new JPanel();
        PMatrixLayout generalLayout = new PMatrixLayout(3, 12, 2, 0, 0);
        generalPanel.setLayout(generalLayout);
        Dimension paddingBox = new Dimension(1, 0);
        PLabel nameLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.NameLabel"));
        generalPanel.add(nameLabel);
        this.myPrinterComboBox = new PComboBox();
        this.myPrinterComboBox.setPrototypeDisplayValue("############################");
        nameLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.PrinterNameMnemonic"));
        nameLabel.setLabelFor(this.myPrinterComboBox);
        generalPanel.add(this.myPrinterComboBox);
        generalPanel.add(Box.createRigidArea(paddingBox));
        this.updatePrinterNames();
        PLabel printerStatusLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.StatusLabel"));
        generalPanel.add(printerStatusLabel);
        this.myPrinterStatusLabel = PLabel.createValueText(WidgetResources.getString("PrintDialog.StatusNotAvailable"));
        generalPanel.add(this.myPrinterStatusLabel);
        generalPanel.add(Box.createRigidArea(paddingBox));
        PLabel printerTypeLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.TypeLabel"));
        generalPanel.add(printerTypeLabel);
        this.myPrinterTypeLabel = PLabel.createValueText(WidgetResources.getString("PrintDialog.TypeNotAvailable"));
        generalPanel.add(this.myPrinterTypeLabel);
        generalPanel.add(Box.createRigidArea(paddingBox));
        PLabel printerLocationLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.LocationLabel"));
        generalPanel.add(printerLocationLabel);
        this.myPrinterLocationLabel = PLabel.createValueText(WidgetResources.getString("PrintDialog.LocationNotAvailable"));
        generalPanel.add(this.myPrinterLocationLabel);
        generalPanel.add(Box.createRigidArea(paddingBox));
        PLabel printerCommentLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.CommentsLabel"));
        generalPanel.add(printerCommentLabel);
        this.myPrinterCommentLabel = PLabel.createValueText(WidgetResources.getString("PrintDialog.CommentNotAvailable"));
        generalPanel.add(this.myPrinterCommentLabel);
        this.myPrintToFileCheckBox = new JCheckBox();
        this.myPrintToFileCheckBox.setText(WidgetResources.getString("PrintDialog.PrintToFileLabel"));
        this.myPrintToFileCheckBox.setMnemonic(WidgetResources.getMnemonic("PrintDialog.PrintToFileMnemonic"));
        generalPanel.add(this.myPrintToFileCheckBox);
        JPanel selectionPanel = new JPanel();
        PMatrixLayout pageLayout = new PMatrixLayout(2);
        pageLayout.setVMargin(0);
        pageLayout.setVgap(0);
        pageLayout.setHgap(10);
        selectionPanel.setLayout(pageLayout);
        this.myPageSelectionAllButton = new JRadioButton();
        this.myPageSelectionAllButton.setText(WidgetResources.getString("PrintDialog.SelectAll"));
        this.myPageSelectionAllButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.SelectionAllMnemonic"));
        selectionPanel.add(this.myPageSelectionAllButton);
        selectionPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.myPageSelectionCurrentButton = new JRadioButton();
        this.myPageSelectionCurrentButton.setText(WidgetResources.getString("PrintDialog.CurrentPage"));
        this.myPageSelectionCurrentButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.SelectionCurrentMnemonic"));
        selectionPanel.add(this.myPageSelectionCurrentButton);
        selectionPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.myPageSelectionPagesButton = new JRadioButton();
        this.myPageSelectionPagesButton.setText(WidgetResources.getString("PrintDialog.Pages"));
        this.myPageSelectionPagesButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.SelectionPagesMnemonic"));
        selectionPanel.add(this.myPageSelectionPagesButton);
        this.myPageSelectionPagesField = new PTextField();
        this.myPageSelectionPagesField.setColumns(10);
        selectionPanel.add(this.myPageSelectionPagesField);
        ButtonGroup pageSelectionButtons = new ButtonGroup();
        pageSelectionButtons.add(this.myPageSelectionAllButton);
        pageSelectionButtons.add(this.myPageSelectionCurrentButton);
        pageSelectionButtons.add(this.myPageSelectionPagesButton);
        JPanel copiesPanel = new JPanel();
        GridBagLayout cGb = new GridBagLayout();
        copiesPanel.setLayout(cGb);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.set(1, 12, 1, 3);
        c.fill = 1;
        PLabel copiesLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.NumberOfCopiesLabel"));
        c.gridwidth = 2;
        cGb.setConstraints(copiesLabel, c);
        copiesPanel.add(copiesLabel);
        this.myNumberOfCopiesSpinner = new PSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        copiesLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.CopiesMnemonic"));
        copiesLabel.setLabelFor(this.myNumberOfCopiesSpinner);
        c.insets.set(1, 9, 1, 3);
        c.gridwidth = 0;
        cGb.setConstraints(this.myNumberOfCopiesSpinner, c);
        copiesPanel.add(this.myNumberOfCopiesSpinner);
        this.myCollateCheckBox = new JCheckBox();
        this.myCollateCheckBox.setText(WidgetResources.getString("PrintDialog.CollateLabel"));
        this.myCollateCheckBox.setMnemonic(WidgetResources.getMnemonic("PrintDialog.CollateMnemonic"));
        c.gridwidth = 0;
        c.insets.set(1, 92, 1, 3);
        cGb.setConstraints(this.myCollateCheckBox, c);
        copiesPanel.add(this.myCollateCheckBox);
        JPanel helpLabelPanel = new JPanel();
        PVerticalLayout helpPanelLayout = new PVerticalLayout(0);
        helpPanelLayout.setVgap(0);
        helpPanelLayout.setVMargin(0);
        helpLabelPanel.setLayout(helpPanelLayout);
        helpLabelPanel.add(PLabel.createSystemText(WidgetResources.getString("PrintDialog.PageSelectionInstructions")));
        wholePanel.add(generalPanel);
        wholePanel.add(PLabel.createTitle(WidgetResources.getString("PrintDialog.PageSelectionTitle")));
        wholePanel.add(selectionPanel);
        wholePanel.add(helpLabelPanel);
        wholePanel.add(PLabel.createTitle(WidgetResources.getString("PrintDialog.CopiesTitle")));
        wholePanel.add(copiesPanel);
        return wholePanel;
    }

    private JPanel createPagePanel() {
        JPanel wholePanel = new JPanel(new PVerticalLayout());
        PVerticalLayout wholeLayout = new PVerticalLayout(0);
        wholeLayout.setVgap(7);
        wholePanel.setLayout(wholeLayout);
        JPanel mediaPanel = new JPanel();
        PMatrixLayout mediaLayout = new PMatrixLayout(3, 12, 6, 3, 3);
        mediaLayout.setComponentVerticalAlignment(2);
        mediaPanel.setLayout(mediaLayout);
        mediaPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        PLabel sourceLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.MediaSizeLabel"));
        mediaPanel.add(sourceLabel);
        this.myPaperSizeComboBox = new PComboBox();
        this.myPaperSizeComboBox.setPrototypeDisplayValue("###########################");
        sourceLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.PaperSizeMnemonic"));
        sourceLabel.setLabelFor(this.myPaperSizeComboBox);
        mediaPanel.add(this.myPaperSizeComboBox);
        mediaPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        PLabel sizeLabel = PLabel.createSystemText(WidgetResources.getString("PrintDialog.MediaSourceLabel"));
        mediaPanel.add(sizeLabel);
        this.myPaperSourceComboBox = new PComboBox();
        this.myPaperSourceComboBox.setPrototypeDisplayValue("###########################");
        sizeLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.PaperSourceMnemonic"));
        sizeLabel.setLabelFor(this.myPaperSourceComboBox);
        mediaPanel.add(this.myPaperSourceComboBox);
        JPanel orientationPanel = new JPanel();
        PMatrixLayout orientationLayout = new PMatrixLayout(2);
        orientationLayout.setVMargin(0);
        orientationLayout.setVgap(2);
        orientationPanel.setLayout(orientationLayout);
        orientationPanel.add(new JLabel(CommonIcons.getPrintPortraitIcon()));
        this.myPortraitButton = new JRadioButton();
        this.myPortraitButton.setText(WidgetResources.getString("PrintDialog.OrientationPortrait"));
        this.myPortraitButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.PortraitMnemonic"));
        orientationPanel.add(this.myPortraitButton);
        orientationPanel.add(new JLabel(CommonIcons.getPrintLandscapeIcon()));
        this.myLandscapeButton = new JRadioButton();
        this.myLandscapeButton.setText(WidgetResources.getString("PrintDialog.OrientationLandscape"));
        this.myLandscapeButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.LandscapeMnemonic"));
        orientationPanel.add(this.myLandscapeButton);
        ButtonGroup orientationButtons = new ButtonGroup();
        orientationButtons.add(this.myPortraitButton);
        orientationButtons.add(this.myLandscapeButton);
        JPanel marginsPanel = new JPanel(new PMatrixLayout(8, 12, 6, 3, 3));
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myTopMarginSpinner = new PSpinner(new SpinnerNumberModel(25.0, 0.0, 5000.0, 0.1));
        PLabel topLabel = PLabel.createLabel(WidgetResources.getString("PrintDialog.MarginsTop"));
        topLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.TopMnemonic"));
        topLabel.setLabelFor(this.myTopMarginSpinner);
        marginsPanel.add(topLabel);
        marginsPanel.add(this.myTopMarginSpinner);
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myBottomMarginSpinner = new PSpinner(new SpinnerNumberModel(25.0, 0.0, 5000.0, 0.1));
        PLabel bottomLabel = PLabel.createLabel(WidgetResources.getString("PrintDialog.MarginsBottom"));
        bottomLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.BottomMnemonic"));
        bottomLabel.setLabelFor(this.myBottomMarginSpinner);
        marginsPanel.add(bottomLabel);
        marginsPanel.add(this.myBottomMarginSpinner);
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myMillimeterButton = new JRadioButton();
        this.myMillimeterButton.setText(WidgetResources.getString("PrintDialog.MarginsMillimeters"));
        this.myMillimeterButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.MillimeterMnemonic"));
        marginsPanel.add(this.myMillimeterButton);
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myLeftMarginSpinner = new PSpinner(new SpinnerNumberModel(25.0, 0.0, 5000.0, 0.1));
        PLabel leftLabel = PLabel.createLabel(WidgetResources.getString("PrintDialog.MarginsLeft"));
        leftLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.LeftMnemonic"));
        leftLabel.setLabelFor(this.myLeftMarginSpinner);
        marginsPanel.add(leftLabel);
        marginsPanel.add(this.myLeftMarginSpinner);
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myRightMarginSpinner = new PSpinner(new SpinnerNumberModel(25.0, 0.0, 5000.0, 0.1));
        PLabel rightLabel = PLabel.createLabel(WidgetResources.getString("PrintDialog.MarginsRight"));
        rightLabel.setDisplayedMnemonic(WidgetResources.getMnemonic("PrintDialog.RightMnemonic"));
        rightLabel.setLabelFor(this.myRightMarginSpinner);
        marginsPanel.add(rightLabel);
        marginsPanel.add(this.myRightMarginSpinner);
        marginsPanel.add(Box.createRigidArea(new Dimension(1, 0)));
        this.myInchesButton = new JRadioButton();
        this.myInchesButton.setText(WidgetResources.getString("PrintDialog.MarginsInches"));
        this.myInchesButton.setMnemonic(WidgetResources.getMnemonic("PrintDialog.InchesMnemonic"));
        marginsPanel.add(this.myInchesButton);
        ButtonGroup measureButtons = new ButtonGroup();
        measureButtons.add(this.myMillimeterButton);
        measureButtons.add(this.myInchesButton);
        wholePanel.add(PLabel.createTitle(WidgetResources.getString("PrintDialog.MediaTitle")));
        wholePanel.add(mediaPanel);
        wholePanel.add(PLabel.createTitle(WidgetResources.getString("PrintDialog.OrientationTitle")));
        wholePanel.add(orientationPanel);
        wholePanel.add(PLabel.createTitle(WidgetResources.getString("PrintDialog.MarginsTitle")));
        wholePanel.add(marginsPanel);
        return wholePanel;
    }

    private JPanel createButtonPanel() {
        this.myPrintButton = new PButton(WidgetResources.getString("PrintDialog.PrintButtonText"));
        this.myPrintButton.setDefaultButton(true);
        this.myPrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintDialog.this.startPrinting();
            }
        });
        this.myCancelButton = new JButton(WidgetResources.getString("CancelAction_Text"));
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintDialog.this.dispose();
            }
        });
        this.myHelpButton = new PHelpButton();
        PButtonPane buttonPanel = new PButtonPane();
        buttonPanel.add(this.myPrintButton);
        buttonPanel.add(this.myCancelButton);
        buttonPanel.add(this.myHelpButton);
        return buttonPanel;
    }

    private void setListeners() {
        this.myPrinterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintDialog.this.updatePrinterValues();
            }
        });
        this.myPageSelectionPagesButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PrintDialog.this.myPageSelectionPagesField.setEnabled(PrintDialog.this.myPageSelectionPagesButton.isSelected());
            }
        });
        this.myMillimeterButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PrintDialog.this.updateMargins();
            }
        });
        this.myNumberOfCopiesSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PrintDialog.this.myCollateCheckBox.setEnabled((Integer)PrintDialog.this.myNumberOfCopiesSpinner.getValue() > 1);
            }
        });
    }

    private void setDefaultUiValues() {
        this.myMillimeterButton.setSelected(true);
        this.myPageSelectionAllButton.setSelected(true);
        this.myPortraitButton.setSelected(true);
        this.myLeftMarginSpinner.setValue(25.0);
        this.myTopMarginSpinner.setValue(25.0);
        this.myBottomMarginSpinner.setValue(25.0);
        this.myRightMarginSpinner.setValue(25.0);
        this.myNumberOfCopiesSpinner.setValue(1);
        this.myPageSelectionPagesField.setEnabled(false);
        this.myCollateCheckBox.setSelected(true);
        this.myCollateCheckBox.setEnabled(false);
        this.updatePrinterValues();
    }

    private void updatePrinterValues() {
        SwingWorker<List<String>> printerUpdater = new SwingWorker<List<String>>(){

            @Override
            protected List<String> construct() {
                ArrayList<String> printerInformation = new ArrayList<String>();
                printerInformation.add(PrintDialog.this.myPrintModel.getPrinterStatus(PrintDialog.this.getSelectedPrinter()));
                printerInformation.add(PrintDialog.this.myPrintModel.getPrinterModel(PrintDialog.this.getSelectedPrinter()));
                printerInformation.add(PrintDialog.this.myPrintModel.getPrinterLocation(PrintDialog.this.getSelectedPrinter()));
                printerInformation.add(PrintDialog.this.myPrintModel.getPrinterComment(PrintDialog.this.getSelectedPrinter()));
                return printerInformation;
            }

            @Override
            protected void finished() {
                try {
                    PrintDialog.this.updatePrinterInformation((List)this.get());
                }
                catch (Exception e) {
                    PrintDialog.this.setPrinterDefaultInformation();
                }
            }
        };
        printerUpdater.start();
        SwingWorker<List<Media>> paperSourceUpdater = new SwingWorker<List<Media>>(){

            @Override
            protected List<Media> construct() {
                return Arrays.asList(PrintDialog.this.myPrintModel.getSupportedPaperSources(PrintDialog.this.getSelectedPrinter()));
            }

            @Override
            protected void finished() {
                try {
                    PrintDialog.this.updatePaperSources((List)this.get());
                }
                catch (Exception e) {
                    PrintDialog.this.updatePaperSources(Collections.emptyList());
                }
            }
        };
        paperSourceUpdater.start();
        SwingWorker<List<Media>> paperSizeUpdater = new SwingWorker<List<Media>>(){

            @Override
            protected List<Media> construct() {
                return Arrays.asList(PrintDialog.this.myPrintModel.getSupportedPaperSizes(PrintDialog.this.getSelectedPrinter()));
            }

            @Override
            protected void finished() {
                try {
                    PrintDialog.this.updatePaperSizes((List)this.get());
                }
                catch (Exception e) {
                    PrintDialog.this.updatePaperSources(Collections.emptyList());
                }
            }
        };
        paperSizeUpdater.start();
    }

    private void updatePaperSizes(List<Media> paperSizes) {
        this.myPaperSizeComboBox.removeAllItems();
        for (Media media : paperSizes) {
            this.myPaperSizeComboBox.addItem(media);
        }
        this.myPaperSourceComboBox.setEnabled(!paperSizes.isEmpty());
    }

    private void updatePaperSources(List<Media> paperSources) {
        this.myPaperSourceComboBox.removeAllItems();
        for (Media media : paperSources) {
            this.myPaperSourceComboBox.addItem(media);
        }
        this.myPaperSourceComboBox.setEnabled(!paperSources.isEmpty());
    }

    private void updatePrinterNames() {
        String[] stringArray = this.myPrintModel.getPrintServiceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String printerName = stringArray[n2];
            this.myPrinterComboBox.addItem(printerName);
            ++n2;
        }
    }

    private void updatePrinterInformation(List<String> printerInformation) {
        this.myPrinterStatusLabel.setText(printerInformation.get(0));
        this.myPrinterTypeLabel.setText(printerInformation.get(1));
        this.myPrinterLocationLabel.setText(printerInformation.get(2));
        this.myPrinterCommentLabel.setText(printerInformation.get(3));
    }

    private void setPrinterDefaultInformation() {
        this.updatePrinterInformation(Arrays.asList(WidgetResources.getString("PrintDialog.StatusNotAvailable"), WidgetResources.getString("PrintDialog.TypeNotAvailable"), WidgetResources.getString("PrintDialog.LocationNotAvailable"), WidgetResources.getString("PrintDialog.CommentNotAvailable")));
    }

    private PrintService getSelectedPrinter() {
        return this.myPrintModel.getPrintService(this.myPrinterComboBox.getSelectedIndex());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startPrinting() {
        this.myPrintModel.setCopyCount((Integer)this.myNumberOfCopiesSpinner.getValue());
        this.myPrintModel.setLandscape(this.myLandscapeButton.isSelected());
        this.myPrintModel.setMillimeters(this.myMillimeterButton.isSelected());
        this.myPrintModel.setPaperSize((MediaSizeName)this.myPaperSizeComboBox.getSelectedItem());
        this.myPrintModel.setPaperSource((Media)this.myPaperSourceComboBox.getSelectedItem());
        this.myPrintModel.setMargins((Double)this.myLeftMarginSpinner.getValue(), (Double)this.myRightMarginSpinner.getValue(), (Double)this.myTopMarginSpinner.getValue(), (Double)this.myBottomMarginSpinner.getValue());
        this.myPrintModel.setCollate(this.myCollateCheckBox.isSelected());
        if (this.myPrintToFileCheckBox.isSelected()) {
            JFileChooser fileChooser = new JFileChooser();
            if (fileChooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(".ps") && !file.getAbsolutePath().endsWith(".prn")) {
                File extensionAddedFile = new File(String.valueOf(file.getAbsolutePath()) + ".prn");
                this.myPrintModel.setPrintToFile(extensionAddedFile.toURI());
            } else {
                this.myPrintModel.setPrintToFile(file.toURI());
            }
        } else {
            this.myPrintModel.setPrintToFile(null);
        }
        if (this.myPageSelectionPagesButton.isSelected()) {
            if (!this.isPageRangeValid()) {
                JOptionPane.showMessageDialog(null, new String[]{WidgetResources.getString("PrintDialog.PageRangeErrorTitle"), WidgetResources.getString("PrintDialog.PageRangeErrorMessage")}, WidgetResources.getString("PrintDialog.ErrorDialogTitle"), 0);
                return;
            }
            this.myPrintModel.setPageRange(this.getParsedPageRange());
        } else if (this.myPageSelectionCurrentButton.isSelected() && this.myCurrentPage != 0) {
            this.myPrintModel.setPageRange(new PageRanges(this.myCurrentPage));
        }
        try {
            this.myPrintModel.print(this.getSelectedPrinter());
        }
        catch (PrintException e) {
            JOptionPane.showMessageDialog(null, new String[]{WidgetResources.getString("PrintDialog.ErrorDialogMessage"), e.getMessage()}, WidgetResources.getString("PrintDialog.ErrorDialogTitle"), 0);
            return;
        }
        this.dispose();
    }

    private void updateMargins() {
        double leftMarginValue = (Double)this.myLeftMarginSpinner.getValue();
        double rightMarginValue = (Double)this.myRightMarginSpinner.getValue();
        double topMarginValue = (Double)this.myTopMarginSpinner.getValue();
        double bottomMarginValue = (Double)this.myBottomMarginSpinner.getValue();
        if (!this.myMillimeterButton.isSelected()) {
            this.myLeftMarginSpinner.setValue(leftMarginValue / 25.0);
            this.myRightMarginSpinner.setValue(rightMarginValue / 25.0);
            this.myTopMarginSpinner.setValue(topMarginValue / 25.0);
            this.myBottomMarginSpinner.setValue(bottomMarginValue / 25.0);
        } else {
            this.myLeftMarginSpinner.setValue(leftMarginValue * 25.0);
            this.myRightMarginSpinner.setValue(rightMarginValue * 25.0);
            this.myTopMarginSpinner.setValue(topMarginValue * 25.0);
            this.myBottomMarginSpinner.setValue(bottomMarginValue * 25.0);
        }
    }

    private PageRanges getParsedPageRange() {
        return new PageRanges(this.myPageSelectionPagesField.getText());
    }

    private boolean isPageRangeValid() {
        if (this.myPageSelectionPagesField.isEnabled() && this.myPageSelectionPagesField.getText().length() != 0) {
            String pagesString = this.myPageSelectionPagesField.getText().trim();
            int i = 0;
            while (i < pagesString.length()) {
                char token = pagesString.charAt(i);
                if (!Character.isDigit(token) && token != '-' && token != ',') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

