/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.print;

import com.nokia.widgets.util.WidgetResources;
import java.awt.print.Printable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.SheetCollate;

public class PrintModel {
    private static final double INCH_IN_MILLIMETERS = 25.0;
    private double myLeftMargin;
    private double myRightMargin;
    private double myTopMargin;
    private double myBottomMargin;
    private OrientationRequested myOrientation;
    private List<PrintService> myPrintServices;
    private MediaSizeName myPaperSize;
    private Media myPaperSource;
    private Printable myPrintable;
    private PageRanges myPageRanges;
    private int myCopyCount;
    private boolean myUsingMillimeters;
    private boolean myCollated;
    private URI myPrintFile;

    public PrintModel(Printable printable) {
        this.myPrintable = printable;
        this.updatePrintServices();
        this.setDefaults();
    }

    private void setDefaults() {
        this.myCopyCount = 1;
        this.myOrientation = OrientationRequested.PORTRAIT;
        this.myCollated = false;
    }

    public void setMargins(double leftMargin, double rightMargin, double topMargin, double bottomMargin) {
        this.myLeftMargin = leftMargin;
        this.myRightMargin = rightMargin;
        this.myTopMargin = topMargin;
        this.myBottomMargin = bottomMargin;
    }

    public void setCopyCount(int copyCount) {
        this.myCopyCount = copyCount;
    }

    public PrintService getPrintService(int selectedIndex) {
        if (selectedIndex >= 0 && selectedIndex < this.myPrintServices.size()) {
            return this.myPrintServices.get(selectedIndex);
        }
        return null;
    }

    public List<PrintService> getPrintServices() {
        return this.myPrintServices;
    }

    public String[] getPrintServiceNames() {
        String[] printerNames = new String[this.myPrintServices.size()];
        int i = 0;
        while (i < this.myPrintServices.size()) {
            printerNames[i] = this.myPrintServices.get(i).getName();
            ++i;
        }
        return printerNames;
    }

    public Media[] getSupportedPaperSizes(PrintService printService) {
        return this.getSupportedMedia(printService, MediaSizeName.class);
    }

    public Media[] getSupportedPaperSources(PrintService printService) {
        return this.getSupportedMedia(printService, MediaTray.class);
    }

    public String getPrinterStatus(PrintService printer) {
        PrinterIsAcceptingJobs attr;
        if (printer != null && (attr = printer.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
            if (attr.equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) {
                return WidgetResources.getString("PrintDialog.StatusAccepting");
            }
            return ((Object)attr).toString();
        }
        return WidgetResources.getString("PrintDialog.StatusNotAvailable");
    }

    public String getPrinterLocation(PrintService printer) {
        PrinterLocation attr;
        if (printer != null && (attr = printer.getAttribute(PrinterLocation.class)) != null) {
            return ((Object)attr).toString();
        }
        return WidgetResources.getString("PrintDialog.LocationNotAvailable");
    }

    public String getPrinterModel(PrintService printer) {
        PrinterMakeAndModel attr;
        if (printer != null && (attr = printer.getAttribute(PrinterMakeAndModel.class)) != null) {
            return ((Object)attr).toString();
        }
        return WidgetResources.getString("PrintDialog.TypeNotAvailable");
    }

    public String getPrinterComment(PrintService printer) {
        PrinterMessageFromOperator attr;
        if (printer != null && (attr = printer.getAttribute(PrinterMessageFromOperator.class)) != null) {
            return ((Object)attr).toString();
        }
        return WidgetResources.getString("PrintDialog.CommentNotAvailable");
    }

    public void setPaperSize(MediaSizeName paperSizeName) {
        this.myPaperSize = paperSizeName;
    }

    public void setPaperSource(Media paperSource) {
        this.myPaperSource = paperSource;
    }

    public void setPageRange(PageRanges pageRanges) {
        this.myPageRanges = pageRanges;
    }

    public void setLandscape(boolean landscapeOn) {
        this.myOrientation = landscapeOn ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT;
    }

    public void setMillimeters(boolean millimetersOn) {
        this.myUsingMillimeters = millimetersOn;
    }

    public void setCollate(boolean collateOn) {
        this.myCollated = collateOn;
    }

    public void setPrintToFile(URI printFile) {
        this.myPrintFile = printFile;
    }

    public void print(PrintService printer) throws PrintException {
        if (printer != null) {
            this.convertMargins();
            SimpleDoc printDoc = new SimpleDoc(this.myPrintable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
            DocPrintJob printJob = printer.createPrintJob();
            printJob.print(printDoc, this.createPrintRequestAttributes());
        }
    }

    private Media[] getSupportedMedia(PrintService printService, Class mediaClass) {
        ArrayList<Media> result = new ArrayList<Media>();
        if (printService != null) {
            Media[] mediaTypes;
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            Media[] mediaArray = mediaTypes = (Media[])printService.getSupportedAttributeValues(Media.class, flavor, null);
            int n = mediaTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Media media = mediaArray[n2];
                if (mediaClass.isAssignableFrom(media.getClass())) {
                    result.add(media);
                }
                ++n2;
            }
        }
        return result.toArray(new Media[result.size()]);
    }

    private void updatePrintServices() {
        this.myPrintServices = Arrays.asList(PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashPrintRequestAttributeSet()));
    }

    private PrintRequestAttributeSet createPrintRequestAttributes() {
        HashPrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
        printAttributes.add(this.myPaperSize != null ? this.myPaperSize : MediaSizeName.ISO_A4);
        if (this.myPaperSource != null) {
            printAttributes.add(this.myPaperSource);
        }
        printAttributes.add(new Copies(this.myCopyCount));
        if (this.myPageRanges != null) {
            printAttributes.add(this.myPageRanges);
        }
        printAttributes.add(this.myOrientation);
        printAttributes.add(this.createPrintableArea());
        printAttributes.add(this.myCollated ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED);
        printAttributes.add(MultipleDocumentHandling.SINGLE_DOCUMENT);
        if (this.myPrintFile != null) {
            printAttributes.add(new Destination(this.myPrintFile));
        }
        return printAttributes;
    }

    private MediaPrintableArea createPrintableArea() {
        MediaSize mediaSize = this.myPaperSize != null ? MediaSize.getMediaSizeForName(this.myPaperSize) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        float[] maxSize = mediaSize.getSize(25400);
        float x = (float)this.myLeftMargin;
        float y = (float)this.myRightMargin;
        float width = maxSize[0] - (float)this.myRightMargin - x;
        float height = maxSize[1] - (float)this.myBottomMargin - y;
        if (width <= 0.0f) {
            width = 0.1f;
        }
        if (height <= 0.0f) {
            height = 0.1f;
        }
        MediaPrintableArea area = new MediaPrintableArea(x, y, width, height, 25400);
        return area;
    }

    private void convertMargins() {
        if (this.myUsingMillimeters) {
            this.myRightMargin /= 25.0;
            this.myLeftMargin /= 25.0;
            this.myTopMargin /= 25.0;
            this.myBottomMargin /= 25.0;
        }
    }
}

