/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress;

import com.nokia.widgets.progress.ProgressSource;
import com.nokia.widgets.progress.models.ProgressModel;
import com.nokia.widgets.progress.views.AbstractProgressUI;
import com.nokia.widgets.progress.views.GuiListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ProgressController
implements GuiListener {
    protected ProgressModel myModel;
    protected AbstractProgressUI myView;
    protected List mySources = new ArrayList();
    protected Action myCancelAction = new CancelAction();
    protected Action myStartAction = new StartAction();
    protected Action myStopAction = new StopAction();

    public void start(boolean startProgress) {
        if (this.myModel.getProgressState() == 0) {
            return;
        }
        this.myModel.startElapsedTimeTimer();
        if (startProgress) {
            this.myModel.setProgressState(0);
        }
    }

    public void start() {
        this.start(true);
    }

    public void stop() {
        this.myModel.setProgressState(1);
        this.myModel.stopElapsedTimeTimer();
    }

    public void fail() {
        this.myModel.setProgressState(3);
        this.myModel.stopElapsedTimeTimer();
    }

    public void destroy() {
        this.myView.destroy();
        this.myView.removeGuiListener(this);
    }

    public boolean isStarted() {
        return this.myModel.getProgressState() == 0;
    }

    public void addSource(ProgressSource source) {
        this.mySources.add(source);
    }

    public void removeSource(ProgressSource source) {
        this.mySources.remove(source);
    }

    public void setModel(ProgressModel model) {
        this.myModel = model;
        if (this.myView != null) {
            this.myView.setModel(this.myModel);
        }
    }

    public ProgressModel getModel() {
        return this.myModel;
    }

    public void setView(AbstractProgressUI view) {
        this.myView = view;
        this.myView.addGuiListener(this);
        if (this.myModel != null) {
            this.myView.setModel(this.myModel);
        }
    }

    public AbstractProgressUI getView() {
        return this.myView;
    }

    @Override
    public void guiUpdated(ProgressGuiEvent event) {
        if (event.getID().equals("cancelaction")) {
            this.myCancelAction.actionPerformed(new ActionEvent(this.myView, 0, "cancelaction"));
        } else if (event.getID().equals("startaction")) {
            this.myStartAction.actionPerformed(new ActionEvent(this.myView, 1, "startaction"));
        } else if (event.getID().equals("stopaction")) {
            this.myStopAction.actionPerformed(new ActionEvent(this.myView, 2, "stopaction"));
        }
    }

    protected void handleStop() {
        this.stop();
        Iterator it = this.mySources.iterator();
        while (it.hasNext()) {
            ((ProgressSource)it.next()).stop();
        }
        boolean restartOK = true;
        it = this.mySources.iterator();
        while (it.hasNext()) {
            restartOK = ((ProgressSource)it.next()).canBeRestarted();
            if (!restartOK) break;
        }
        if (restartOK) {
            this.myModel.setCurrentAction("startaction");
        } else {
            this.myModel.setActionButtonEnabled(false);
        }
    }

    protected void handleStart() {
        Iterator it = this.mySources.iterator();
        while (it.hasNext()) {
            ((ProgressSource)it.next()).start();
        }
        this.start();
        this.myModel.setCurrentAction("stopaction");
    }

    protected void handleCancel() {
        boolean cancelOK = this.requestCancel();
        if (cancelOK) {
            this.myModel.cancelProgress();
            Iterator it = this.mySources.iterator();
            while (it.hasNext()) {
                ((ProgressSource)it.next()).cancel();
            }
        }
    }

    protected boolean requestCancel() {
        boolean cancelOK = true;
        Iterator it = this.mySources.iterator();
        while (it.hasNext()) {
            if (((ProgressSource)it.next()).canBeCancelled()) continue;
            cancelOK = false;
            break;
        }
        return cancelOK;
    }

    public Action getCancelAction() {
        return this.myCancelAction;
    }

    public Action getStartAction() {
        return this.myStartAction;
    }

    public Action getStopAction() {
        return this.myStopAction;
    }

    public List getSources() {
        return this.mySources;
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressController.this.handleCancel();
        }
    }

    protected class StartAction
    extends AbstractAction {
        private static final long serialVersionUID = -4518372576402677182L;

        protected StartAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressController.this.handleStart();
        }
    }

    protected class StopAction
    extends AbstractAction {
        private static final long serialVersionUID = 5360156452895168929L;

        protected StopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressController.this.handleStop();
        }
    }
}

