/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress;

import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.ProgressSource;
import com.nokia.widgets.progress.models.ProgressDialogModel;
import com.nokia.widgets.progress.models.ProgressModel;
import com.nokia.widgets.progress.views.AbstractProgressDialog;
import com.nokia.widgets.progress.views.AbstractProgressUI;
import com.nokia.widgets.progress.views.GuiListener;
import com.nokia.widgets.progress.views.ProgressDialogCloseListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import java.awt.EventQueue;
import java.util.Observable;
import java.util.Observer;

public class ProgressDialogController
implements GuiListener,
Observer {
    protected ProgressDialogModel myModel;
    protected AbstractProgressDialog myView;
    protected ProgressController myProgressController;
    protected int myPreviousProgressState = 1;
    protected ProgressDialogCloseListener myCloseListener;

    public ProgressDialogController(ProgressController progressController) {
        this.myProgressController = progressController;
        this.myProgressController.addSource(new ProgressSourceImpl());
    }

    public ProgressController getProgressController() {
        return this.myProgressController;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show(boolean startProgress) {
        if (!this.myProgressController.isStarted()) {
            this.synchronizeWithProgressControl();
            this.getProgressController().start(startProgress);
        }
        if (this.myModel.isBlocking()) {
            this.myView.setVisible(true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialogController.this.myView.setVisible(true);
                }
            });
        }
    }

    public void show() {
        this.show(true);
    }

    public void hide() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialogController.this.myView.setVisible(false);
            }
        });
    }

    public void destroy() {
        this.myProgressController.destroy();
        if (this.myView != null) {
            this.myView.destroy();
            this.myView.removeGuiListener(this);
            this.myView.dispose();
        }
    }

    public void setCloseListener(ProgressDialogCloseListener listener) {
        this.myCloseListener = listener;
    }

    public void setModel(ProgressDialogModel model) {
        this.myModel = model;
        this.myProgressController.getModel().addObserver(this);
        if (this.myView != null) {
            this.myView.setModel(this.myModel);
        }
    }

    public ProgressDialogModel getModel() {
        return this.myModel;
    }

    public void setView(AbstractProgressDialog view) {
        this.myView = view;
        this.myView.addGuiListener(this);
        if (this.myModel != null) {
            this.myView.setModel(this.myModel);
        }
        this.myProgressController.getModel().addObserver(this);
        this.myProgressController.getView().addGuiListener(this);
    }

    public AbstractProgressDialog getView() {
        return this.myView;
    }

    public ProgressModel getProgressControllerModel() {
        return this.myProgressController.getModel();
    }

    public void setProgressControllerModel(ProgressModel model) {
        this.myProgressController.setModel(model);
    }

    public AbstractProgressUI getProgressControllerView() {
        return this.myProgressController.getView();
    }

    public void setProgressControllerView(AbstractProgressUI view) {
        this.myProgressController.setView(view);
    }

    @Override
    public void guiUpdated(ProgressGuiEvent event) {
        if (event.getID().equals("dialogcloseaction")) {
            if (this.myCloseListener != null) {
                this.myCloseListener.closeRequest();
            } else if (this.myModel.isActionButtonVisible() && this.myModel.isActionButtonEnabled()) {
                this.destroy();
            }
        } else if (event.getID().equals("cancelaction")) {
            this.myProgressController.handleCancel();
        } else if (event.getID().equals("fulluirebuild")) {
            this.synchronizeWithProgressControl();
            this.myView.pack();
            this.myView.setDefaultLocation();
        }
    }

    protected void synchronizeWithProgressControl() {
        ProgressModel controlModel = this.getProgressController().getModel();
        if (controlModel.isActionButtonVisible() && "cancelaction".equals(controlModel.getCurrentAction())) {
            if ("cancelaction".equals(this.myModel.getCurrentAction())) {
                controlModel.setActionButtonVisible(false);
            } else {
                this.myModel.setActionButtonEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        ProgressDialogController progressDialogController = this;
        synchronized (progressDialogController) {
            ProgressModel controlModel = (ProgressModel)o;
            if (this.myPreviousProgressState == 0 && controlModel.getProgressState() == 1) {
                if (controlModel.isActionButtonVisible() && controlModel.isActionButtonEnabled()) {
                    controlModel.setActionButtonEnabled(false);
                }
                this.myModel.setActionButtonEnabled(true);
                if (this.myModel.getAutoCloseDelay() > 0) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(ProgressDialogController.this.myModel.getAutoCloseDelay());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressDialogController.this.guiUpdated(new ProgressGuiEvent("dialogcloseaction"));
                                }
                            });
                        }
                    }).start();
                }
            }
            this.myPreviousProgressState = controlModel.getProgressState();
        }
    }

    protected class ProgressSourceImpl
    implements ProgressSource {
        protected ProgressSourceImpl() {
        }

        @Override
        public void start() {
            ProgressDialogController.this.myModel.setActionButtonEnabled(false);
        }

        @Override
        public void stop() {
            ProgressDialogController.this.myModel.setActionButtonEnabled(true);
        }

        @Override
        public boolean canBeRestarted() {
            return true;
        }

        @Override
        public boolean canBeCancelled() {
            return true;
        }

        @Override
        public void cancel() {
            ProgressDialogController.this.myModel.setActionButtonEnabled(true);
        }
    }
}

