/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress;

import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.models.ProgressBarModel;
import com.nokia.widgets.progress.models.ProgressDialogModel;
import com.nokia.widgets.progress.models.StepProgressModel;
import com.nokia.widgets.progress.views.ProgressBarDialog;
import com.nokia.widgets.progress.views.ProgressBarUI;
import com.nokia.widgets.progress.views.StepProgressDialog;
import com.nokia.widgets.progress.views.StepProgressUI;
import java.awt.Window;

public class ProgressFactory {
    public static ProgressController createProgressBarControl(ProgressBarModel progressBarModel) {
        ProgressController controller = new ProgressController();
        controller.setModel(progressBarModel);
        ProgressBarUI view = new ProgressBarUI(controller);
        controller.setView(view);
        return controller;
    }

    public static ProgressController createProgressBarControl() {
        return ProgressFactory.createProgressBarControl(new ProgressBarModel());
    }

    public static ProgressController createIndeterminateProgressBarControl(ProgressBarModel progressBarModel) {
        progressBarModel.setProperty("animation", true);
        return ProgressFactory.createProgressBarControl(progressBarModel);
    }

    public static ProgressController createIndeterminateProgressBarControl() {
        return ProgressFactory.createIndeterminateProgressBarControl(new ProgressBarModel());
    }

    public static ProgressController createStepProgressControl() {
        return ProgressFactory.createStepProgressControl(new StepProgressModel());
    }

    public static ProgressController createStepProgressControl(StepProgressModel stepProgressModel) {
        ProgressController controller = new ProgressController();
        controller.setModel(stepProgressModel);
        StepProgressUI view = new StepProgressUI(controller);
        controller.setView(view);
        return controller;
    }

    public static ProgressDialogController createProgressBarDialog(Window parentWindow, ProgressDialogModel dialogModel) {
        return ProgressFactory.createProgressBarDialog(parentWindow, dialogModel, new ProgressBarModel());
    }

    public static ProgressDialogController createProgressBarDialog(Window parentWindow, ProgressDialogModel dialogModel, ProgressBarModel barModel) {
        ProgressController progressControl = ProgressFactory.createProgressBarControl(barModel);
        ProgressDialogController dialogController = new ProgressDialogController(progressControl);
        dialogController.setModel(dialogModel);
        ProgressBarDialog dialog = new ProgressBarDialog(parentWindow, dialogController);
        dialogController.setView(dialog);
        return dialogController;
    }

    public static ProgressDialogController createStepProgressDialog(Window parentWindow, ProgressDialogModel dialogModel, StepProgressModel stepProgressModel) {
        ProgressController progressControl = ProgressFactory.createStepProgressControl(stepProgressModel);
        ProgressDialogController dialogController = new ProgressDialogController(progressControl);
        dialogController.setModel(dialogModel);
        StepProgressDialog dialog = new StepProgressDialog(parentWindow, dialogController);
        dialogController.setView(dialog);
        return dialogController;
    }

    public static ProgressDialogController createStepProgressDialog(Window parentWindow, ProgressDialogModel dialogModel) {
        return ProgressFactory.createStepProgressDialog(parentWindow, dialogModel, new StepProgressModel());
    }

    public static ProgressDialogController createStepProgressDialog(Window parentWindow) {
        return ProgressFactory.createStepProgressDialog(parentWindow, new ProgressDialogModel());
    }

    public static ProgressDialogController createProgressBarDialog(Window parentWindow) {
        return ProgressFactory.createProgressBarDialog(parentWindow, new ProgressDialogModel());
    }

    public static ProgressDialogController createIndeterminatedProgressBarDialog(Window parentWindow, ProgressDialogModel dialogModel) {
        return ProgressFactory.createIndeterminatedProgressBarDialog(parentWindow, dialogModel, new ProgressBarModel());
    }

    public static ProgressDialogController createIndeterminatedProgressBarDialog(Window parentWindow, ProgressDialogModel dialogModel, ProgressBarModel barModel) {
        ProgressController progressControl = ProgressFactory.createIndeterminateProgressBarControl(barModel);
        ProgressDialogController dialogController = new ProgressDialogController(progressControl);
        dialogController.setModel(dialogModel);
        ProgressBarDialog dialog = new ProgressBarDialog(parentWindow, dialogController);
        dialogController.setView(dialog);
        return dialogController;
    }

    public static ProgressDialogController createIndeterminatedProgressBarDialog(Window parentWindow) {
        return ProgressFactory.createIndeterminatedProgressBarDialog(parentWindow, new ProgressDialogModel());
    }
}

