/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.models;

import com.nokia.widgets.progress.models.ProgressModel;
import java.awt.Image;
import javax.swing.ImageIcon;

public class ProgressBarModel
extends ProgressModel {
    public static final String DEFAULT_RIGHT_ICON_PATH = "/com/nokia/widgets/res/progress_pc_32_normal.png";
    public static final String DEFAULT_LEFT_ICON_PATH = "/com/nokia/widgets/res/progress_bts_32_normal.png";
    public static final String DEFAULT_DISABLED_RIGHT_ICON_PATH = "/com/nokia/widgets/res/progress_pc_32_diabled.png";
    public static final String DEFAULT_DISABLED_LEFT_ICON_PATH = "/com/nokia/widgets/res/progress_bts_32_diabled.png";
    public static final String MINIMUM_VALUE = "min";
    public static final String MAXIMUM_VALUE = "max";
    public static final String CURRENT_VALUE = "current";
    public static final String INDETERMINATED = "indeterminated";
    public static final String USE_INDETERMINATED_ANIMATION = "animation";
    public static final String LEFT_ICON = "lefticon";
    public static final String RIGHT_ICON = "righticon";
    public static final String LEFT_DISABLED_ICON = "disabledlefticon";
    public static final String RIGHT_DISABLED_ICON = "disabledrighticon";
    public static final String SHOW_PROGRESS_TEXT = "showprogresstext";
    public static final String PROGRESS_TEXT = "progresstext";
    public static final String STRING_PAINTED_ON_TRACK = "stringpaintedontrack";
    private boolean myEstimatedDurationSetByClient = false;

    @Override
    public void reset() {
        super.reset();
        this.myEstimatedDurationSetByClient = false;
        this.setProperty(MINIMUM_VALUE, 0);
        this.setProperty(MAXIMUM_VALUE, 100);
        this.setProperty(CURRENT_VALUE, 0);
        this.setProperty(INDETERMINATED, false);
        this.setProperty(USE_INDETERMINATED_ANIMATION, false);
        this.setProperty(PROGRESS_TEXT, "");
        this.setProperty(SHOW_PROGRESS_TEXT, true);
        this.setProperty(STRING_PAINTED_ON_TRACK, true);
    }

    @Override
    public void setProperty(String key, boolean value) {
        if ("showduration".equals(key)) {
            this.myEstimatedDurationSetByClient = true;
        }
        super.setProperty(key, value);
    }

    public boolean isEstimatedDurationSetByClient() {
        return this.myEstimatedDurationSetByClient;
    }

    public void setDefaultIcons() {
        this.setLeftIcon(new ImageIcon(this.getClass().getResource(DEFAULT_LEFT_ICON_PATH)).getImage());
        this.setRightIcon(new ImageIcon(this.getClass().getResource(DEFAULT_RIGHT_ICON_PATH)).getImage());
        this.setLeftDisabledIcon(new ImageIcon(this.getClass().getResource(DEFAULT_DISABLED_LEFT_ICON_PATH)).getImage());
        this.setRightDisabledIcon(new ImageIcon(this.getClass().getResource(DEFAULT_DISABLED_RIGHT_ICON_PATH)).getImage());
    }

    public void swapIcons() {
        Image tempLeftIcon = this.getLeftIcon();
        this.setLeftIcon(this.getRightIcon());
        this.setRightIcon(tempLeftIcon);
        Image tempDisabledLeftIcon = this.getLeftDisabledIcon();
        this.setLeftDisabledIcon(this.getRightDisabledIcon());
        this.setRightDisabledIcon(tempDisabledLeftIcon);
    }

    public int getMinimumValue() {
        return this.getIntProperty(MINIMUM_VALUE);
    }

    public void setMinimumValue(int value) {
        this.setProperty(MINIMUM_VALUE, value);
    }

    public int getMaximumValue() {
        return this.getIntProperty(MAXIMUM_VALUE);
    }

    public void setMaximumValue(int value) {
        this.setProperty(MAXIMUM_VALUE, value);
    }

    public int getCurrentValue() {
        return this.getIntProperty(CURRENT_VALUE);
    }

    public void setCurrentValue(int value) {
        this.setProperty(CURRENT_VALUE, value);
    }

    public boolean isIndeterminated() {
        return this.getBooleanProperty(INDETERMINATED);
    }

    public void setIndeterminated(boolean indeterminated) {
        this.setProperty(INDETERMINATED, indeterminated);
    }

    public boolean isIndeterminatedAnimationUsed() {
        return this.getBooleanProperty(USE_INDETERMINATED_ANIMATION);
    }

    public void setUseIndeterminatedAnimationFile(boolean useAnimation) {
        this.setProperty(USE_INDETERMINATED_ANIMATION, useAnimation);
    }

    public Image getLeftIcon() {
        return (Image)this.getProperty(LEFT_ICON);
    }

    public Image getLeftDisabledIcon() {
        return (Image)this.getProperty(LEFT_DISABLED_ICON);
    }

    public Image getRightDisabledIcon() {
        return (Image)this.getProperty(RIGHT_DISABLED_ICON);
    }

    public void setLeftIcon(Image icon) {
        this.setProperty(LEFT_ICON, icon);
    }

    public void setLeftDisabledIcon(Image icon) {
        this.setProperty(LEFT_DISABLED_ICON, icon);
    }

    public Image getRightIcon() {
        return (Image)this.getProperty(RIGHT_ICON);
    }

    public void setRightIcon(Image icon) {
        this.setProperty(RIGHT_ICON, icon);
    }

    public void setRightDisabledIcon(Image icon) {
        this.setProperty(RIGHT_DISABLED_ICON, icon);
    }

    public boolean isProgressTextVisible() {
        return this.getBooleanProperty(SHOW_PROGRESS_TEXT);
    }

    public void setProgressTextVisibile(boolean show) {
        this.setProperty(SHOW_PROGRESS_TEXT, show);
    }

    public String getProgressText() {
        return this.getStringProperty(PROGRESS_TEXT);
    }

    public void setProgressText(String progressText) {
        this.setProperty(PROGRESS_TEXT, progressText);
    }

    public boolean isStringPaintedOnTrack() {
        return this.getBooleanProperty(STRING_PAINTED_ON_TRACK);
    }

    public void setStringPaintedOnTrack(boolean progressTextOnTrack) {
        this.setProperty(STRING_PAINTED_ON_TRACK, progressTextOnTrack);
    }
}

