/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.models;

import com.nokia.widgets.progress.models.ModelBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class ProgressModel
extends ModelBase {
    public static final int ANIMATION_DIRECTION_FORWARD = 0;
    public static final int ANIMATION_DIRECTION_REVERSE = 1;
    public static final String PROGRESS_ACTION_CANCEL = "cancelaction";
    public static final String PROGRESS_ACTION_START = "startaction";
    public static final String PROGRESS_ACTION_STOP = "stopaction";
    public static final int ELAPSED_TIME_TIMER_DELAY = 500;
    public static final String SHOW_ESTIMATED_DURATION = "showduration";
    public static final String ESTIMATED_DURATION = "estimatedduration";
    public static final String SHOW_ACTION_BUTTON = "showaction";
    public static final String ACTION_BUTTON_ENABLED = "actionbuttonenabled";
    public static final String CURRENT_ACTION = "visibleaction";
    public static final String SHOW_TIME_FIELD = "timefieldvisible";
    public static final String ELAPSED_TIME = "elapsedtime";
    public static final String PROGRESS_STATE = "progresstate";
    public static final String PROGRESS_CANCELED = "progresscanceled";
    public static final String INDETERMINATED_ANIMATION_DIRECTION = "animationdirection";
    protected Timer myTimeUpdater;
    private long myOperationStartTime = -1L;

    public ProgressModel() {
        this.reset();
        this.myTimeUpdater = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long currentTime = System.currentTimeMillis();
                long elapsedTime = currentTime - ProgressModel.this.myOperationStartTime;
                ProgressModel.this.setElapsedTime((int)(elapsedTime / 1000L));
                ProgressModel.this.modelUpdated();
            }
        });
        this.myTimeUpdater.setDelay(500);
        this.myTimeUpdater.setRepeats(true);
    }

    public void reset() {
        this.setProperty(ACTION_BUTTON_ENABLED, true);
        this.setProperty(CURRENT_ACTION, PROGRESS_ACTION_CANCEL);
        this.setProperty(SHOW_ESTIMATED_DURATION, true);
        this.setProperty(ESTIMATED_DURATION, "");
        this.setProperty(SHOW_ACTION_BUTTON, true);
        this.setProperty(SHOW_TIME_FIELD, true);
        this.setProperty(ELAPSED_TIME, 0);
        this.setProperty(PROGRESS_STATE, 1);
        this.setProperty(PROGRESS_CANCELED, false);
        this.setProperty(INDETERMINATED_ANIMATION_DIRECTION, 0);
    }

    public void cancelProgress() {
        this.setProperty(PROGRESS_CANCELED, true);
        this.setActionButtonEnabled(false);
        this.setProgressState(1);
    }

    public boolean isCanceled() {
        return this.getBooleanProperty(PROGRESS_CANCELED);
    }

    public boolean isEstimatedDurationVisible() {
        return this.getBooleanProperty(SHOW_ESTIMATED_DURATION);
    }

    public String getEstimatedDuration() {
        return this.getStringProperty(ESTIMATED_DURATION);
    }

    public boolean isActionButtonVisible() {
        return this.getBooleanProperty(SHOW_ACTION_BUTTON);
    }

    public boolean isActionButtonEnabled() {
        return this.getBooleanProperty(ACTION_BUTTON_ENABLED);
    }

    public String getCurrentAction() {
        return this.getStringProperty(CURRENT_ACTION);
    }

    public boolean isTimeFieldVisible() {
        return this.getBooleanProperty(SHOW_TIME_FIELD);
    }

    public int getElapsedTime() {
        return this.getIntProperty(ELAPSED_TIME);
    }

    public void setEstimatedDurationVisible(boolean showEstimatedDuration) {
        this.setProperty(SHOW_ESTIMATED_DURATION, showEstimatedDuration);
    }

    public void setEstimatedDuration(String estimatedDuration) {
        this.setProperty(ESTIMATED_DURATION, estimatedDuration);
    }

    public void setActionButtonVisible(boolean showActionButton) {
        this.setProperty(SHOW_ACTION_BUTTON, showActionButton);
    }

    public void setActionButtonEnabled(boolean enabled) {
        this.setProperty(ACTION_BUTTON_ENABLED, enabled);
    }

    public void setCurrentAction(String currentAction) {
        this.setProperty(CURRENT_ACTION, currentAction);
    }

    public void setTimeFieldVisible(boolean showTimeField) {
        this.setProperty(SHOW_TIME_FIELD, showTimeField);
    }

    public void setElapsedTime(int elapsedTime) {
        this.setProperty(ELAPSED_TIME, elapsedTime);
    }

    public void setProgressState(int state) {
        this.setProperty(PROGRESS_STATE, state);
    }

    public int getProgressState() {
        return this.getIntProperty(PROGRESS_STATE);
    }

    public int getIndeterminatedAnimationDirection() {
        return this.getIntProperty(INDETERMINATED_ANIMATION_DIRECTION);
    }

    public void setIndeterminatedAnimationDirection(int direction) {
        this.setProperty(INDETERMINATED_ANIMATION_DIRECTION, direction);
    }

    public void startElapsedTimeTimer() {
        if (this.myTimeUpdater != null && !this.myTimeUpdater.isRunning()) {
            this.setElapsedTime(0);
            this.myOperationStartTime = System.currentTimeMillis();
            this.myTimeUpdater.start();
        }
    }

    public void stopElapsedTimeTimer() {
        if (this.myTimeUpdater != null && this.isTimerStarted()) {
            this.myTimeUpdater.stop();
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.myOperationStartTime;
            this.setElapsedTime((int)(elapsedTime / 1000L));
            this.modelUpdated();
        }
    }

    public boolean isTimerStarted() {
        return this.myTimeUpdater.isRunning();
    }
}

