/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.models;

import com.nokia.widgets.progress.models.ProgressModel;
import com.nokia.widgets.progress.models.StepProgressTask;
import java.util.ArrayList;
import java.util.List;

public class StepProgressModel
extends ProgressModel {
    public static final String USE_SCROLLING = "usescrolling";
    protected List<StepProgressTask> mySteps = new ArrayList<StepProgressTask>();
    protected int myCurrentStepIndex;

    @Override
    public void reset() {
        super.reset();
        if (this.mySteps != null) {
            this.mySteps.clear();
        }
        this.setUseScrolling(false);
        this.myCurrentStepIndex = -1;
        this.modelUpdated();
    }

    @Override
    public void cancelProgress() {
        super.cancelProgress();
        int i = 0;
        while (i < this.mySteps.size()) {
            StepProgressTask step = this.mySteps.get(i);
            step.setStatus(6);
            ++i;
        }
        this.setProgressState(1);
        this.modelUpdated();
    }

    public boolean isScrollingUsed() {
        return this.getBooleanProperty(USE_SCROLLING);
    }

    public void setUseScrolling(boolean value) {
        this.setProperty(USE_SCROLLING, value);
    }

    public void addStep(StepProgressTask step) {
        if (step.getParent() == null) {
            this.mySteps.add(step);
        } else {
            int lastChildIndex;
            int i = lastChildIndex = this.mySteps.indexOf(step.getParent()) + 1;
            while (i < this.mySteps.size()) {
                if (this.mySteps.get(i).getParent() == step.getParent()) {
                    ++lastChildIndex;
                }
                ++i;
            }
            this.mySteps.add(lastChildIndex, step);
        }
        this.modelUpdated();
    }

    public void addStep(StepProgressTask step, StepProgressTask parentStep) {
        step.setParent(parentStep);
        this.addStep(step);
    }

    public void addStep(StepProgressTask step, String parentStepId) {
        StepProgressTask parentStep = this.getStep(parentStepId);
        if (parentStep != null) {
            this.addStep(step, parentStep);
        }
    }

    public List<StepProgressTask> getAllSteps() {
        return new ArrayList<StepProgressTask>(this.mySteps);
    }

    public List<StepProgressTask> getVisibleSteps() {
        ArrayList<StepProgressTask> visibleTasks = new ArrayList<StepProgressTask>();
        for (StepProgressTask task : this.mySteps) {
            if (!task.isVisible()) continue;
            visibleTasks.add(task);
        }
        return visibleTasks;
    }

    public boolean hasChildrenTasks(String parentID) {
        boolean childrenFound = false;
        int i = 0;
        while (i < this.mySteps.size()) {
            StepProgressTask step = this.mySteps.get(i);
            if (step.getParent() == this.getStep(parentID)) {
                childrenFound = true;
                break;
            }
            ++i;
        }
        return childrenFound;
    }

    public boolean areChildrenTasksReady(String parentID) {
        boolean childrenReady = true;
        int i = 0;
        while (i < this.getChildrenTasks(parentID).size()) {
            StepProgressTask child = this.getChildrenTasks(parentID).get(i);
            if (child.getStatus() == 0 || child.getStatus() == 1) {
                childrenReady = false;
                break;
            }
            if (this.hasChildrenTasks(child.getID()) && !this.areChildrenTasksReady(child.getID())) {
                childrenReady = false;
                break;
            }
            ++i;
        }
        return childrenReady;
    }

    public void resetStepStatuses() {
        int i = 0;
        while (i < this.getAllSteps().size()) {
            StepProgressTask task = this.getAllSteps().get(i);
            task.setStatus(0);
            ++i;
        }
        this.myCurrentStepIndex = -1;
        this.modelUpdated();
    }

    public List<StepProgressTask> getChildrenTasks(String parentID) {
        ArrayList<StepProgressTask> children = new ArrayList<StepProgressTask>();
        int i = 0;
        while (i < this.mySteps.size()) {
            StepProgressTask task = this.mySteps.get(i);
            if (task.getParent() != null && task.getParent().getID().equals(parentID)) {
                children.add(task);
            }
            ++i;
        }
        return children;
    }

    public int getCorrectedStatus(StepProgressTask task) {
        if (task.getStatus() == 3) {
            int i = 0;
            while (i < this.mySteps.size()) {
                StepProgressTask aTask = this.mySteps.get(i);
                if (aTask.getParent() != null && aTask.getParent().getID().equals(task.getID()) && aTask.getStatus() == 4) {
                    return 5;
                }
                ++i;
            }
        }
        return task.getStatus();
    }

    public int getCurrentStepIndex() {
        return this.myCurrentStepIndex;
    }

    public StepProgressTask getCurrentStep() {
        if (this.myCurrentStepIndex >= 0 && this.myCurrentStepIndex < this.mySteps.size()) {
            return this.mySteps.get(this.myCurrentStepIndex);
        }
        return null;
    }

    public void setCurrentStepStatus(int status, boolean moveToNextStep) {
        if (this.isCanceled()) {
            return;
        }
        if (this.myCurrentStepIndex >= 0) {
            StepProgressTask currentStep = this.mySteps.get(this.myCurrentStepIndex);
            if (this.hasChildrenTasks(currentStep.getID()) || currentStep.getParent() != null) {
                int j = 0;
                while (j < this.getChildrenTasks(currentStep.getID()).size()) {
                    StepProgressTask child = this.getChildrenTasks(currentStep.getID()).get(j);
                    child.setStatus(status);
                    ++j;
                }
            }
            currentStep.setStatus(status);
        }
        this.startNewTask(moveToNextStep);
        this.modelUpdated();
    }

    public void setCurrentStepCancelled(boolean moveToNextStep) {
        this.setCurrentStepStatus(6, moveToNextStep);
    }

    public void setCurrentStepCompleted(boolean currentStepSucceeded, boolean moveToNextStep) {
        if (this.isCanceled()) {
            return;
        }
        StepProgressTask currentStep = this.getCurrentStep();
        if (currentStep != null) {
            if (this.hasChildrenTasks(currentStep.getID()) || currentStep.getParent() != null) {
                if (currentStep.isCollapsed()) {
                    currentStep.setStatus(1);
                } else {
                    currentStep.setStatus(currentStepSucceeded ? 2 : 4);
                }
                this.updateReadyTasks();
            } else {
                currentStep.setStatus(currentStepSucceeded ? 3 : 4);
            }
        }
        this.startNewTask(moveToNextStep);
        this.modelUpdated();
    }

    public void moveNext(boolean currentStepSucceeded) {
        this.setCurrentStepCompleted(currentStepSucceeded, true);
    }

    public void startStep(String stepID) {
        if (this.getStep(stepID) != null) {
            this.getStep(stepID).setStatus(1);
        }
        this.myCurrentStepIndex = this.getStepIndex(stepID);
        this.modelUpdated();
    }

    public void stopStep(String stepID, boolean stepSucceeded) {
        if (this.getStep(stepID) != null) {
            if (stepSucceeded) {
                this.getStep(stepID).setStatus(2);
                this.updateReadyTasks();
            } else {
                this.getStep(stepID).setStatus(4);
            }
        }
        this.modelUpdated();
    }

    public void cancelStep(String stepID) {
        if (this.getStep(stepID) != null) {
            this.getStep(stepID).setStatus(6);
        }
        this.modelUpdated();
    }

    public void resetStep(String stepID) {
        if (this.getStep(stepID) != null) {
            this.getStep(stepID).setStatus(0);
        }
        this.modelUpdated();
    }

    public void updateReadyTasks() {
        int i = 0;
        while (i < this.mySteps.size()) {
            StepProgressTask step = this.mySteps.get(i);
            if ((step.getStatus() == 2 || step.isCollapsed() && step.getStatus() == 1) && this.areChildrenTasksReady(step.getID())) {
                int j = 0;
                while (j < this.getChildrenTasks(step.getID()).size()) {
                    StepProgressTask child = this.getChildrenTasks(step.getID()).get(j);
                    if (child.getStatus() == 2) {
                        child.setStatus(3);
                    }
                    ++j;
                }
                step.setStatus(3);
            }
            ++i;
        }
    }

    public StepProgressTask getStep(String stepId) {
        StepProgressTask targetStep = null;
        int i = 0;
        while (i < this.mySteps.size()) {
            StepProgressTask step = this.mySteps.get(i);
            if (step.getID().equals(stepId)) {
                targetStep = step;
                break;
            }
            ++i;
        }
        return targetStep;
    }

    public int getStepIndex(String stepId) {
        int index = 0;
        while (index < this.mySteps.size()) {
            StepProgressTask step = this.mySteps.get(index);
            if (step.getID().equals(stepId)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setStepDescription(String stepID, String description) {
        StepProgressTask task = this.getStep(stepID);
        if (task != null) {
            task.setDescription(description);
        }
        this.modelUpdated();
    }

    public void expandStep(String stepID) {
        StepProgressTask step = this.getStep(stepID);
        if (step != null) {
            step.setCollapsed(false);
            this.setHierarchyVisibility(stepID, true);
        }
    }

    public void collapseStep(String stepID) {
        StepProgressTask step = this.getStep(stepID);
        if (step != null) {
            step.setCollapsed(true);
            this.setHierarchyVisibility(stepID, false);
            step.setVisible(true);
        }
    }

    protected void setHierarchyVisibility(String stepID, boolean visible) {
        StepProgressTask step = this.getStep(stepID);
        if (step != null) {
            step.setVisible(visible);
            int i = 0;
            while (i < this.getChildrenTasks(stepID).size()) {
                StepProgressTask child = this.getChildrenTasks(stepID).get(i);
                this.setHierarchyVisibility(child.getID(), visible);
                ++i;
            }
        }
    }

    protected void startNewTask(boolean moveToNextStep) {
        if (moveToNextStep && ++this.myCurrentStepIndex < this.mySteps.size()) {
            StepProgressTask currentStep = this.mySteps.get(this.myCurrentStepIndex);
            if (currentStep.getStatus() == 0) {
                currentStep.setStatus(1);
            }
            if (this.getProgressState() != 0) {
                this.setProgressState(0);
            }
        } else if (this.getProgressState() == 0) {
            this.setProgressState(1);
        }
    }
}

