/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.progress.views;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.models.ProgressDialogModel;
import com.nokia.widgets.progress.views.GuiListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import com.nokia.widgets.util.WidgetResources;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class AbstractProgressDialog
extends JDialog
implements Observer,
ActionListener {
    protected ProgressDialogModel myModel;
    protected ProgressDialogController myController;
    protected Set<GuiListener> myGuiListeners;
    protected JButton myActionButton;
    protected JLabel myHeading;
    private Window myParentWindow;

    public AbstractProgressDialog(Window parentWindow, ProgressDialogController progressDialogController) {
        super(parentWindow);
        this.myParentWindow = parentWindow;
        this.myController = progressDialogController;
        this.myGuiListeners = new LinkedHashSet<GuiListener>();
    }

    public void setModel(ProgressDialogModel model) {
        if (this.myModel != null) {
            if (!this.myModel.equals(model)) {
                return;
            }
            this.myModel.deleteObserver(this);
        }
        this.myModel = model;
        this.initUI();
        this.setDefaultLocation();
        this.myModel.addObserver(this);
    }

    public void setProgressWindowListener(WindowListener listener) {
        int i = 0;
        while (i < this.getWindowListeners().length) {
            this.removeWindowListener(this.getWindowListeners()[i]);
            ++i;
        }
        this.addWindowListener(listener);
    }

    public void destroy() {
        this.myGuiListeners.clear();
    }

    public void setDefaultLocation() {
        Rectangle parentBounds;
        if (this.myParentWindow != null && this.myParentWindow.isVisible()) {
            parentBounds = this.myParentWindow.getBounds();
        } else {
            Dimension screenSize = this.getToolkit().getScreenSize();
            parentBounds = new Rectangle(0, 0, screenSize.width, screenSize.height);
        }
        int x = parentBounds.width / 2 - this.getWidth() / 2;
        int y = parentBounds.height / 2 - this.getHeight() / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(parentBounds.x + x, parentBounds.y + y);
    }

    protected void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.myHeading = new JLabel();
        this.myHeading.setFont(UIManager.getFont("OptionPane.titleFont"));
        this.myHeading.setForeground(UIManager.getColor("OptionPane.headlineForeground"));
        this.myHeading.setText(this.myModel.getHeadingText());
        if (this.myModel.isActionButtonVisible()) {
            PPanel buttonPanel = new PPanel(new PButtonRowLayout());
            buttonPanel.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
            buttonPanel.setVisibleUpperEdge(true);
            this.myActionButton = new JButton();
            this.updateActionButtonText();
            this.myActionButton.addActionListener(this);
            buttonPanel.add(this.myActionButton);
            this.getContentPane().add((Component)buttonPanel, "South");
        }
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle(this.myModel.getTitle());
        this.setProgressWindowListener(new ProgressWindowListener());
        this.getToolkit().addAWTEventListener(new KeyEventListener(), 8L);
    }

    protected void updateActionButtonText() {
        String actionText = "";
        int actionMnemonic = 0;
        if ("dialogcloseaction".equals(this.myModel.getCurrentAction())) {
            actionText = WidgetResources.getString("CloseAction_Text");
        } else {
            actionText = WidgetResources.getString("CancelAction_Text");
            actionMnemonic = WidgetResources.getMnemonic("CancelAction_Mnemonic");
        }
        this.myActionButton.setText(actionText);
        this.myActionButton.setMnemonic(actionMnemonic);
    }

    public void addGuiListener(GuiListener listener) {
        this.myGuiListeners.add(listener);
    }

    public void removeGuiListener(GuiListener listener) {
        this.myGuiListeners.remove(listener);
    }

    @Override
    public void update(Observable o, Object arg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressDialog.this.updateUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myActionButton) {
            this.fireGuiEvent(new ProgressGuiEvent(this.myModel.getCurrentAction()));
        }
    }

    protected void fireGuiEvent(ProgressGuiEvent event) {
        Iterator<GuiListener> it = this.myGuiListeners.iterator();
        while (it.hasNext()) {
            it.next().guiUpdated(event);
        }
    }

    protected void updateUI() {
        this.setTitle(this.myModel.getTitle());
        this.myHeading.setText(this.myModel.getHeadingText());
        if (this.myModel.isActionButtonVisible()) {
            this.updateActionButtonText();
        }
        if (this.myModel.isActionButtonVisible()) {
            this.myActionButton.setEnabled(this.myModel.isActionButtonEnabled());
            if (this.myModel.isActionButtonEnabled()) {
                this.myActionButton.requestFocus();
            }
        }
        this.pack();
    }

    protected class KeyEventListener
    implements AWTEventListener {
        protected KeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (!AbstractProgressDialog.this.isFocused()) {
                return;
            }
            if (keyEvent.getID() == 401) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        if (AbstractProgressDialog.this.myActionButton == null || !AbstractProgressDialog.this.myActionButton.isEnabled()) break;
                        AbstractProgressDialog.this.fireGuiEvent(new ProgressGuiEvent("dialogcloseaction"));
                        break;
                    }
                }
            }
        }
    }

    public class ProgressWindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            AbstractProgressDialog.this.fireGuiEvent(new ProgressGuiEvent("dialogcloseaction"));
        }
    }
}

